/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.vertx;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.api.util.ListUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.vertx.VertxConstants;
import io.smallrye.openapi.vertx.VertxLogging;
import io.smallrye.openapi.vertx.VertxParameter;
import io.smallrye.openapi.vertx.VertxParameterProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class VertxAnnotationScanner
extends AbstractAnnotationScanner {
    private static final String VERTX_PACKAGE = "io.vertx.ext.web";

    public String getName() {
        return "Vert.x";
    }

    public boolean isAsyncResponse(MethodInfo method) {
        return false;
    }

    public boolean isPostMethod(MethodInfo method) {
        return this.hasRouteMethod(method, "POST");
    }

    public boolean isDeleteMethod(MethodInfo method) {
        return this.hasRouteMethod(method, "DELETE");
    }

    public boolean containsScannerAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
        for (AnnotationInstance instance : instances) {
            if (VertxParameter.isParameter(instance.name())) {
                return true;
            }
            if (instance.name().toString().startsWith(VERTX_PACKAGE) && !instance.name().equals((Object)VertxConstants.REQUEST_BODY)) {
                return true;
            }
            for (AnnotationScannerExtension extension : extensions) {
                if (!extension.isScannerAnnotationExtension(instance)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isScannerInternalParameter(Type parameterType) {
        return VertxConstants.INTERNAL_PARAMETERS.contains(parameterType.name());
    }

    public OpenAPI scan(AnnotationScannerContext context, OpenAPI openApi) {
        this.context = context;
        this.processRoutes(openApi);
        return openApi;
    }

    private boolean hasRouteMethod(MethodInfo method, String httpMethod) {
        if (method.hasAnnotation(VertxConstants.ROUTE)) {
            AnnotationInstance annotation = method.annotation(VertxConstants.ROUTE);
            AnnotationValue value = annotation.value("methods");
            return value != null && value.asEnumArray().length > 0 && Arrays.asList(value.asEnumArray()).contains(httpMethod);
        }
        return false;
    }

    private void processRoutes(OpenAPI openApi) {
        Collection routeAnnotations = this.context.getIndex().getAnnotations(VertxConstants.ROUTE);
        LinkedHashSet<ClassInfo> applications = new LinkedHashSet<ClassInfo>();
        for (AnnotationInstance annotationInstance : routeAnnotations) {
            if (annotationInstance.target().kind().equals((Object)AnnotationTarget.Kind.METHOD)) {
                ClassInfo classInfo = annotationInstance.target().asMethod().declaringClass();
                applications.add(classInfo);
                continue;
            }
            VertxLogging.log.ignoringAnnotation(VertxConstants.ROUTE.withoutPackagePrefix());
        }
        this.processScannerExtensions(this.context, applications);
        for (ClassInfo controller : applications) {
            OpenAPI applicationOpenApi = this.processRouteClass(controller);
            openApi = MergeUtil.merge((OpenAPI)openApi, (OpenAPI)applicationOpenApi);
        }
    }

    private OpenAPI processRouteClass(ClassInfo routeClass) {
        VertxLogging.log.processingRouteClass(routeClass.simpleName());
        TypeResolver resolver = TypeResolver.forClass((AnnotationScannerContext)this.context, (ClassInfo)routeClass, null);
        this.context.getResolverStack().push(resolver);
        AnnotationInstance routeBaseAnnotation = this.context.annotations().getAnnotation((AnnotationTarget)routeClass, new DotName[]{VertxConstants.ROUTE_BASE});
        this.currentAppPath = routeBaseAnnotation != null ? routeBaseAnnotation.value("path").asString() : "/";
        OpenAPI openApi = this.processDefinitionAnnotation(this.context, routeClass);
        this.processSecuritySchemeAnnotation(this.context, routeClass, openApi);
        this.processServerAnnotation(this.context, routeClass, openApi);
        this.processJavaSecurity(this.context, routeClass, openApi);
        this.processRouteMethods(routeClass, openApi, null);
        this.context.getResolverStack().pop();
        return openApi;
    }

    private void processRouteMethods(ClassInfo resourceClass, OpenAPI openApi, List<Parameter> locatorPathParameters) {
        Set tagRefs = this.processTags(this.context, (AnnotationTarget)resourceClass, openApi, false);
        this.getResourceMethods(this.context, resourceClass).stream().filter(m -> m.hasAnnotation(VertxConstants.ROUTE)).filter(this::shouldScan).forEach(methodInfo -> Optional.ofNullable((String[])this.context.annotations().getAnnotationValue((AnnotationTarget)methodInfo, VertxConstants.ROUTE, "methods")).map(methods -> Arrays.stream(methods).map(PathItem.HttpMethod::valueOf)).orElseGet(() -> Arrays.stream(PathItem.HttpMethod.values())).forEach(httpMethod -> this.processRouteMethod(resourceClass, (MethodInfo)methodInfo, (PathItem.HttpMethod)httpMethod, openApi, tagRefs, locatorPathParameters)));
    }

    public String[] getDefaultConsumes(AnnotationScannerContext context, MethodInfo methodInfo, ResourceParameters params) {
        return context.getConfig().getDefaultConsumes().orElseGet(ContentIO::defaultMediaTypes);
    }

    public String[] getDefaultProduces(AnnotationScannerContext context, MethodInfo methodInfo) {
        return context.getConfig().getDefaultProduces().orElseGet(ContentIO::defaultMediaTypes);
    }

    private void processRouteMethod(ClassInfo resourceClass, MethodInfo method, PathItem.HttpMethod methodType, OpenAPI openApi, Set<String> resourceTags, List<Parameter> locatorPathParameters) {
        VertxLogging.log.processingMethod(method.toString());
        String[] defaultConsumes = this.getDefaultConsumes(this.context, method, this.getResourceParameters(resourceClass, method));
        this.context.setDefaultConsumes(defaultConsumes);
        this.context.setCurrentConsumes((String[])this.getMediaTypes(method, "consumes", defaultConsumes).orElse(null));
        String[] defaultProduces = this.getDefaultProduces(this.context, method);
        this.context.setDefaultProduces(defaultProduces);
        this.context.setCurrentProduces((String[])this.getMediaTypes(method, "produces", defaultProduces).orElse(null));
        Optional maybeOperation = this.processOperation(this.context, resourceClass, method);
        if (!maybeOperation.isPresent()) {
            return;
        }
        Operation operation = (Operation)maybeOperation.get();
        this.processOperationTags(this.context, method, openApi, resourceTags, operation);
        PathItemImpl pathItem = new PathItemImpl();
        ResourceParameters params = this.getResourceParameters(resourceClass, method);
        operation.setParameters(params.getOperationParameters());
        pathItem.setParameters(ListUtil.mergeNullableLists((List[])new List[]{locatorPathParameters, params.getPathItemParameters()}));
        RequestBody requestBody = this.processRequestBody(this.context, method, params);
        if (requestBody != null) {
            operation.setRequestBody(requestBody);
        }
        this.processResponse(this.context, resourceClass, method, operation, null);
        this.processSecurityRequirementAnnotation(this.context, resourceClass, method, operation);
        this.processCallback(this.context, method, operation);
        this.processServerAnnotation(this.context, method, operation);
        this.processExtensions(this.context, method, operation);
        this.context.getJavaSecurityProcessor().processSecurityRoles(method, operation);
        pathItem.setOperation(methodType, operation);
        if (!VertxAnnotationScanner.processProfiles((OpenApiConfig)this.context.getConfig(), (Extensible)operation)) {
            return;
        }
        String path = super.makePath(params.getOperationPath());
        PathItem existingPath = ModelUtil.paths((OpenAPI)openApi).getPathItem(path);
        if (existingPath == null) {
            ModelUtil.paths((OpenAPI)openApi).addPathItem(path, (PathItem)pathItem);
        } else {
            MergeUtil.mergeObjects((Object)existingPath, (Object)pathItem);
        }
    }

    private ResourceParameters getResourceParameters(ClassInfo resourceClass, MethodInfo method) {
        Function<AnnotationInstance, Parameter> reader = t -> this.context.io().parameters().read(t);
        return VertxParameterProcessor.process(this.context, this.currentAppPath, resourceClass, method, reader, this.context.getExtensions());
    }

    boolean shouldScan(MethodInfo resourceMethod) {
        AnnotationInstance route = resourceMethod.annotation(VertxConstants.ROUTE);
        if ("FAILURE".equals(this.context.annotations().value(route, "type"))) {
            return false;
        }
        if (this.context.annotations().value(route, "regex") != null) {
            return Objects.nonNull(this.context.io().operations().getAnnotation((AnnotationTarget)resourceMethod));
        }
        return true;
    }

    Optional<String[]> getMediaTypes(MethodInfo resourceMethod, String property, String[] defaultValue) {
        DotName annotationName = VertxConstants.ROUTE;
        AnnotationInstance annotation = resourceMethod.annotation(annotationName);
        if (annotation == null || annotation.value(property) == null) {
            annotation = this.context.annotations().getAnnotation((AnnotationTarget)resourceMethod.declaringClass(), new DotName[]{VertxConstants.ROUTE_BASE});
        }
        if (annotation != null) {
            AnnotationValue annotationValue = annotation.value(property);
            if (annotationValue != null) {
                return Optional.of(annotationValue.asStringArray());
            }
            return Optional.of(defaultValue);
        }
        return Optional.empty();
    }
}

