/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.jaxrs2;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Json31;
import io.swagger.v3.core.util.ParameterProcessor;
import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.jaxrs2.OperationParser;
import io.swagger.v3.jaxrs2.ReaderListener;
import io.swagger.v3.jaxrs2.ResolvedParameter;
import io.swagger.v3.jaxrs2.SecurityParser;
import io.swagger.v3.jaxrs2.ext.OpenAPIExtension;
import io.swagger.v3.jaxrs2.ext.OpenAPIExtensions;
import io.swagger.v3.jaxrs2.util.ReaderUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Webhook;
import io.swagger.v3.oas.annotations.Webhooks;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.integration.ContextUtils;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiReader;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reader
implements OpenApiReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Reader.class);
    public static final String DEFAULT_MEDIA_TYPE_VALUE = "*/*";
    public static final String DEFAULT_DESCRIPTION = "default response";
    protected OpenAPIConfiguration config;
    private Application application;
    private OpenAPI openAPI = new OpenAPI();
    private Components components;
    private Paths paths = new Paths();
    private Set<io.swagger.v3.oas.models.tags.Tag> openApiTags = new LinkedHashSet<io.swagger.v3.oas.models.tags.Tag>();
    private static final String GET_METHOD = "get";
    private static final String POST_METHOD = "post";
    private static final String PUT_METHOD = "put";
    private static final String DELETE_METHOD = "delete";
    private static final String PATCH_METHOD = "patch";
    private static final String TRACE_METHOD = "trace";
    private static final String HEAD_METHOD = "head";
    private static final String OPTIONS_METHOD = "options";

    public Reader() {
        this.components = new Components();
    }

    public Reader(OpenAPI openAPI) {
        this();
        this.setConfiguration((OpenAPIConfiguration)new SwaggerConfiguration().openAPI(openAPI));
    }

    public Reader(OpenAPIConfiguration openApiConfiguration) {
        this();
        this.setConfiguration(openApiConfiguration);
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    public OpenAPI read(Class<?> cls) {
        return this.read(cls, this.resolveApplicationPath(), null, false, null, null, new LinkedHashSet<String>(), new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(), new HashSet());
    }

    public OpenAPI read(Set<Class<?>> classes) {
        TreeSet sortedClasses = new TreeSet((class1, class2) -> {
            if (class1.equals(class2)) {
                return 0;
            }
            if (class1.isAssignableFrom((Class<?>)class2)) {
                return -1;
            }
            if (class2.isAssignableFrom((Class<?>)class1)) {
                return 1;
            }
            return class1.getName().compareTo(class2.getName());
        });
        sortedClasses.addAll(classes);
        HashMap<Class, ReaderListener> listeners = new HashMap<Class, ReaderListener>();
        String appPath = "";
        for (Class clazz : sortedClasses) {
            ApplicationPath applicationPath;
            if (ReaderListener.class.isAssignableFrom(clazz) && !listeners.containsKey(clazz)) {
                try {
                    listeners.put(clazz, (ReaderListener)clazz.newInstance());
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to create ReaderListener", (Throwable)exception);
                }
            }
            if (this.config == null || !Boolean.TRUE.equals(this.config.isAlwaysResolveAppPath()) || !Application.class.isAssignableFrom(clazz) || (applicationPath = (ApplicationPath)ReflectionUtils.getAnnotation((Class)clazz, ApplicationPath.class)) == null) continue;
            appPath = applicationPath.value();
        }
        for (ReaderListener readerListener : listeners.values()) {
            try {
                readerListener.beforeScan(this, this.openAPI);
            }
            catch (Exception exception) {
                LOGGER.error("Unexpected error invoking beforeScan listener [" + readerListener.getClass().getName() + "]", (Throwable)exception);
            }
        }
        String appPathRuntime = this.resolveApplicationPath();
        if (StringUtils.isNotBlank((CharSequence)appPathRuntime)) {
            appPath = appPathRuntime;
        }
        for (Class clazz : sortedClasses) {
            this.read(clazz, appPath, null, false, null, null, new LinkedHashSet<String>(), new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(), new HashSet());
        }
        for (ReaderListener readerListener : listeners.values()) {
            try {
                readerListener.afterScan(this, this.openAPI);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error invoking afterScan listener [" + readerListener.getClass().getName() + "]", (Throwable)e);
            }
        }
        return this.openAPI;
    }

    public void setConfiguration(OpenAPIConfiguration openApiConfiguration) {
        if (openApiConfiguration != null) {
            this.config = ContextUtils.deepCopy((OpenAPIConfiguration)openApiConfiguration);
            if (openApiConfiguration.getOpenAPI() != null) {
                this.openAPI = this.config.getOpenAPI();
                if (this.openAPI.getComponents() != null) {
                    this.components = this.openAPI.getComponents();
                }
            }
        }
    }

    public OpenAPI read(Set<Class<?>> classes, Map<String, Object> resources) {
        return this.read(classes);
    }

    protected String resolveApplicationPath() {
        if (this.application != null) {
            ApplicationPath applicationPath;
            Class<?> applicationToScan = this.application.getClass();
            while ((applicationPath = applicationToScan.getAnnotation(ApplicationPath.class)) == null && !applicationToScan.getSuperclass().equals(Application.class)) {
                applicationToScan = applicationToScan.getSuperclass();
            }
            if (applicationPath != null && StringUtils.isNotBlank((CharSequence)applicationPath.value())) {
                return applicationPath.value();
            }
            try {
                Application retrievedApp;
                Application innerApp = this.application;
                Method m = this.application.getClass().getMethod("getApplication", new Class[0]);
                while (m != null && (retrievedApp = (Application)m.invoke((Object)innerApp, new Object[0])) != null && !retrievedApp.getClass().equals(innerApp.getClass())) {
                    innerApp = retrievedApp;
                    applicationPath = innerApp.getClass().getAnnotation(ApplicationPath.class);
                    if (applicationPath != null && StringUtils.isNotBlank((CharSequence)applicationPath.value())) {
                        return applicationPath.value();
                    }
                    m = innerApp.getClass().getMethod("getApplication", new Class[0]);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public OpenAPI read(Class<?> cls, String parentPath, String parentMethod, boolean isSubresource, RequestBody parentRequestBody, ApiResponses parentResponses, Set<String> parentTags, List<io.swagger.v3.oas.models.parameters.Parameter> parentParameters, Set<Class<?>> scannedResources) {
        Optional<List<SecurityRequirement>> requirementsObject;
        Hidden hidden = cls.getAnnotation(Hidden.class);
        Path apiPath = (Path)ReflectionUtils.getAnnotation(cls, Path.class);
        if (Boolean.TRUE.equals(this.config.isOpenAPI31())) {
            this.openAPI.setOpenapi("3.1.0");
        }
        if (hidden != null) {
            return this.openAPI;
        }
        io.swagger.v3.oas.annotations.responses.ApiResponse[] classResponses = (io.swagger.v3.oas.annotations.responses.ApiResponse[])ReflectionUtils.getRepeatableAnnotationsArray(cls, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        List apiSecurityScheme = ReflectionUtils.getRepeatableAnnotations(cls, SecurityScheme.class);
        List apiSecurityRequirements = ReflectionUtils.getRepeatableAnnotations(cls, io.swagger.v3.oas.annotations.security.SecurityRequirement.class);
        Webhooks webhooksAnnotation = (Webhooks)ReflectionUtils.getAnnotation(cls, Webhooks.class);
        io.swagger.v3.oas.annotations.ExternalDocumentation apiExternalDocs = (io.swagger.v3.oas.annotations.ExternalDocumentation)ReflectionUtils.getAnnotation(cls, io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        Tag[] apiTags = (Tag[])ReflectionUtils.getRepeatableAnnotationsArray(cls, Tag.class);
        io.swagger.v3.oas.annotations.servers.Server[] apiServers = (io.swagger.v3.oas.annotations.servers.Server[])ReflectionUtils.getRepeatableAnnotationsArray(cls, io.swagger.v3.oas.annotations.servers.Server.class);
        Consumes classConsumes = (Consumes)ReflectionUtils.getAnnotation(cls, Consumes.class);
        Produces classProduces = (Produces)ReflectionUtils.getAnnotation(cls, Produces.class);
        boolean classDeprecated = ReflectionUtils.getAnnotation(cls, Deprecated.class) != null;
        OpenAPIDefinition openAPIDefinition = (OpenAPIDefinition)ReflectionUtils.getAnnotation(cls, OpenAPIDefinition.class);
        if (openAPIDefinition != null) {
            AnnotationsUtils.getInfo((Info)openAPIDefinition.info()).ifPresent(info -> this.openAPI.setInfo(info));
            SecurityParser.getSecurityRequirements(openAPIDefinition.security()).ifPresent(s -> this.openAPI.setSecurity(s));
            AnnotationsUtils.getExternalDocumentation((io.swagger.v3.oas.annotations.ExternalDocumentation)openAPIDefinition.externalDocs()).ifPresent(docs -> this.openAPI.setExternalDocs(docs));
            AnnotationsUtils.getTags((Tag[])openAPIDefinition.tags(), (boolean)false).ifPresent(tags -> this.openApiTags.addAll((Collection<io.swagger.v3.oas.models.tags.Tag>)tags));
            AnnotationsUtils.getServers((io.swagger.v3.oas.annotations.servers.Server[])openAPIDefinition.servers()).ifPresent(servers -> this.openAPI.setServers(servers));
            if (openAPIDefinition.extensions().length > 0) {
                this.openAPI.setExtensions(AnnotationsUtils.getExtensions((Extension[])openAPIDefinition.extensions()));
            }
        }
        if (apiSecurityScheme != null) {
            for (SecurityScheme securitySchemeAnnotation : apiSecurityScheme) {
                Optional<SecurityParser.SecuritySchemePair> securityScheme = SecurityParser.getSecurityScheme(securitySchemeAnnotation);
                if (!securityScheme.isPresent()) continue;
                HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme> securitySchemeMap = new HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme>();
                if (!StringUtils.isNotBlank((CharSequence)securityScheme.get().key)) continue;
                securitySchemeMap.put(securityScheme.get().key, securityScheme.get().securityScheme);
                if (this.components.getSecuritySchemes() != null && this.components.getSecuritySchemes().size() != 0) {
                    this.components.getSecuritySchemes().putAll(securitySchemeMap);
                    continue;
                }
                this.components.setSecuritySchemes(securitySchemeMap);
            }
        }
        ArrayList<SecurityRequirement> classSecurityRequirements = new ArrayList();
        if (apiSecurityRequirements != null && (requirementsObject = SecurityParser.getSecurityRequirements(apiSecurityRequirements.toArray(new io.swagger.v3.oas.annotations.security.SecurityRequirement[apiSecurityRequirements.size()]))).isPresent()) {
            classSecurityRequirements = requirementsObject.get();
        }
        LinkedHashSet<String> classTags = new LinkedHashSet<String>();
        if (apiTags != null) {
            AnnotationsUtils.getTags((Tag[])apiTags, (boolean)false).ifPresent(tags -> tags.stream().map(io.swagger.v3.oas.models.tags.Tag::getName).forEach(classTags::add));
        }
        if (isSubresource && parentTags != null) {
            classTags.addAll(parentTags);
        }
        ArrayList<Server> classServers = new ArrayList<Server>();
        if (apiServers != null) {
            AnnotationsUtils.getServers((io.swagger.v3.oas.annotations.servers.Server[])apiServers).ifPresent(classServers::addAll);
        }
        Optional classExternalDocumentation = AnnotationsUtils.getExternalDocumentation((io.swagger.v3.oas.annotations.ExternalDocumentation)apiExternalDocs);
        JavaType classType = TypeFactory.defaultInstance().constructType(cls);
        BeanDescription bd = Boolean.TRUE.equals(this.config.isOpenAPI31()) ? Json31.mapper().getSerializationConfig().introspect(classType) : Json.mapper().getSerializationConfig().introspect(classType);
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> globalParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        globalParameters.addAll(ReaderUtils.collectConstructorParameters(cls, this.components, classConsumes, null));
        globalParameters.addAll(ReaderUtils.collectFieldParameters(cls, this.components, classConsumes, null));
        List methods = Arrays.stream(cls.getMethods()).sorted(new MethodComparator()).collect(Collectors.toList());
        for (Method method : methods) {
            ResolvedParameter resolvedParameter;
            Object paramType;
            Parameter paramAnnotation;
            Object type;
            io.swagger.v3.oas.models.Operation operation;
            JsonView jsonViewAnnotationForRequestBody;
            JsonView jsonViewAnnotation;
            Operation apiOperation;
            LinkedHashMap<String, String> regexMap;
            if (this.isOperationHidden(method)) continue;
            AnnotatedMethod annotatedMethod = bd.findMethod(method.getName(), (Class[])method.getParameterTypes());
            Produces methodProduces = (Produces)ReflectionUtils.getAnnotation((Method)method, Produces.class);
            Consumes methodConsumes = (Consumes)ReflectionUtils.getAnnotation((Method)method, Consumes.class);
            if (this.isMethodOverridden(method, cls)) continue;
            boolean methodDeprecated = ReflectionUtils.getAnnotation((Method)method, Deprecated.class) != null;
            Path methodPath = (Path)ReflectionUtils.getAnnotation((Method)method, Path.class);
            String operationPath = ReaderUtils.getPath(apiPath, methodPath, parentPath, isSubresource);
            if (this.ignoreOperationPath(operationPath, parentPath) && !isSubresource || (operationPath = PathUtils.parsePath((String)operationPath, regexMap = new LinkedHashMap<String, String>())) == null || this.config != null && ReaderUtils.isIgnored(operationPath, this.config)) continue;
            Class<?> subResource = this.getSubResourceWithJaxRsSubresourceLocatorSpecs(method);
            String httpMethod = ReaderUtils.extractOperationMethod(method, OpenAPIExtensions.chain());
            String string = httpMethod = httpMethod == null && isSubresource ? parentMethod : httpMethod;
            if (StringUtils.isBlank((CharSequence)httpMethod) && subResource == null) continue;
            if (StringUtils.isBlank((CharSequence)httpMethod) && subResource != null) {
                Type returnType = method.getGenericReturnType();
                if (annotatedMethod != null && annotatedMethod.getType() != null) {
                    returnType = annotatedMethod.getType();
                }
                if (this.shouldIgnoreClass(returnType.getTypeName()) && !method.getGenericReturnType().equals(subResource)) continue;
            }
            if ((apiOperation = (Operation)ReflectionUtils.getAnnotation((Method)method, Operation.class)) != null && apiOperation.ignoreJsonView()) {
                jsonViewAnnotation = null;
                jsonViewAnnotationForRequestBody = null;
            } else {
                jsonViewAnnotation = (JsonView)ReflectionUtils.getAnnotation((Method)method, JsonView.class);
                jsonViewAnnotationForRequestBody = (JsonView)Arrays.stream(ReflectionUtils.getParameterAnnotations((Method)method)).filter(arr -> Arrays.stream(arr).anyMatch(annotation -> annotation.annotationType().equals(io.swagger.v3.oas.annotations.parameters.RequestBody.class))).flatMap(Arrays::stream).filter(annotation -> annotation.annotationType().equals(JsonView.class)).reduce((a, b) -> null).orElse((Annotation)jsonViewAnnotation);
            }
            if ((operation = this.parseMethod(method, globalParameters, methodProduces, classProduces, methodConsumes, classConsumes, classSecurityRequirements, classExternalDocumentation, classTags, classServers, isSubresource, parentRequestBody, parentResponses, jsonViewAnnotation, classResponses, annotatedMethod)) == null) continue;
            if (classDeprecated || methodDeprecated) {
                operation.setDeprecated(Boolean.valueOf(true));
            }
            ArrayList<io.swagger.v3.oas.models.parameters.Parameter> operationParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
            ArrayList<io.swagger.v3.oas.models.parameters.Parameter> formParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
            Annotation[][] paramAnnotations = ReflectionUtils.getParameterAnnotations((Method)method);
            if (annotatedMethod == null) {
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                for (int i = 0; i < genericParameterTypes.length; ++i) {
                    type = TypeFactory.defaultInstance().constructType(genericParameterTypes[i], cls);
                    paramAnnotation = (Parameter)AnnotationsUtils.getAnnotation(Parameter.class, (Annotation[])paramAnnotations[i]);
                    paramType = ParameterProcessor.getParameterType((Parameter)paramAnnotation, (boolean)true);
                    if (paramType == null) {
                        paramType = type;
                    } else if (!(paramType instanceof Class)) {
                        paramType = type;
                    }
                    resolvedParameter = this.getParameters((Type)paramType, Arrays.asList(paramAnnotations[i]), operation, classConsumes, methodConsumes, jsonViewAnnotation);
                    operationParameters.addAll(resolvedParameter.parameters);
                    formParameters.addAll(resolvedParameter.formParameters);
                    if (resolvedParameter.requestBody == null) continue;
                    this.processRequestBody(resolvedParameter.requestBody, operation, methodConsumes, classConsumes, operationParameters, paramAnnotations[i], (Type)type, jsonViewAnnotationForRequestBody, null);
                }
            } else {
                for (int i = 0; i < annotatedMethod.getParameterCount(); ++i) {
                    AnnotatedParameter param = annotatedMethod.getParameter(i);
                    type = TypeFactory.defaultInstance().constructType(param.getParameterType(), cls);
                    paramAnnotation = (Parameter)AnnotationsUtils.getAnnotation(Parameter.class, (Annotation[])paramAnnotations[i]);
                    paramType = ParameterProcessor.getParameterType((Parameter)paramAnnotation, (boolean)true);
                    if (paramType == null) {
                        paramType = type;
                    } else if (!(paramType instanceof Class)) {
                        paramType = type;
                    }
                    resolvedParameter = this.getParameters((Type)paramType, Arrays.asList(paramAnnotations[i]), operation, classConsumes, methodConsumes, jsonViewAnnotation);
                    operationParameters.addAll(resolvedParameter.parameters);
                    formParameters.addAll(resolvedParameter.formParameters);
                    if (resolvedParameter.requestBody == null) continue;
                    this.processRequestBody(resolvedParameter.requestBody, operation, methodConsumes, classConsumes, operationParameters, paramAnnotations[i], (Type)type, jsonViewAnnotationForRequestBody, null);
                }
            }
            if (!formParameters.isEmpty()) {
                ObjectSchema mergedSchema = new ObjectSchema();
                LinkedHashMap<String, Encoding> encoding = new LinkedHashMap<String, Encoding>();
                for (io.swagger.v3.oas.models.parameters.Parameter formParam : formParameters) {
                    if (formParam.getExplode() != null || formParam.getStyle() != null && Encoding.StyleEnum.fromString((String)formParam.getStyle().toString()) != null) {
                        Encoding e = new Encoding();
                        if (formParam.getExplode() != null) {
                            e.explode(formParam.getExplode());
                        }
                        if (formParam.getStyle() != null && Encoding.StyleEnum.fromString((String)formParam.getStyle().toString()) != null) {
                            e.style(Encoding.StyleEnum.fromString((String)formParam.getStyle().toString()));
                        }
                        encoding.put(formParam.getName(), e);
                    }
                    mergedSchema.addProperties(formParam.getName(), formParam.getSchema());
                    if (formParam.getSchema() != null && StringUtils.isNotBlank((CharSequence)formParam.getDescription()) && StringUtils.isBlank((CharSequence)formParam.getSchema().getDescription())) {
                        formParam.getSchema().description(formParam.getDescription());
                    }
                    if (null == formParam.getRequired() || !formParam.getRequired().booleanValue()) continue;
                    mergedSchema.addRequiredItem(formParam.getName());
                }
                io.swagger.v3.oas.models.parameters.Parameter merged = new io.swagger.v3.oas.models.parameters.Parameter().schema((Schema)mergedSchema);
                this.processRequestBody(merged, operation, methodConsumes, classConsumes, operationParameters, new Annotation[0], null, jsonViewAnnotationForRequestBody, encoding);
            }
            if (!operationParameters.isEmpty()) {
                for (io.swagger.v3.oas.models.parameters.Parameter operationParameter : operationParameters) {
                    operation.addParametersItem(operationParameter);
                }
            }
            if (parentParameters != null) {
                for (io.swagger.v3.oas.models.parameters.Parameter parentParameter : parentParameters) {
                    operation.addParametersItem(parentParameter);
                }
            }
            if (subResource != null && !scannedResources.contains(subResource)) {
                scannedResources.add(subResource);
                this.read(subResource, operationPath, httpMethod, true, operation.getRequestBody(), operation.getResponses(), classTags, operation.getParameters(), scannedResources);
                scannedResources.remove(subResource);
                continue;
            }
            Iterator<OpenAPIExtension> chain = OpenAPIExtensions.chain();
            if (chain.hasNext()) {
                OpenAPIExtension extension = chain.next();
                extension.decorateOperation(operation, method, chain);
            }
            PathItem pathItemObject = this.openAPI.getPaths() != null && this.openAPI.getPaths().get((Object)operationPath) != null ? (PathItem)this.openAPI.getPaths().get((Object)operationPath) : new PathItem();
            if (StringUtils.isBlank((CharSequence)httpMethod)) continue;
            this.setPathItemOperation(pathItemObject, httpMethod, operation);
            this.applyPathParamsPatterns(operation, regexMap);
            this.paths.addPathItem(operationPath, pathItemObject);
            if (this.openAPI.getPaths() != null) {
                this.paths.putAll((Map)this.openAPI.getPaths());
            }
            this.openAPI.setPaths(this.paths);
        }
        if (webhooksAnnotation != null && webhooksAnnotation.value().length > 0) {
            HashMap<String, PathItem> webhooks = new HashMap<String, PathItem>();
            for (Webhook webhookAnnotation : webhooksAnnotation.value()) {
                Operation apiOperation = webhookAnnotation.operation();
                PathItem pathItemObject = new PathItem();
                io.swagger.v3.oas.models.Operation operation = new io.swagger.v3.oas.models.Operation();
                this.setOperationObjectFromApiOperationAnnotation(operation, apiOperation, null, classProduces, null, classConsumes, null);
                pathItemObject.post(operation);
                webhooks.put(webhookAnnotation.name(), pathItemObject);
            }
            if (!webhooks.isEmpty()) {
                this.openAPI.setWebhooks(webhooks);
            }
        }
        if (!this.isEmptyComponents(this.components) && this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(this.components);
        }
        AnnotationsUtils.getTags((Tag[])apiTags, (boolean)true).ifPresent(tags -> this.openApiTags.addAll((Collection<io.swagger.v3.oas.models.tags.Tag>)tags));
        if (!this.openApiTags.isEmpty()) {
            LinkedHashSet<io.swagger.v3.oas.models.tags.Tag> tagsSet = new LinkedHashSet<io.swagger.v3.oas.models.tags.Tag>();
            if (this.openAPI.getTags() != null) {
                for (io.swagger.v3.oas.models.tags.Tag tag : this.openAPI.getTags()) {
                    if (!tagsSet.stream().noneMatch(t -> t.getName().equals(tag.getName()))) continue;
                    tagsSet.add(tag);
                }
            }
            for (io.swagger.v3.oas.models.tags.Tag tag : this.openApiTags) {
                if (!tagsSet.stream().noneMatch(t -> t.getName().equals(tag.getName()))) continue;
                tagsSet.add(tag);
            }
            this.openAPI.setTags(new ArrayList(tagsSet));
        }
        return this.openAPI;
    }

    protected void applyPathParamsPatterns(io.swagger.v3.oas.models.Operation operation, Map<String, String> patternsMap) {
        if (operation.getParameters() == null) {
            return;
        }
        operation.getParameters().stream().filter(p -> patternsMap.containsKey(p.getName())).filter(p -> "path".equals(p.getIn())).filter(p -> p.getSchema() != null).filter(p -> StringUtils.isBlank((CharSequence)p.getSchema().getPattern())).filter(p -> !Parameter.StyleEnum.MATRIX.equals((Object)p.getStyle())).filter(p -> "string" == p.getSchema().getType() || p.getSchema().getTypes() != null && p.getSchema().getTypes().contains("string")).forEach(p -> p.getSchema().setPattern((String)patternsMap.get(p.getName())));
    }

    protected Content processContent(Content content, Schema schema, Consumes methodConsumes, Consumes classConsumes) {
        if (content == null) {
            content = new Content();
        }
        if (methodConsumes != null) {
            for (String value : methodConsumes.value()) {
                this.setMediaTypeToContent(schema, content, value);
            }
        } else if (classConsumes != null) {
            for (String value : classConsumes.value()) {
                this.setMediaTypeToContent(schema, content, value);
            }
        } else {
            this.setMediaTypeToContent(schema, content, DEFAULT_MEDIA_TYPE_VALUE);
        }
        return content;
    }

    protected void processRequestBody(io.swagger.v3.oas.models.parameters.Parameter requestBodyParameter, io.swagger.v3.oas.models.Operation operation, Consumes methodConsumes, Consumes classConsumes, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters, Annotation[] paramAnnotations, Type type, JsonView jsonViewAnnotation, Map<String, Encoding> encoding) {
        Object content;
        RequestBody requestBody;
        io.swagger.v3.oas.annotations.parameters.RequestBody requestBodyAnnotation = this.getRequestBody(Arrays.asList(paramAnnotations));
        if (requestBodyAnnotation != null) {
            Optional<RequestBody> optionalRequestBody = OperationParser.getRequestBody(requestBodyAnnotation, classConsumes, methodConsumes, this.components, jsonViewAnnotation);
            if (optionalRequestBody.isPresent()) {
                requestBody = optionalRequestBody.get();
                if (StringUtils.isBlank((CharSequence)requestBody.get$ref()) && (requestBody.getContent() == null || requestBody.getContent().isEmpty())) {
                    if (requestBodyParameter.getSchema() != null) {
                        content = this.processContent(requestBody.getContent(), requestBodyParameter.getSchema(), methodConsumes, classConsumes);
                        requestBody.setContent((Content)content);
                    }
                } else if (StringUtils.isBlank((CharSequence)requestBody.get$ref()) && requestBody.getContent() != null && !requestBody.getContent().isEmpty() && requestBodyParameter.getSchema() != null) {
                    for (MediaType mediaType : requestBody.getContent().values()) {
                        if (mediaType.getSchema() == null) {
                            if (requestBodyParameter.getSchema() == null) {
                                mediaType.setSchema(new Schema());
                            } else {
                                mediaType.setSchema(requestBodyParameter.getSchema());
                            }
                        }
                        if (!StringUtils.isBlank((CharSequence)mediaType.getSchema().getType())) continue;
                        mediaType.getSchema().setType(requestBodyParameter.getSchema().getType());
                    }
                }
                operation.setRequestBody(requestBody);
            }
        } else if (operation.getRequestBody() == null) {
            boolean isRequestBodyEmpty = true;
            requestBody = new RequestBody();
            if (StringUtils.isNotBlank((CharSequence)requestBodyParameter.get$ref())) {
                requestBody.set$ref(requestBodyParameter.get$ref());
                isRequestBodyEmpty = false;
            }
            if (StringUtils.isNotBlank((CharSequence)requestBodyParameter.getDescription())) {
                requestBody.setDescription(requestBodyParameter.getDescription());
                isRequestBodyEmpty = false;
            }
            if (Boolean.TRUE.equals(requestBodyParameter.getRequired())) {
                requestBody.setRequired(requestBodyParameter.getRequired());
                isRequestBodyEmpty = false;
            }
            if (requestBodyParameter.getSchema() != null) {
                content = this.processContent(null, requestBodyParameter.getSchema(), methodConsumes, classConsumes);
                requestBody.setContent((Content)content);
                isRequestBodyEmpty = false;
            }
            if (!isRequestBodyEmpty) {
                operation.setRequestBody(requestBody);
            }
        }
        if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null && encoding != null && !encoding.isEmpty()) {
            Content content2 = operation.getRequestBody().getContent();
            for (String mediaKey : content2.keySet()) {
                if (!mediaKey.equals("application/x-www-form-urlencoded") && !mediaKey.equals("multipart/form-data")) continue;
                MediaType m = (MediaType)content2.get((Object)mediaKey);
                m.encoding(encoding);
            }
        }
    }

    private io.swagger.v3.oas.annotations.parameters.RequestBody getRequestBody(List<Annotation> annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation a : annotations) {
            if (!(a instanceof io.swagger.v3.oas.annotations.parameters.RequestBody)) continue;
            return (io.swagger.v3.oas.annotations.parameters.RequestBody)a;
        }
        return null;
    }

    private void setMediaTypeToContent(Schema schema, Content content, String value) {
        MediaType mediaTypeObject = new MediaType();
        mediaTypeObject.setSchema(schema);
        content.addMediaType(value, mediaTypeObject);
    }

    public io.swagger.v3.oas.models.Operation parseMethod(Method method, List<io.swagger.v3.oas.models.parameters.Parameter> globalParameters, JsonView jsonViewAnnotation) {
        JavaType classType = TypeFactory.defaultInstance().constructType(method.getDeclaringClass());
        return this.parseMethod(classType.getClass(), method, globalParameters, null, null, null, null, new ArrayList<SecurityRequirement>(), Optional.empty(), new HashSet<String>(), new ArrayList<Server>(), false, null, null, jsonViewAnnotation, null, null);
    }

    public io.swagger.v3.oas.models.Operation parseMethod(Method method, List<io.swagger.v3.oas.models.parameters.Parameter> globalParameters, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, List<SecurityRequirement> classSecurityRequirements, Optional<ExternalDocumentation> classExternalDocs, Set<String> classTags, List<Server> classServers, boolean isSubresource, RequestBody parentRequestBody, ApiResponses parentResponses, JsonView jsonViewAnnotation, io.swagger.v3.oas.annotations.responses.ApiResponse[] classResponses) {
        JavaType classType = TypeFactory.defaultInstance().constructType(method.getDeclaringClass());
        return this.parseMethod(classType.getClass(), method, globalParameters, methodProduces, classProduces, methodConsumes, classConsumes, classSecurityRequirements, classExternalDocs, classTags, classServers, isSubresource, parentRequestBody, parentResponses, jsonViewAnnotation, classResponses, null);
    }

    public io.swagger.v3.oas.models.Operation parseMethod(Method method, List<io.swagger.v3.oas.models.parameters.Parameter> globalParameters, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, List<SecurityRequirement> classSecurityRequirements, Optional<ExternalDocumentation> classExternalDocs, Set<String> classTags, List<Server> classServers, boolean isSubresource, RequestBody parentRequestBody, ApiResponses parentResponses, JsonView jsonViewAnnotation, io.swagger.v3.oas.annotations.responses.ApiResponse[] classResponses, AnnotatedMethod annotatedMethod) {
        JavaType classType = TypeFactory.defaultInstance().constructType(method.getDeclaringClass());
        return this.parseMethod(classType.getClass(), method, globalParameters, methodProduces, classProduces, methodConsumes, classConsumes, classSecurityRequirements, classExternalDocs, classTags, classServers, isSubresource, parentRequestBody, parentResponses, jsonViewAnnotation, classResponses, annotatedMethod);
    }

    protected io.swagger.v3.oas.models.Operation parseMethod(Class<?> cls, Method method, List<io.swagger.v3.oas.models.parameters.Parameter> globalParameters, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, List<SecurityRequirement> classSecurityRequirements, Optional<ExternalDocumentation> classExternalDocs, Set<String> classTags, List<Server> classServers, boolean isSubresource, RequestBody parentRequestBody, ApiResponses parentResponses, JsonView jsonViewAnnotation, io.swagger.v3.oas.annotations.responses.ApiResponse[] classResponses, AnnotatedMethod annotatedMethod) {
        Object requirementsObject;
        io.swagger.v3.oas.models.Operation operation = new io.swagger.v3.oas.models.Operation();
        Operation apiOperation = (Operation)ReflectionUtils.getAnnotation((Method)method, Operation.class);
        List apiSecurity = ReflectionUtils.getRepeatableAnnotations((Method)method, io.swagger.v3.oas.annotations.security.SecurityRequirement.class);
        List apiCallbacks = ReflectionUtils.getRepeatableAnnotations((Method)method, io.swagger.v3.oas.annotations.callbacks.Callback.class);
        List apiServers = ReflectionUtils.getRepeatableAnnotations((Method)method, io.swagger.v3.oas.annotations.servers.Server.class);
        List apiTags = ReflectionUtils.getRepeatableAnnotations((Method)method, Tag.class);
        List apiParameters = ReflectionUtils.getRepeatableAnnotations((Method)method, Parameter.class);
        List apiResponses = ReflectionUtils.getRepeatableAnnotations((Method)method, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        io.swagger.v3.oas.annotations.parameters.RequestBody apiRequestBody = (io.swagger.v3.oas.annotations.parameters.RequestBody)ReflectionUtils.getAnnotation((Method)method, io.swagger.v3.oas.annotations.parameters.RequestBody.class);
        io.swagger.v3.oas.annotations.ExternalDocumentation apiExternalDocumentation = (io.swagger.v3.oas.annotations.ExternalDocumentation)ReflectionUtils.getAnnotation((Method)method, io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        LinkedHashMap<String, Callback> callbacks = new LinkedHashMap<String, Callback>();
        if (apiCallbacks != null) {
            for (io.swagger.v3.oas.annotations.callbacks.Callback callback : apiCallbacks) {
                Map<String, Callback> currentCallbacks = this.getCallbacks(callback, methodProduces, classProduces, methodConsumes, classConsumes, jsonViewAnnotation);
                callbacks.putAll(currentCallbacks);
            }
        }
        if (callbacks.size() > 0) {
            operation.setCallbacks(callbacks);
        }
        classSecurityRequirements.forEach(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).addSecurityItem(arg_0));
        if (apiSecurity != null && ((Optional)(requirementsObject = SecurityParser.getSecurityRequirements(apiSecurity.toArray(new io.swagger.v3.oas.annotations.security.SecurityRequirement[apiSecurity.size()])))).isPresent()) {
            ((Optional)requirementsObject).get().stream().filter(r -> operation.getSecurity() == null || !operation.getSecurity().contains(r)).forEach(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).addSecurityItem(arg_0));
        }
        if (classServers != null) {
            classServers.forEach(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).addServersItem(arg_0));
        }
        if (apiServers != null) {
            AnnotationsUtils.getServers((io.swagger.v3.oas.annotations.servers.Server[])apiServers.toArray(new io.swagger.v3.oas.annotations.servers.Server[apiServers.size()])).ifPresent(servers -> servers.forEach(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).addServersItem(arg_0)));
        }
        AnnotationsUtils.getExternalDocumentation((io.swagger.v3.oas.annotations.ExternalDocumentation)apiExternalDocumentation).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).setExternalDocs(arg_0));
        if (apiTags != null) {
            apiTags.stream().filter(t -> operation.getTags() == null || operation.getTags() != null && !operation.getTags().contains(t.name())).map(Tag::name).forEach(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).addTagsItem(arg_0));
            AnnotationsUtils.getTags((Tag[])apiTags.toArray(new Tag[apiTags.size()]), (boolean)true).ifPresent(tags -> this.openApiTags.addAll((Collection<io.swagger.v3.oas.models.tags.Tag>)tags));
        }
        if (globalParameters != null) {
            for (io.swagger.v3.oas.models.parameters.Parameter parameter : globalParameters) {
                operation.addParametersItem(parameter);
            }
        }
        if (apiParameters != null) {
            this.getParametersListFromAnnotation(apiParameters.toArray(new Parameter[apiParameters.size()]), classConsumes, methodConsumes, operation, jsonViewAnnotation).ifPresent(p -> p.forEach(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).addParametersItem(arg_0)));
        }
        if (apiRequestBody != null && operation.getRequestBody() == null) {
            OperationParser.getRequestBody(apiRequestBody, classConsumes, methodConsumes, this.components, jsonViewAnnotation).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).setRequestBody(arg_0));
        }
        if (StringUtils.isBlank((CharSequence)operation.getOperationId())) {
            operation.setOperationId(this.getOperationId(method.getName()));
        }
        if (classResponses != null && classResponses.length > 0) {
            OperationParser.getApiResponses(classResponses, classProduces, methodProduces, this.components, jsonViewAnnotation).ifPresent(responses -> {
                if (operation.getResponses() == null) {
                    operation.setResponses(responses);
                } else {
                    responses.forEach((arg_0, arg_1) -> ((ApiResponses)operation.getResponses()).addApiResponse(arg_0, arg_1));
                }
            });
        }
        if (apiOperation != null) {
            this.setOperationObjectFromApiOperationAnnotation(operation, apiOperation, methodProduces, classProduces, methodConsumes, classConsumes, jsonViewAnnotation);
        }
        if (apiResponses != null && !apiResponses.isEmpty()) {
            OperationParser.getApiResponses(apiResponses.toArray(new io.swagger.v3.oas.annotations.responses.ApiResponse[apiResponses.size()]), classProduces, methodProduces, this.components, jsonViewAnnotation).ifPresent(responses -> {
                if (operation.getResponses() == null) {
                    operation.setResponses(responses);
                } else {
                    responses.forEach((arg_0, arg_1) -> ((ApiResponses)operation.getResponses()).addApiResponse(arg_0, arg_1));
                }
            });
        }
        if (classTags != null) {
            classTags.stream().filter(t -> operation.getTags() == null || operation.getTags() != null && !operation.getTags().contains(t)).forEach(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).addTagsItem(arg_0));
        }
        if (operation.getExternalDocs() == null) {
            classExternalDocs.ifPresent(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).setExternalDocs(arg_0));
        }
        if (isSubresource && parentRequestBody != null) {
            if (operation.getRequestBody() == null) {
                operation.requestBody(parentRequestBody);
            } else {
                Content content = operation.getRequestBody().getContent();
                if (content == null) {
                    content = parentRequestBody.getContent();
                    operation.getRequestBody().setContent(content);
                } else if (parentRequestBody.getContent() != null) {
                    for (String parentMediaType : parentRequestBody.getContent().keySet()) {
                        if (content.get((Object)parentMediaType) != null) continue;
                        content.addMediaType(parentMediaType, (MediaType)parentRequestBody.getContent().get((Object)parentMediaType));
                    }
                }
            }
        }
        Type returnType = method.getGenericReturnType();
        if (annotatedMethod != null && annotatedMethod.getType() != null) {
            returnType = this.extractTypeFromMethod(annotatedMethod);
        }
        Class<?> clazz = this.getSubResourceWithJaxRsSubresourceLocatorSpecs(method);
        Schema returnTypeSchema = null;
        if (!this.shouldIgnoreClass(returnType.getTypeName()) && !method.getGenericReturnType().equals(clazz)) {
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(returnType).resolveAsRef(true).jsonViewAnnotation(jsonViewAnnotation));
            if (resolvedSchema.schema != null) {
                Map schemaMap;
                returnTypeSchema = resolvedSchema.schema;
                Content content = new Content();
                MediaType mediaType = new MediaType().schema(returnTypeSchema);
                AnnotationsUtils.applyTypes((String[])(classProduces == null ? new String[]{} : classProduces.value()), (String[])(methodProduces == null ? new String[]{} : methodProduces.value()), (Content)content, (MediaType)mediaType);
                if (operation.getResponses() == null) {
                    operation.responses(new ApiResponses()._default(new ApiResponse().description(DEFAULT_DESCRIPTION).content(content)));
                }
                if (operation.getResponses().getDefault() != null && StringUtils.isBlank((CharSequence)operation.getResponses().getDefault().get$ref())) {
                    if (operation.getResponses().getDefault().getContent() == null) {
                        operation.getResponses().getDefault().content(content);
                    } else {
                        for (String key2 : operation.getResponses().getDefault().getContent().keySet()) {
                            if (((MediaType)operation.getResponses().getDefault().getContent().get((Object)key2)).getSchema() != null) continue;
                            ((MediaType)operation.getResponses().getDefault().getContent().get((Object)key2)).setSchema(returnTypeSchema);
                        }
                    }
                }
                if ((schemaMap = resolvedSchema.referencedSchemas) != null) {
                    schemaMap.forEach((key, schema) -> this.components.addSchemas(key, schema));
                }
            }
        }
        if (operation.getResponses() == null || operation.getResponses().isEmpty()) {
            Content content = this.resolveEmptyContent(classProduces, methodProduces);
            ApiResponse apiResponseObject = new ApiResponse().description(DEFAULT_DESCRIPTION).content(content);
            operation.setResponses(new ApiResponses()._default(apiResponseObject));
        }
        if (returnTypeSchema != null) {
            this.resolveResponseSchemaFromReturnType(operation, classResponses, returnTypeSchema, classProduces, methodProduces);
            if (apiResponses != null) {
                this.resolveResponseSchemaFromReturnType(operation, (io.swagger.v3.oas.annotations.responses.ApiResponse[])apiResponses.stream().toArray(io.swagger.v3.oas.annotations.responses.ApiResponse[]::new), returnTypeSchema, classProduces, methodProduces);
            }
        }
        return operation;
    }

    private Type extractTypeFromMethod(AnnotatedMethod annotatedMethod) {
        if (CompletionStage.class.isAssignableFrom(annotatedMethod.getType().getRawClass())) {
            return annotatedMethod.getType().getBindings().getBoundType(0);
        }
        return annotatedMethod.getType();
    }

    protected Content resolveEmptyContent(Produces classProduces, Produces methodProduces) {
        Content content = new Content();
        MediaType mediaType = new MediaType();
        AnnotationsUtils.applyTypes((String[])(classProduces == null ? new String[]{} : classProduces.value()), (String[])(methodProduces == null ? new String[]{} : methodProduces.value()), (Content)content, (MediaType)mediaType);
        return content;
    }

    protected void resolveResponseSchemaFromReturnType(io.swagger.v3.oas.models.Operation operation, io.swagger.v3.oas.annotations.responses.ApiResponse[] responses, Schema schema, Produces classProduces, Produces methodProduces) {
        if (responses != null) {
            for (io.swagger.v3.oas.annotations.responses.ApiResponse response : responses) {
                ApiResponse opResponse;
                if (!response.useReturnTypeSchema() || (opResponse = (ApiResponse)operation.getResponses().get((Object)response.responseCode())) == null) continue;
                if (opResponse.getContent() != null) {
                    for (MediaType mediaType : opResponse.getContent().values()) {
                        mediaType.schema(schema);
                    }
                    continue;
                }
                Content content = this.resolveEmptyContent(classProduces, methodProduces);
                for (MediaType mediaType : content.values()) {
                    mediaType.schema(schema);
                }
                opResponse.content(content);
            }
        }
    }

    private boolean shouldIgnoreClass(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return true;
        }
        boolean ignore = false;
        String rawClassName = className;
        if (rawClassName.startsWith("[")) {
            rawClassName = className.replace("[simple type, class ", "");
            rawClassName = rawClassName.substring(0, rawClassName.length() - 1);
        }
        ignore = (ignore = rawClassName.startsWith("javax.ws.rs.")) || rawClassName.equalsIgnoreCase("void");
        ignore = ignore || ModelConverters.getInstance().isRegisteredAsSkippedClass(rawClassName);
        return ignore;
    }

    private Map<String, Callback> getCallbacks(io.swagger.v3.oas.annotations.callbacks.Callback apiCallback, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, JsonView jsonViewAnnotation) {
        HashMap<String, Callback> callbackMap = new HashMap<String, Callback>();
        if (apiCallback == null) {
            return callbackMap;
        }
        Callback callbackObject = new Callback();
        if (StringUtils.isNotBlank((CharSequence)apiCallback.ref())) {
            callbackObject.set$ref(apiCallback.ref());
            callbackMap.put(apiCallback.name(), callbackObject);
            return callbackMap;
        }
        PathItem pathItemObject = new PathItem();
        for (Operation callbackOperation : apiCallback.operation()) {
            io.swagger.v3.oas.models.Operation callbackNewOperation = new io.swagger.v3.oas.models.Operation();
            this.setOperationObjectFromApiOperationAnnotation(callbackNewOperation, callbackOperation, methodProduces, classProduces, methodConsumes, classConsumes, jsonViewAnnotation);
            this.setPathItemOperation(pathItemObject, callbackOperation.method(), callbackNewOperation);
        }
        callbackObject.addPathItem(apiCallback.callbackUrlExpression(), pathItemObject);
        callbackMap.put(apiCallback.name(), callbackObject);
        return callbackMap;
    }

    private void setPathItemOperation(PathItem pathItemObject, String method, io.swagger.v3.oas.models.Operation operation) {
        switch (method) {
            case "post": {
                pathItemObject.post(operation);
                break;
            }
            case "get": {
                pathItemObject.get(operation);
                break;
            }
            case "delete": {
                pathItemObject.delete(operation);
                break;
            }
            case "put": {
                pathItemObject.put(operation);
                break;
            }
            case "patch": {
                pathItemObject.patch(operation);
                break;
            }
            case "trace": {
                pathItemObject.trace(operation);
                break;
            }
            case "head": {
                pathItemObject.head(operation);
                break;
            }
            case "options": {
                pathItemObject.options(operation);
                break;
            }
        }
    }

    private void setOperationObjectFromApiOperationAnnotation(io.swagger.v3.oas.models.Operation operation, Operation apiOperation, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, JsonView jsonViewAnnotation) {
        Map extensions;
        if (StringUtils.isNotBlank((CharSequence)apiOperation.summary())) {
            operation.setSummary(apiOperation.summary());
        }
        if (StringUtils.isNotBlank((CharSequence)apiOperation.description())) {
            operation.setDescription(apiOperation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)apiOperation.operationId())) {
            operation.setOperationId(this.getOperationId(apiOperation.operationId()));
        }
        if (apiOperation.deprecated()) {
            operation.setDeprecated(Boolean.valueOf(apiOperation.deprecated()));
        }
        boolean openapi31 = Boolean.TRUE.equals(this.config.isOpenAPI31());
        ReaderUtils.getStringListFromStringArray(apiOperation.tags()).ifPresent(tags -> tags.stream().filter(t -> operation.getTags() == null || operation.getTags() != null && !operation.getTags().contains(t)).forEach(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).addTagsItem(arg_0)));
        if (operation.getExternalDocs() == null) {
            AnnotationsUtils.getExternalDocumentation((io.swagger.v3.oas.annotations.ExternalDocumentation)apiOperation.externalDocs(), (boolean)openapi31).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).setExternalDocs(arg_0));
        }
        OperationParser.getApiResponses(apiOperation.responses(), classProduces, methodProduces, this.components, jsonViewAnnotation, openapi31).ifPresent(responses -> {
            if (operation.getResponses() == null) {
                operation.setResponses(responses);
            } else {
                responses.forEach((arg_0, arg_1) -> ((ApiResponses)operation.getResponses()).addApiResponse(arg_0, arg_1));
            }
        });
        AnnotationsUtils.getServers((io.swagger.v3.oas.annotations.servers.Server[])apiOperation.servers()).ifPresent(servers -> servers.forEach(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).addServersItem(arg_0)));
        this.getParametersListFromAnnotation(apiOperation.parameters(), classConsumes, methodConsumes, operation, jsonViewAnnotation).ifPresent(p -> p.forEach(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).addParametersItem(arg_0)));
        Optional<List<SecurityRequirement>> requirementsObject = SecurityParser.getSecurityRequirements(apiOperation.security());
        if (requirementsObject.isPresent()) {
            requirementsObject.get().stream().filter(r -> operation.getSecurity() == null || !operation.getSecurity().contains(r)).forEach(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).addSecurityItem(arg_0));
        }
        if (apiOperation.requestBody() != null && operation.getRequestBody() == null) {
            OperationParser.getRequestBody(apiOperation.requestBody(), classConsumes, methodConsumes, this.components, jsonViewAnnotation).ifPresent(arg_0 -> ((io.swagger.v3.oas.models.Operation)operation).setRequestBody(arg_0));
        }
        if (apiOperation.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions((boolean)openapi31, (Extension[])apiOperation.extensions())) != null) {
            if (openapi31) {
                extensions.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.Operation)operation).addExtension31(arg_0, arg_1));
            } else {
                extensions.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.Operation)operation).addExtension(arg_0, arg_1));
            }
        }
    }

    protected String getOperationId(String operationId) {
        boolean operationIdUsed = this.existOperationId(operationId);
        String operationIdToFind = null;
        int counter = 0;
        while (operationIdUsed) {
            operationIdToFind = String.format("%s_%d", operationId, ++counter);
            operationIdUsed = this.existOperationId(operationIdToFind);
        }
        if (operationIdToFind != null) {
            operationId = operationIdToFind;
        }
        return operationId;
    }

    private boolean existOperationId(String operationId) {
        if (this.openAPI == null) {
            return false;
        }
        if (this.openAPI.getPaths() == null || this.openAPI.getPaths().isEmpty()) {
            return false;
        }
        for (PathItem path : this.openAPI.getPaths().values()) {
            Set<String> pathOperationIds = this.extractOperationIdFromPathItem(path);
            if (!pathOperationIds.contains(operationId)) continue;
            return true;
        }
        return false;
    }

    protected Optional<List<io.swagger.v3.oas.models.parameters.Parameter>> getParametersListFromAnnotation(Parameter[] parameters, Consumes classConsumes, Consumes methodConsumes, io.swagger.v3.oas.models.Operation operation, JsonView jsonViewAnnotation) {
        if (parameters == null) {
            return Optional.empty();
        }
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> parametersObject = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        for (Parameter parameter : parameters) {
            ResolvedParameter resolvedParameter = this.getParameters(ParameterProcessor.getParameterType((Parameter)parameter), Collections.singletonList(parameter), operation, classConsumes, methodConsumes, jsonViewAnnotation);
            parametersObject.addAll(resolvedParameter.parameters);
        }
        if (parametersObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(parametersObject);
    }

    protected ResolvedParameter getParameters(Type type, List<Annotation> annotations, io.swagger.v3.oas.models.Operation operation, Consumes classConsumes, Consumes methodConsumes, JsonView jsonViewAnnotation) {
        Iterator<OpenAPIExtension> chain = OpenAPIExtensions.chain();
        if (!chain.hasNext()) {
            return new ResolvedParameter();
        }
        LOGGER.debug("getParameters for {}", (Object)type);
        HashSet<Type> typesToSkip = new HashSet<Type>();
        OpenAPIExtension extension = chain.next();
        LOGGER.debug("trying extension {}", (Object)extension);
        extension.setOpenAPI31(Boolean.TRUE.equals(this.config.isOpenAPI31()));
        return extension.extractParameters(annotations, type, typesToSkip, this.components, classConsumes, methodConsumes, true, jsonViewAnnotation, chain);
    }

    private Set<String> extractOperationIdFromPathItem(PathItem path) {
        HashSet<String> ids = new HashSet<String>();
        if (path.getGet() != null && StringUtils.isNotBlank((CharSequence)path.getGet().getOperationId())) {
            ids.add(path.getGet().getOperationId());
        }
        if (path.getPost() != null && StringUtils.isNotBlank((CharSequence)path.getPost().getOperationId())) {
            ids.add(path.getPost().getOperationId());
        }
        if (path.getPut() != null && StringUtils.isNotBlank((CharSequence)path.getPut().getOperationId())) {
            ids.add(path.getPut().getOperationId());
        }
        if (path.getDelete() != null && StringUtils.isNotBlank((CharSequence)path.getDelete().getOperationId())) {
            ids.add(path.getDelete().getOperationId());
        }
        if (path.getOptions() != null && StringUtils.isNotBlank((CharSequence)path.getOptions().getOperationId())) {
            ids.add(path.getOptions().getOperationId());
        }
        if (path.getHead() != null && StringUtils.isNotBlank((CharSequence)path.getHead().getOperationId())) {
            ids.add(path.getHead().getOperationId());
        }
        if (path.getPatch() != null && StringUtils.isNotBlank((CharSequence)path.getPatch().getOperationId())) {
            ids.add(path.getPatch().getOperationId());
        }
        return ids;
    }

    private boolean isEmptyComponents(Components components) {
        if (components == null) {
            return true;
        }
        if (components.getSchemas() != null && components.getSchemas().size() > 0) {
            return false;
        }
        if (components.getSecuritySchemes() != null && components.getSecuritySchemes().size() > 0) {
            return false;
        }
        if (components.getCallbacks() != null && components.getCallbacks().size() > 0) {
            return false;
        }
        if (components.getExamples() != null && components.getExamples().size() > 0) {
            return false;
        }
        if (components.getExtensions() != null && components.getExtensions().size() > 0) {
            return false;
        }
        if (components.getHeaders() != null && components.getHeaders().size() > 0) {
            return false;
        }
        if (components.getLinks() != null && components.getLinks().size() > 0) {
            return false;
        }
        if (components.getParameters() != null && components.getParameters().size() > 0) {
            return false;
        }
        if (components.getRequestBodies() != null && components.getRequestBodies().size() > 0) {
            return false;
        }
        if (components.getResponses() != null && components.getResponses().size() > 0) {
            return false;
        }
        return components.getPathItems() == null || components.getPathItems().size() <= 0;
    }

    protected boolean isOperationHidden(Method method) {
        Operation apiOperation = (Operation)ReflectionUtils.getAnnotation((Method)method, Operation.class);
        if (apiOperation != null && apiOperation.hidden()) {
            return true;
        }
        Hidden hidden = method.getAnnotation(Hidden.class);
        if (hidden != null) {
            return true;
        }
        return this.config != null && !Boolean.TRUE.equals(this.config.isReadAllResources()) && apiOperation == null;
    }

    protected boolean isMethodOverridden(Method method, Class<?> cls) {
        return ReflectionUtils.isOverriddenMethod((Method)method, cls);
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    protected boolean ignoreOperationPath(String path, String parentPath) {
        return false;
    }

    protected boolean ignoreOperationPathStrict(String path, String parentPath) {
        if (StringUtils.isBlank((CharSequence)path) && StringUtils.isBlank((CharSequence)parentPath)) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)path) && StringUtils.isBlank((CharSequence)parentPath)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)path) && StringUtils.isNotBlank((CharSequence)parentPath)) {
            return false;
        }
        if (parentPath != null && !"".equals(parentPath) && !"/".equals(parentPath)) {
            if (!parentPath.startsWith("/")) {
                parentPath = "/" + parentPath;
            }
            if (parentPath.endsWith("/")) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
        }
        if (path != null && !"".equals(path) && !"/".equals(path)) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path.equals(parentPath);
    }

    protected Class<?> getSubResourceWithJaxRsSubresourceLocatorSpecs(Method method) {
        Class<?> type;
        Class<?> rawType = method.getReturnType();
        if (Class.class.equals(rawType)) {
            type = Reader.getClassArgument(method.getGenericReturnType());
            if (type == null) {
                return null;
            }
        } else {
            type = rawType;
        }
        if (method.getAnnotation(Path.class) != null && ReaderUtils.extractOperationMethod(method, null) == null) {
            return type;
        }
        return null;
    }

    private static Class<?> getClassArgument(Type cls) {
        if (cls instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)cls;
            Type[] args = parameterized.getActualTypeArguments();
            if (args.length != 1) {
                LOGGER.error("Unexpected class definition: {}", (Object)cls);
                return null;
            }
            Type first = args[0];
            if (first instanceof Class) {
                return (Class)first;
            }
            return null;
        }
        LOGGER.error("Unknown class definition: {}", (Object)cls);
        return null;
    }

    private static class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method m1, Method m2) {
            int val = m1.getName().compareTo(m2.getName());
            if (val == 0 && (val = m1.getParameterTypes().length - m2.getParameterTypes().length) == 0) {
                Class<?>[] types1 = m1.getParameterTypes();
                Class<?>[] types2 = m2.getParameterTypes();
                for (int i = 0; i < types1.length && (val = types1[i].getName().compareTo(types2[i].getName())) == 0; ++i) {
                }
            }
            return val;
        }
    }
}

