/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.plugin.maven;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.oas.integration.OpenApiConfigurationException;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="resolve", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, configurator="include-project-dependencies")
public class SwaggerMojo
extends AbstractMojo {
    @Parameter(property="resolve.outputFileName", defaultValue="openapi")
    private String outputFileName = "openapi";
    @Parameter(property="resolve.outputPath")
    private String outputPath;
    @Parameter(property="resolve.outputFormat", defaultValue="JSON")
    private Format outputFormat = Format.JSON;
    @Parameter(property="resolve.resourcePackages")
    private Set<String> resourcePackages;
    @Parameter(property="resolve.resourceClasses")
    private Set<String> resourceClasses;
    @Parameter(property="resolve.filterClass")
    private String filterClass;
    @Parameter(property="resolve.readerClass")
    private String readerClass;
    @Parameter(property="resolve.scannerClass")
    private String scannerClass;
    @Parameter(property="resolve.prettyPrint")
    private Boolean prettyPrint = false;
    @Parameter(property="resolve.readAllResources")
    private Boolean readAllResources = Boolean.TRUE;
    @Parameter(property="resolve.ignoredRoutes")
    private Collection<String> ignoredRoutes;
    @Parameter(property="resolve.skip")
    private Boolean skip = Boolean.FALSE;
    @Parameter(property="resolve.openapiFilePath")
    private String openapiFilePath;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="resolve.encoding")
    private String encoding;
    private String projectEncoding = "UTF-8";

    public void execute() throws MojoExecutionException, MojoFailureException {
        OpenAPI openAPIInput;
        block18: {
            String pEnc;
            if (this.skip.booleanValue()) {
                this.getLog().info((CharSequence)"Skipping OpenAPI specification resolution");
                return;
            }
            this.getLog().info((CharSequence)"Resolving OpenAPI specification..");
            if (this.project != null && StringUtils.isNotBlank((String)(pEnc = this.project.getProperties().getProperty("project.build.sourceEncoding")))) {
                this.projectEncoding = pEnc;
            }
            if (StringUtils.isBlank((String)this.encoding)) {
                this.encoding = this.projectEncoding;
            }
            openAPIInput = null;
            try {
                String openapiFileContent;
                Path openapiPath;
                if (!StringUtils.isNotBlank((String)this.openapiFilePath) || !(openapiPath = Paths.get(this.openapiFilePath, new String[0])).toFile().exists() || !openapiPath.toFile().isFile() || !StringUtils.isNotBlank((String)(openapiFileContent = new String(Files.readAllBytes(openapiPath), this.encoding)))) break block18;
                try {
                    openAPIInput = (OpenAPI)Json.mapper().readValue(openapiFileContent, OpenAPI.class);
                }
                catch (Exception e) {
                    try {
                        openAPIInput = (OpenAPI)Yaml.mapper().readValue(openapiFileContent, OpenAPI.class);
                    }
                    catch (Exception e1) {
                        this.getLog().error((CharSequence)"Error reading/deserializing openapi file", (Throwable)e);
                        throw new MojoFailureException(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error reading/deserializing openapi file", (Throwable)e);
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
        }
        SwaggerConfiguration config = new SwaggerConfiguration().filterClass(this.filterClass).ignoredRoutes(this.ignoredRoutes).prettyPrint(this.prettyPrint).readAllResources(this.readAllResources).readerClass(this.readerClass).scannerClass(this.scannerClass).resourceClasses(this.resourceClasses).openAPI(openAPIInput).resourcePackages(this.resourcePackages);
        try {
            Path path;
            File parentFile;
            OpenAPI openAPI = new JaxrsOpenApiContextBuilder().openApiConfiguration((OpenAPIConfiguration)config).buildContext(true).read();
            String openapiJson = null;
            String openapiYaml = null;
            if (Format.JSON.equals((Object)this.outputFormat) || Format.JSONANDYAML.equals((Object)this.outputFormat)) {
                openapiJson = this.prettyPrint != false ? Json.pretty((Object)openAPI) : Json.mapper().writeValueAsString((Object)openAPI);
            }
            if (Format.YAML.equals((Object)this.outputFormat) || Format.JSONANDYAML.equals((Object)this.outputFormat)) {
                openapiYaml = this.prettyPrint != false ? Yaml.pretty((Object)openAPI) : Yaml.mapper().writeValueAsString((Object)openAPI);
            }
            if ((parentFile = (path = Paths.get(this.outputPath, "temp")).toFile().getParentFile()) != null) {
                parentFile.mkdirs();
            }
            if (openapiJson != null) {
                path = Paths.get(this.outputPath, this.outputFileName + ".json");
                Files.write(path, openapiJson.getBytes(Charset.forName(this.encoding)), new OpenOption[0]);
            }
            if (openapiYaml != null) {
                path = Paths.get(this.outputPath, this.outputFileName + ".yaml");
                Files.write(path, openapiYaml.getBytes(Charset.forName(this.encoding)), new OpenOption[0]);
            }
        }
        catch (OpenApiConfigurationException e) {
            this.getLog().error((CharSequence)"Error resolving API specification", (Throwable)e);
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error writing API specification", (Throwable)e);
            throw new MojoExecutionException("Failed to write API definition", (Exception)e);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error resolving API specification", (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public String getOpenapiFilePath() {
        return this.openapiFilePath;
    }

    public static enum Format {
        JSON,
        YAML,
        JSONANDYAML;

    }
}

