/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.controllers;

import io.swagger.oas.inflector.config.FilterFactory;
import io.swagger.oas.inflector.config.OpenAPIProcessor;
import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.core.filter.SpecFilter;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.Inflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIResourceController
implements Inflector<ContainerRequestContext, Response> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIResourceController.class);
    private OpenAPI openAPI;
    private List<OpenAPIProcessor> openAPIProcessors;

    public OpenAPIResourceController(OpenAPI openAPI, List<String> swaggerProcessors) {
        this.openAPI = openAPI;
        this.openAPIProcessors = new ArrayList<OpenAPIProcessor>(swaggerProcessors.size());
        for (String swaggerProcessorClass : swaggerProcessors) {
            try {
                this.openAPIProcessors.add((OpenAPIProcessor)OpenAPIResourceController.class.getClassLoader().loadClass(swaggerProcessorClass).newInstance());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.error("Unable to load class: " + swaggerProcessorClass, (Throwable)e);
            }
        }
    }

    public Response apply(ContainerRequestContext arg0) {
        OpenAPISpecFilter filter = FilterFactory.getFilter();
        if (filter != null) {
            Map cookiesvalue = arg0.getCookies();
            HashMap<String, String> cookies = new HashMap<String, String>();
            if (cookiesvalue != null) {
                for (String key : cookiesvalue.keySet()) {
                    cookies.put(key, ((Cookie)cookiesvalue.get(key)).getValue());
                }
            }
            MultivaluedMap headers = arg0.getHeaders();
            return Response.ok().entity((Object)new SpecFilter().filter(this.getOpenAPI(), filter, null, cookies, (Map)headers)).build();
        }
        return Response.ok().entity((Object)this.getOpenAPI()).build();
    }

    private OpenAPI getOpenAPI() {
        if (!this.openAPIProcessors.isEmpty()) {
            try {
                OpenAPI openAPI = (OpenAPI)Json.mapper().readValue(Json.mapper().writeValueAsString((Object)this.openAPI), OpenAPI.class);
                for (OpenAPIProcessor openAPIProcessor : this.openAPIProcessors) {
                    openAPIProcessor.process(openAPI);
                }
                return openAPI;
            }
            catch (IOException e) {
                LOGGER.error("Unable to serialize/deserialize swagger: " + this.openAPI, (Throwable)e);
            }
        }
        return this.openAPI;
    }
}

