/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.models;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public class ResponseContext {
    private MultivaluedMap<String, String> headers = new MultivaluedHashMap();
    private List<NewCookie> cookies = new ArrayList<NewCookie>();
    private MediaType contentType;
    private int status = Response.Status.OK.getStatusCode();
    private Object entity;

    public ResponseContext header(String key, String value) {
        this.headers.add((Object)key, (Object)value);
        return this;
    }

    public ResponseContext cookie(NewCookie cookie) {
        this.cookies.add(cookie);
        return this;
    }

    public ResponseContext contentType(MediaType contentType) {
        this.contentType = contentType;
        return this;
    }

    public ResponseContext contentType(String contentType) {
        this.contentType = MediaType.valueOf((String)contentType);
        return this;
    }

    public ResponseContext status(Response.Status status) {
        this.status = status.getStatusCode();
        return this;
    }

    public ResponseContext status(int status) {
        this.status = status;
        return this;
    }

    public ResponseContext entity(Object entity) {
        this.entity = entity;
        return this;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public List<NewCookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(List<NewCookie> cookies) {
        this.cookies = cookies;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public void setContentType(MediaType contentType) {
        this.contentType = contentType;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }
}

