/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector.processors;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.swagger.oas.inflector.controllers.OpenAPIOperationController;
import io.swagger.oas.inflector.converters.ConversionException;
import io.swagger.oas.inflector.processors.EntityProcessor;
import io.swagger.oas.inflector.validators.ValidationError;
import io.swagger.oas.inflector.validators.ValidationMessage;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonProcessor
implements EntityProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonProcessor.class);
    public static MediaType APPLICATION_YAML_TYPE = new MediaType("application", "yaml");
    private static XmlMapper XML = new XmlMapper();
    private static List<MediaType> SUPPORTED_TYPES = new ArrayList<MediaType>();

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return new ArrayList<MediaType>(SUPPORTED_TYPES);
    }

    @Override
    public void enableType(MediaType type) {
        if (!SUPPORTED_TYPES.contains(type)) {
            SUPPORTED_TYPES.add(type);
        }
    }

    @Override
    public boolean supports(MediaType mediaType) {
        for (MediaType item : SUPPORTED_TYPES) {
            if (!item.isCompatible(mediaType) || mediaType.isWildcardType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object process(MediaType mediaType, InputStream entityStream, JavaType javaType) {
        try {
            if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
                return Json.mapper().readValue(entityStream, javaType);
            }
            if (MediaType.APPLICATION_XML_TYPE.isCompatible(mediaType)) {
                return XML.readValue(entityStream, javaType);
            }
            if (APPLICATION_YAML_TYPE.isCompatible(mediaType)) {
                return Yaml.mapper().readValue(entityStream, javaType);
            }
        }
        catch (IOException e) {
            LOGGER.error("unable to extract entity from content-type `" + mediaType + "` to " + javaType.toCanonical(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Object process(MediaType mediaType, InputStream entityStream, Class<?> cls, OpenAPIOperationController controller) throws ConversionException {
        return this.process(mediaType, entityStream, cls);
    }

    @Override
    public Object process(MediaType mediaType, InputStream entityStream, Class<?> cls) throws ConversionException {
        try {
            if (String.class.equals(cls)) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)entityStream, (OutputStream)outputStream);
                return ((Object)outputStream).toString();
            }
            if (MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
                return Json.mapper().readValue(entityStream, cls);
            }
            if (MediaType.APPLICATION_XML_TYPE.isCompatible(mediaType)) {
                return XML.readValue(entityStream, cls);
            }
            if (APPLICATION_YAML_TYPE.isCompatible(mediaType)) {
                return Yaml.mapper().readValue(entityStream, cls);
            }
        }
        catch (Exception e) {
            LOGGER.trace("unable to extract entity from content-type `" + mediaType + "` to " + cls.getCanonicalName(), (Throwable)e);
            throw new ConversionException().message(new ValidationMessage().code(ValidationError.UNACCEPTABLE_VALUE).message("unable to convert input to " + cls.getCanonicalName()));
        }
        return null;
    }

    static {
        SUPPORTED_TYPES.add(MediaType.APPLICATION_JSON_TYPE);
    }
}

