/*
 * Decompiled with CFR 0.152.
 */
package io.takari.project.generator;

import io.takari.dot.DotBaseListener;
import io.takari.dot.DotLexer;
import io.takari.dot.DotParser;
import io.takari.graph.dot.BasicNode;
import io.takari.graph.dot.Edge;
import io.takari.graph.dot.Graph;
import io.takari.project.generator.AbstractProjectGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class ProjectGeneratorWithAntlr4
extends AbstractProjectGenerator {
    public ProjectGeneratorWithAntlr4(File dot) {
        super(dot);
    }

    @Override
    public Graph parse(File dot) throws Exception {
        ANTLRInputStream input = new ANTLRInputStream((InputStream)new FileInputStream(dot));
        DotLexer lexer = new DotLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        DotParser parser = new DotParser((TokenStream)tokens);
        DotParser.GraphContext tree = parser.graph();
        ParseTreeWalker walker = new ParseTreeWalker();
        MyListener graphProducer = new MyListener();
        walker.walk((ParseTreeListener)graphProducer, (ParseTree)tree);
        return graphProducer.getGraph();
    }

    static class MyListener
    extends DotBaseListener {
        Graph graph = new Graph();
        String currentVertex;

        public MyListener() throws Exception {
            this.graph.removeNode(this.graph.genericNode);
            this.graph.removeNode(this.graph.genericRecord);
            this.graph.removeEdge(this.graph.genericEdge);
        }

        public Graph getGraph() {
            return this.graph;
        }

        @Override
        public void enterProperty(DotParser.PropertyContext ctx) {
            String key = this.stripQuotes(ctx.getChild(0).getText());
            String value = this.stripQuotes(ctx.getChild(2).getText());
            this.graph.attributes().put(key, value);
        }

        @Override
        public void enterEdge_stmt(DotParser.Edge_stmtContext ctx) {
            this.currentVertex = ctx.getChild(0).getText();
        }

        @Override
        public void enterEdgeRHS(DotParser.EdgeRHSContext ctx) {
            for (int i = 0; i < ctx.getChildCount(); i += 2) {
                String endText = ctx.getChild(i + 1).getText();
                try {
                    String startText = this.currentVertex;
                    BasicNode start = new BasicNode(this.graph, startText);
                    if (endText.startsWith("->")) {
                        endText = endText.substring(2);
                    }
                    BasicNode end = new BasicNode(this.graph, endText);
                    this.graph.addNode(start);
                    this.graph.addNode(end);
                    this.graph.addEdge(new Edge(this.graph, start, end));
                    this.currentVertex = endText;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private String stripQuotes(String s) {
            if (s.startsWith("\"")) {
                s = s.substring(1);
            }
            if (s.endsWith("\"")) {
                s = s.substring(0, s.length() - 1);
            }
            return s;
        }
    }
}

