/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import javax.net.ssl.SSLSession;

public class SslSessionConfig
implements SessionConfig {
    private final SessionConfig fallbackSessionConfig;

    public SslSessionConfig(SessionConfig fallbackSessionConfig) {
        this.fallbackSessionConfig = fallbackSessionConfig;
    }

    public SslSessionConfig() {
        this(null);
    }

    @Override
    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        SSLSession sslSession = exchange.getConnection().getSslSession();
        if (sslSession == null) {
            if (this.fallbackSessionConfig != null) {
                this.fallbackSessionConfig.setSessionId(exchange, sessionId);
            }
        } else {
            sslSession.putValue(SslSessionConfig.class.getName(), sessionId);
        }
    }

    @Override
    public void clearSession(HttpServerExchange exchange, String sessionId) {
        SSLSession sslSession = exchange.getConnection().getSslSession();
        if (sslSession == null) {
            if (this.fallbackSessionConfig != null) {
                this.fallbackSessionConfig.clearSession(exchange, sessionId);
            }
        } else {
            sslSession.putValue(SslSessionConfig.class.getName(), null);
        }
    }

    @Override
    public String findSessionId(HttpServerExchange exchange) {
        SSLSession sslSession = exchange.getConnection().getSslSession();
        if (sslSession == null) {
            if (this.fallbackSessionConfig != null) {
                return this.fallbackSessionConfig.findSessionId(exchange);
            }
        } else {
            return (String)sslSession.getValue(SslSessionConfig.class.getName());
        }
        return null;
    }

    @Override
    public String rewriteUrl(String originalUrl, Session session) {
        return originalUrl;
    }
}

