/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ServiceHelper;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.PromiseInternal;
import io.vertx.core.spi.FutureFactory;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

@VertxGen
public interface Future<T>
extends AsyncResult<T> {
    @GenIgnore
    public static final FutureFactory factory = ServiceHelper.loadFactory(FutureFactory.class);

    public static <T> Future<T> future(Handler<Promise<T>> handler) {
        Promise promise = Promise.promise();
        try {
            handler.handle(promise);
        }
        catch (Throwable e) {
            promise.tryFail(e);
        }
        return promise.future();
    }

    public static <T> Future<T> succeededFuture() {
        return factory.succeededFuture();
    }

    public static <T> Future<T> succeededFuture(T result) {
        if (result == null) {
            return factory.succeededFuture();
        }
        return factory.succeededFuture(result);
    }

    public static <T> Future<T> failedFuture(Throwable t) {
        return factory.failedFuture(t);
    }

    public static <T> Future<T> failedFuture(String failureMessage) {
        return factory.failureFuture(failureMessage);
    }

    public boolean isComplete();

    @Fluent
    public Future<T> onComplete(Handler<AsyncResult<T>> var1);

    @Fluent
    default public Future<T> onSuccess(Handler<T> handler) {
        return this.onComplete(ar -> {
            if (ar.succeeded()) {
                handler.handle(ar.result());
            }
        });
    }

    @Fluent
    default public Future<T> onFailure(Handler<Throwable> handler) {
        return this.onComplete(ar -> {
            if (ar.failed()) {
                handler.handle(ar.cause());
            }
        });
    }

    @Override
    public T result();

    @Override
    public Throwable cause();

    @Override
    public boolean succeeded();

    @Override
    public boolean failed();

    default public <U> Future<U> flatMap(Function<T, Future<U>> mapper) {
        return this.compose(mapper);
    }

    default public <U> Future<U> compose(Function<T, Future<U>> mapper) {
        return this.compose(mapper, Future::failedFuture);
    }

    default public Context context() {
        return null;
    }

    default public <U> Future<U> compose(Function<T, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
        if (successMapper == null) {
            throw new NullPointerException();
        }
        if (failureMapper == null) {
            throw new NullPointerException();
        }
        ContextInternal ctx = (ContextInternal)this.context();
        Promise ret = ctx != null ? ctx.promise() : Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                Future apply;
                try {
                    apply = (Future)successMapper.apply(ar.result());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                apply.onComplete(ret);
            } else {
                Future apply;
                try {
                    apply = (Future)failureMapper.apply(ar.cause());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                apply.onComplete(ret);
            }
        });
        return ret.future();
    }

    @Override
    default public <U> Future<U> map(Function<T, U> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        ContextInternal ctx = (ContextInternal)this.context();
        Promise ret = ctx != null ? ctx.promise() : Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                Object mapped;
                try {
                    mapped = mapper.apply(ar.result());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                ret.complete(mapped);
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret.future();
    }

    @Override
    default public <V> Future<V> map(V value) {
        ContextInternal ctx = (ContextInternal)this.context();
        Promise ret = ctx != null ? ctx.promise() : Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(value);
            } else {
                ret.fail(ar.cause());
            }
        });
        return ret.future();
    }

    @Override
    default public <V> Future<V> mapEmpty() {
        return (Future)AsyncResult.super.mapEmpty();
    }

    default public Future<T> recover(Function<Throwable, Future<T>> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        ContextInternal ctx = (ContextInternal)this.context();
        Promise ret = ctx != null ? ctx.promise() : Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                Future mapped;
                try {
                    mapped = (Future)mapper.apply(ar.cause());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                mapped.onComplete(ret);
            }
        });
        return ret.future();
    }

    @Override
    default public Future<T> otherwise(Function<Throwable, T> mapper) {
        if (mapper == null) {
            throw new NullPointerException();
        }
        ContextInternal ctx = (ContextInternal)this.context();
        Promise ret = ctx != null ? ctx.promise() : Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                Object value;
                try {
                    value = mapper.apply(ar.cause());
                }
                catch (Throwable e) {
                    ret.fail(e);
                    return;
                }
                ret.complete(value);
            }
        });
        return ret.future();
    }

    @Override
    default public Future<T> otherwise(T value) {
        ContextInternal ctx = (ContextInternal)this.context();
        Promise ret = ctx != null ? ctx.promise() : Promise.promise();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                ret.complete(this.result());
            } else {
                ret.complete(value);
            }
        });
        return ret.future();
    }

    @Override
    default public Future<T> otherwiseEmpty() {
        return (Future)AsyncResult.super.otherwiseEmpty();
    }

    @GenIgnore
    default public CompletionStage<T> toCompletionStage() {
        CompletableFuture completableFuture = new CompletableFuture();
        this.onComplete(ar -> {
            if (ar.succeeded()) {
                completableFuture.complete(ar.result());
            } else {
                completableFuture.completeExceptionally(ar.cause());
            }
        });
        return completableFuture;
    }

    @GenIgnore
    public static <T> Future<T> fromCompletionStage(CompletionStage<T> completionStage) {
        Promise promise = Promise.promise();
        completionStage.whenComplete((value, err) -> {
            if (err != null) {
                promise.fail((Throwable)err);
            } else {
                promise.complete(value);
            }
        });
        return promise.future();
    }

    @GenIgnore
    public static <T> Future<T> fromCompletionStage(CompletionStage<T> completionStage, Context context) {
        PromiseInternal promise = ((ContextInternal)context).promise();
        completionStage.whenComplete((value, err) -> {
            if (err != null) {
                promise.fail((Throwable)err);
            } else {
                promise.complete(value);
            }
        });
        return promise.future();
    }
}

