/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseHooks;

public class CloseFuture
implements Future<Void>,
Closeable {
    private final Promise<Void> promise = Promise.promise();
    private Closeable resource;
    private CloseHooks hooks;
    private Closeable hook;
    private boolean closed;

    public CloseFuture() {
    }

    public CloseFuture(Closeable resource) {
        this.resource = resource;
    }

    public synchronized void init(Closeable closeable) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.resource = closeable;
    }

    synchronized Closeable register(CloseHooks hooks) {
        if (this.closed) {
            return null;
        }
        if (this.hooks != null) {
            throw new IllegalStateException();
        }
        this.hooks = hooks;
        this.hook = p -> {
            Closeable resource;
            boolean close;
            CloseFuture closeFuture = this;
            synchronized (closeFuture) {
                close = !this.closed;
                resource = this.resource;
                this.closed = true;
                this.hook = null;
                this.hooks = null;
                this.resource = null;
            }
            if (close) {
                resource.close(p);
                p.future().onComplete(this.promise);
            } else {
                p.complete();
            }
        };
        return this.hook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Promise<Void> promise) {
        Closeable resource;
        Closeable hook;
        CloseHooks hooks;
        boolean close;
        CloseFuture closeFuture = this;
        synchronized (closeFuture) {
            close = !this.closed;
            hooks = this.hooks;
            hook = this.hook;
            resource = this.resource;
            this.closed = true;
            this.hooks = null;
            this.hook = null;
            this.resource = null;
        }
        if (resource == null) {
            promise.fail("Close future not initialized");
        } else if (close) {
            if (hooks != null) {
                hooks.remove(hook);
            }
            resource.close(promise);
            promise.future().onComplete(this.promise);
        } else {
            promise.complete();
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isComplete() {
        return this.promise.future().isComplete();
    }

    @Override
    public Future<Void> onComplete(Handler<AsyncResult<Void>> handler) {
        this.promise.future().onComplete(handler);
        return this;
    }

    @Override
    public Void result() {
        return this.promise.future().result();
    }

    @Override
    public Throwable cause() {
        return this.promise.future().cause();
    }

    @Override
    public boolean succeeded() {
        return this.promise.future().succeeded();
    }

    @Override
    public boolean failed() {
        return this.promise.future().failed();
    }
}

