/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import io.netty.util.concurrent.FutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.http.impl.AssembledFullHttpRequest;
import io.vertx.core.http.impl.AssembledHttpRequest;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientPush;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpRequestHead;
import io.vertx.core.http.impl.HttpResponseHead;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.WebSocketHandshakeInboundHandler;
import io.vertx.core.http.impl.WebSocketImpl;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.net.impl.clientconnection.ConnectionListener;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.tracing.TagExtractor;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.streams.impl.InboundBuffer;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class Http1xClientConnection
extends Http1xConnectionBase<WebSocketImpl>
implements HttpClientConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xClientConnection.class);
    private static final Handler<Object> INVALID_MSG_HANDLER = msg -> {
        throw new IllegalStateException("Invalid object " + msg);
    };
    private final ConnectionListener<HttpClientConnection> listener;
    private final HttpClientImpl client;
    private final HttpClientOptions options;
    private final boolean ssl;
    private final SocketAddress server;
    public final ClientMetrics metrics;
    private final HttpVersion version;
    private Deque<Stream> requests = new ArrayDeque<Stream>();
    private Deque<Stream> responses = new ArrayDeque<Stream>();
    private boolean closed;
    private boolean shutdown;
    private long shutdownTimerID = -1L;
    private Handler<Object> invalidMessageHandler = INVALID_MSG_HANDLER;
    private boolean close;
    private boolean isConnect;
    private int keepAliveTimeout;
    private long expirationTimestamp;
    private int seq = 1;
    private long bytesRead;

    Http1xClientConnection(ConnectionListener<HttpClientConnection> listener, HttpVersion version, HttpClientImpl client, ChannelHandlerContext channel, boolean ssl, SocketAddress server, ContextInternal context, ClientMetrics metrics) {
        super(context, channel);
        this.listener = listener;
        this.client = client;
        this.options = client.getOptions();
        this.ssl = ssl;
        this.server = server;
        this.metrics = metrics;
        this.version = version;
        this.keepAliveTimeout = this.options.getKeepAliveTimeout();
    }

    ConnectionListener<HttpClientConnection> listener() {
        return this.listener;
    }

    public NetSocketInternal toNetSocket() {
        this.removeChannelHandlers();
        NetSocketImpl socket = new NetSocketImpl(this.context, this.chctx, this.client.getSslHelper(), this.metrics());
        socket.metric(this.metric());
        this.listener.onEvict();
        this.chctx.pipeline().replace("handler", "handler", VertxHandler.create(ctx -> socket));
        return socket;
    }

    private HttpRequest createRequest(HttpMethod method, String uri, MultiMap headerMap, String authority, boolean chunked, ByteBuf buf, boolean end) {
        Object request = new DefaultHttpRequest(HttpUtils.toNettyHttpVersion(this.version), method.toNetty(), uri, false);
        io.netty.handler.codec.http.HttpHeaders headers = request.headers();
        if (headerMap != null) {
            for (Map.Entry header : headerMap) {
                headers.add((String)header.getKey(), header.getValue());
            }
        }
        if (!headers.contains(HttpHeaders.HOST)) {
            request.headers().set(HttpHeaders.HOST, (Object)authority);
        } else {
            headers.remove(HttpHeaders.TRANSFER_ENCODING);
        }
        if (chunked) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)request, (boolean)true);
        }
        if (this.options.isTryUseCompression() && request.headers().get(HttpHeaders.ACCEPT_ENCODING) == null) {
            request.headers().set(HttpHeaders.ACCEPT_ENCODING, (Object)HttpHeaders.DEFLATE_GZIP);
        }
        if (!this.options.isKeepAlive() && this.options.getProtocolVersion() == HttpVersion.HTTP_1_1) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.CLOSE);
        } else if (this.options.isKeepAlive() && this.options.getProtocolVersion() == HttpVersion.HTTP_1_0) {
            request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
        }
        if (end) {
            request = buf != null ? new AssembledFullHttpRequest((HttpRequest)request, buf) : new AssembledFullHttpRequest((HttpRequest)request);
        } else if (buf != null) {
            request = new AssembledHttpRequest((HttpRequest)request, buf);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginRequest(Stream stream, HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, boolean connect, Handler<AsyncResult<Void>> handler) {
        request.id = stream.id;
        request.remoteAddress = this.remoteAddress();
        HttpRequest nettyRequest = this.createRequest(request.method, request.uri, request.headers, request.authority, chunked, buf, end);
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            VertxTracer tracer;
            this.responses.add(stream);
            this.isConnect = connect;
            if (this.metrics != null) {
                stream.metric = this.metrics.requestBegin(request.uri, request);
            }
            if ((tracer = this.context.tracer()) != null) {
                ArrayList<AbstractMap.SimpleEntry<String, String>> tags = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                tags.add(new AbstractMap.SimpleEntry<String, String>("http.url", "todo"));
                tags.add(new AbstractMap.SimpleEntry<String, String>("http.method", request.method.name()));
                BiConsumer<String, String> headers = (key, val) -> nettyRequest.headers().add(key, val);
                stream.trace = tracer.sendRequest(stream.context, request, request.method.name(), headers, HttpUtils.CLIENT_HTTP_REQUEST_TAG_EXTRACTOR);
            }
        }
        this.writeToChannel((Object)nettyRequest, handler == null ? null : this.context.promise(handler));
        if (end) {
            this.endRequest(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRequest(Stream s) {
        boolean recycle;
        Stream next;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            this.requests.pop();
            next = this.requests.peek();
            recycle = s.responseEnded;
            if (this.metrics != null) {
                this.metrics.requestEnd(s.metric);
            }
        }
        this.reportBytesWritten(this.bytesWritten);
        this.bytesWritten = 0L;
        if (next != null) {
            next.promise.complete((HttpClientStream)((Object)next));
        }
        if (recycle) {
            this.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRequest(Stream stream) {
        boolean close;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.responses.remove(stream)) {
                close = true;
            } else if (this.requests.remove(stream)) {
                close = false;
            } else {
                return;
            }
        }
        if (close) {
            this.close();
        } else {
            this.recycle();
        }
    }

    private void drainResponse(Stream n) {
        if (!n.responseEnded) {
            this.doResume();
        }
    }

    private void checkLifecycle() {
        if (this.close) {
            this.close();
        } else {
            this.recycle();
        }
    }

    private Throwable validateMessage(Object msg) {
        if (msg instanceof HttpObject) {
            io.netty.handler.codec.http.HttpVersion version;
            HttpObject obj = (HttpObject)msg;
            DecoderResult result = obj.decoderResult();
            if (result.isFailure()) {
                return result.cause();
            }
            if (obj instanceof HttpResponse && (version = ((HttpResponse)obj).protocolVersion()) != io.netty.handler.codec.http.HttpVersion.HTTP_1_0 && version != io.netty.handler.codec.http.HttpVersion.HTTP_1_1) {
                return new IllegalStateException("Unsupported HTTP version: " + version);
            }
        }
        return null;
    }

    @Override
    public void handleMessage(Object msg) {
        Throwable error = this.validateMessage(msg);
        if (error != null) {
            this.fail(error);
        } else if (msg instanceof HttpObject) {
            this.handleHttpMessage((HttpObject)msg);
        } else if (msg instanceof ByteBuf && this.isConnect) {
            this.handleChunk((ByteBuf)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWsFrame((WebSocketFrame)msg);
        } else {
            this.invalidMessageHandler.handle(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttpMessage(HttpObject obj) {
        Stream stream;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            stream = this.responses.peekFirst();
            if (stream == null) {
                return;
            }
        }
        if (obj instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)obj;
            HttpVersion version = response.protocolVersion() == io.netty.handler.codec.http.HttpVersion.HTTP_1_0 ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
            this.handleResponseBegin(stream, new HttpResponseHead(version, response.status().code(), response.status().reasonPhrase(), new HeadersAdaptor(response.headers())));
        } else if (obj instanceof HttpContent) {
            HttpContent chunk = (HttpContent)obj;
            if (chunk.content().isReadable()) {
                Buffer buff = Buffer.buffer(VertxHandler.safeBuffer(chunk.content(), this.chctx.alloc()));
                this.handleResponseChunk(stream, buff);
            }
            if (!this.isConnect && chunk instanceof LastHttpContent) {
                this.handleResponseEnd(stream, (LastHttpContent)chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChunk(ByteBuf chunk) {
        Stream stream;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            stream = this.responses.peekFirst();
            if (stream == null) {
                return;
            }
        }
        if (chunk.isReadable()) {
            Buffer buff = Buffer.buffer(VertxHandler.safeBuffer(chunk, this.chctx.alloc()));
            this.handleResponseChunk(stream, buff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseBegin(Stream stream, HttpResponseHead response) {
        if (response.statusCode == 100) {
            stream.context.execute(null, v -> stream.handleContinue());
        } else {
            HttpRequestHead request;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                request = ((StreamImpl)stream).request;
                stream.response = response;
                if (this.metrics != null) {
                    this.metrics.responseBegin(stream.metric, response);
                }
                if (response.statusCode != 100 && request.method != HttpMethod.CONNECT) {
                    int timeout;
                    String requestConnectionHeader;
                    String responseConnectionHeader = response.headers.get((CharSequence)HttpHeaderNames.CONNECTION);
                    String string = requestConnectionHeader = request.headers != null ? request.headers.get((CharSequence)HttpHeaderNames.CONNECTION) : null;
                    if (HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)responseConnectionHeader) || HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)requestConnectionHeader)) {
                        this.close = true;
                    } else if (response.version == HttpVersion.HTTP_1_0 && !HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase((CharSequence)responseConnectionHeader)) {
                        this.close = true;
                    }
                    String keepAliveHeader = response.headers.get((CharSequence)HttpHeaderNames.KEEP_ALIVE);
                    if (keepAliveHeader != null && (timeout = HttpUtils.parseKeepAliveHeaderTimeout(keepAliveHeader)) != -1) {
                        this.keepAliveTimeout = timeout;
                    }
                }
            }
            stream.handleHead(response);
            if (this.isConnect && (request.method == HttpMethod.CONNECT && response.statusCode == 200 || request.method == HttpMethod.GET && request.headers.contains("connection", "Upgrade", false) && response.statusCode == 101)) {
                this.removeChannelHandlers();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> removeChannelHandlers() {
        ChannelPipeline pipeline = this.chctx.pipeline();
        ChannelHandler inflater = pipeline.get(HttpContentDecompressor.class);
        if (inflater != null) {
            pipeline.remove(inflater);
        }
        ArrayList<Object> pending = new ArrayList<Object>();
        Handler<Object> prev = this.invalidMessageHandler;
        this.invalidMessageHandler = pending::add;
        try {
            pipeline.remove("codec");
        }
        finally {
            this.invalidMessageHandler = prev;
        }
        return pending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseChunk(Stream stream, Buffer buff) {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            this.bytesRead += (long)buff.length();
        }
        stream.context.execute(buff, stream::handleChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResponseEnd(Stream stream, LastHttpContent trailer) {
        boolean check;
        long bytesRead;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (stream.response == null) {
                return;
            }
            this.responses.pop();
            bytesRead = this.bytesRead;
            this.bytesRead = 0L;
            this.close |= !this.options.isKeepAlive();
            stream.responseEnded = true;
            check = this.requests.peek() != stream;
        }
        VertxTracer tracer = this.context.tracer();
        if (tracer != null) {
            tracer.receiveResponse(stream.context, stream.response, stream.trace, null, HttpUtils.CLIENT_RESPONSE_TAG_EXTRACTOR);
        }
        if (this.metrics != null) {
            this.metrics.responseEnd(stream.metric);
        }
        stream.context.execute(trailer, stream::handleEnd);
        this.doResume();
        this.reportBytesRead(bytesRead);
        if (check) {
            this.checkLifecycle();
        }
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.client.metrics();
    }

    synchronized void toWebSocket(String requestURI, MultiMap headers, WebsocketVersion vers, List<String> subProtocols, int maxWebSocketFrameSize, Promise<WebSocket> promise) {
        try {
            DefaultHttpHeaders nettyHeaders;
            URI wsuri = new URI(requestURI);
            if (!wsuri.isAbsolute()) {
                wsuri = new URI((this.ssl ? "https:" : "http:") + "//" + this.server.host() + ":" + this.server.port() + requestURI);
            }
            WebSocketVersion version = WebSocketVersion.valueOf((String)((Enum)(vers == null ? WebSocketVersion.V13 : vers)).toString());
            if (headers != null) {
                nettyHeaders = new DefaultHttpHeaders();
                for (Map.Entry entry : headers) {
                    nettyHeaders.add((String)entry.getKey(), entry.getValue());
                }
            } else {
                nettyHeaders = null;
            }
            ChannelPipeline p = this.chctx.channel().pipeline();
            ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = this.initializeWebSocketExtensionHandshakers(this.client.getOptions());
            if (!extensionHandshakers.isEmpty()) {
                p.addBefore("handler", "webSocketsExtensionsHandler", (ChannelHandler)new WebSocketClientExtensionHandler(extensionHandshakers.toArray(new WebSocketClientExtensionHandshaker[extensionHandshakers.size()])));
            }
            String subp = null;
            if (subProtocols != null) {
                subp = String.join((CharSequence)",", subProtocols);
            }
            WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)wsuri, (WebSocketVersion)version, (String)subp, (!extensionHandshakers.isEmpty() ? 1 : 0) != 0, (io.netty.handler.codec.http.HttpHeaders)nettyHeaders, (int)maxWebSocketFrameSize, (!this.options.isSendUnmaskedFrames() ? 1 : 0) != 0, (boolean)false, (long)-1L);
            WebSocketHandshakeInboundHandler handshakeInboundHandler = new WebSocketHandshakeInboundHandler(handshaker, ar -> {
                AsyncResult<Function<HeadersAdaptor, WebSocket>> wsRes = ar.map(v -> {
                    WebSocketImpl w = new WebSocketImpl(this.getContext(), this, version != WebSocketVersion.V00, this.options.getWebSocketClosingTimeout(), this.options.getMaxWebSocketFrameSize(), this.options.getMaxWebSocketMessageSize());
                    w.subProtocol(handshaker.actualSubprotocol());
                    return w;
                });
                if (ar.failed()) {
                    this.close();
                } else {
                    this.webSocket = (WebSocketImpl)((Object)wsRes.result());
                    ((WebSocketImpl)this.webSocket).registerHandler(this.vertx.eventBus());
                }
                log.debug("WebSocket handshake complete");
                HttpClientMetrics metrics = this.client.metrics();
                if (metrics != null) {
                    ((WebSocketImpl)this.webSocket).setMetric(metrics.connected((WebSocket)((Object)this.webSocket)));
                }
                this.getContext().emit(wsRes, res -> {
                    if (res.succeeded()) {
                        ((WebSocketImpl)this.webSocket).headers((MultiMap)ar.result());
                    }
                    promise.handle((AsyncResult<WebSocket>)res);
                    if (res.succeeded()) {
                        ((WebSocketImpl)this.webSocket).headers(null);
                    }
                });
            });
            p.addBefore("handler", "handshakeCompleter", (ChannelHandler)handshakeInboundHandler);
            handshaker.handshake(this.chctx.channel());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    ArrayList<WebSocketClientExtensionHandshaker> initializeWebSocketExtensionHandshakers(HttpClientOptions options) {
        ArrayList<WebSocketClientExtensionHandshaker> extensionHandshakers = new ArrayList<WebSocketClientExtensionHandshaker>();
        if (options.getTryWebSocketDeflateFrameCompression()) {
            extensionHandshakers.add((WebSocketClientExtensionHandshaker)new DeflateFrameClientExtensionHandshaker(options.getWebSocketCompressionLevel(), false));
        }
        if (options.getTryUsePerMessageWebSocketCompression()) {
            extensionHandshakers.add((WebSocketClientExtensionHandshaker)new PerMessageDeflateClientExtensionHandshaker(options.getWebSocketCompressionLevel(), ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, options.getWebSocketCompressionAllowClientNoContext(), options.getWebSocketCompressionRequestServerNoContext()));
        }
        return extensionHandshakers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInterestedOpsChanged() {
        Handler<Boolean> handler;
        ContextInternal context;
        boolean writable = !this.isNotWritable();
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            Stream current = this.requests.peek();
            if (current != null) {
                context = current.context;
                handler = current::handleWritabilityChanged;
            } else if (this.webSocket != null) {
                context = ((WebSocketImpl)this.webSocket).context;
                handler = ((WebSocketImpl)this.webSocket)::handleWritabilityChanged;
            } else {
                return;
            }
        }
        context.execute(writable, handler);
    }

    private Iterable<Stream> pendingStreams() {
        LinkedHashSet<Stream> list = new LinkedHashSet<Stream>();
        list.addAll(this.requests);
        list.addAll(this.responses);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        Iterable<Stream> streams;
        WebSocketImpl ws;
        super.handleClosed();
        long timerID = this.shutdownTimerID;
        if (timerID != -1L) {
            this.shutdownTimerID = -1L;
            this.vertx.cancelTimer(timerID);
        }
        this.closed = true;
        if (this.metrics != null) {
            HttpClientMetrics met = this.client.metrics();
            met.endpointDisconnected(this.metrics);
        }
        VertxTracer tracer = this.context.tracer();
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            ws = (WebSocketImpl)this.webSocket;
            streams = this.pendingStreams();
        }
        if (ws != null) {
            ws.handleClosed();
        }
        for (Stream stream : streams) {
            if (this.metrics != null) {
                this.metrics.requestReset(stream.metric);
            }
            if (tracer != null) {
                tracer.receiveResponse(stream.context, null, stream.trace, ConnectionBase.CLOSED_EXCEPTION, TagExtractor.empty());
            }
            stream.context.execute(null, v -> stream.handleClosed());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleIdle() {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.webSocket == null && this.responses.isEmpty() && this.requests.isEmpty()) {
                return;
            }
        }
        super.handleIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleException(Throwable e) {
        Iterable<Stream> streams;
        WebSocketImpl ws;
        super.handleException(e);
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            ws = (WebSocketImpl)this.webSocket;
            streams = this.pendingStreams();
        }
        if (ws != null) {
            ws.handleException(e);
        }
        for (Stream stream : streams) {
            stream.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStream(ContextInternal context, Handler<AsyncResult<HttpClientStream>> handler) {
        EventLoop eventLoop = context.nettyEventLoop();
        if (eventLoop.inEventLoop()) {
            StreamImpl stream;
            Http1xClientConnection http1xClientConnection = this;
            synchronized (http1xClientConnection) {
                if (this.closed) {
                    stream = null;
                } else {
                    stream = new StreamImpl(context, this, this.seq++);
                    this.requests.add(stream);
                    if (this.requests.size() == 1) {
                        stream.promise.complete(stream);
                    }
                }
            }
            if (stream != null) {
                stream.promise.future().onComplete(handler);
            } else {
                handler.handle(Future.failedFuture(CLOSED_EXCEPTION));
            }
        } else {
            eventLoop.execute(() -> this.createStream(context, handler));
        }
    }

    @Override
    public boolean isValid() {
        return this.expirationTimestamp == 0L || System.currentTimeMillis() <= this.expirationTimestamp;
    }

    private void recycle() {
        if (this.shutdown) {
            if (this.requests.isEmpty() && this.responses.isEmpty()) {
                this.close();
            }
        } else if (!this.isConnect) {
            this.expirationTimestamp = this.keepAliveTimeout == 0 ? 0L : System.currentTimeMillis() + (long)(this.keepAliveTimeout * 1000);
            this.listener.onRecycle();
        }
    }

    @Override
    public void shutdown(long timeout, Handler<AsyncResult<Void>> handler) {
        this.shutdown(timeout, this.vertx.promise(handler));
    }

    @Override
    public Future<Void> shutdown(long timeoutMs) {
        PromiseInternal<Void> promise = this.vertx.promise();
        this.shutdown(timeoutMs, promise);
        return promise.future();
    }

    private synchronized void shutdownNow() {
        this.shutdownTimerID = -1L;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(long timeoutMs, PromiseInternal<Void> promise) {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.shutdown) {
                promise.fail("Already shutdown");
                return;
            }
            this.shutdown = true;
            this.closeFuture().onComplete(promise);
        }
        this.listener.onEvict();
        http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (!this.closed) {
                if (timeoutMs > 0L) {
                    this.shutdownTimerID = this.context.setTimer(timeoutMs, id -> this.shutdownNow());
                } else {
                    this.close = true;
                }
            }
        }
        this.checkLifecycle();
    }

    private static class StreamImpl
    extends Stream
    implements HttpClientStream {
        private final Http1xClientConnection conn;
        private final InboundBuffer<Object> queue;
        private boolean reset;
        private boolean writable;
        private HttpRequestHead request;
        private Handler<HttpResponseHead> headHandler;
        private Handler<Buffer> chunkHandler;
        private Handler<MultiMap> endHandler;
        private Handler<Void> drainHandler;
        private Handler<Void> continueHandler;
        private Handler<Throwable> exceptionHandler;

        StreamImpl(ContextInternal context, Http1xClientConnection conn, int id) {
            super(context, id);
            this.writable = !conn.isNotWritable();
            this.conn = conn;
            this.queue = new InboundBuffer(context, 5L).drainHandler(v -> {
                EventLoop eventLoop = conn.context.nettyEventLoop();
                if (eventLoop.inEventLoop()) {
                    this.drained();
                } else {
                    eventLoop.execute(this::drained);
                }
            }).handler(item -> {
                if (item instanceof MultiMap) {
                    Handler<MultiMap> handler = this.endHandler;
                    if (handler != null) {
                        handler.handle((MultiMap)item);
                    }
                } else {
                    Handler<Buffer> handler = this.chunkHandler;
                    if (handler != null) {
                        handler.handle((Buffer)item);
                    }
                }
            }).exceptionHandler(context::reportException);
        }

        private void drained() {
            this.conn.drainResponse(this);
        }

        @Override
        public void continueHandler(Handler<Void> handler) {
            this.continueHandler = handler;
        }

        @Override
        public void drainHandler(Handler<Void> handler) {
            this.drainHandler = handler;
        }

        @Override
        public void exceptionHandler(Handler<Throwable> handler) {
            this.exceptionHandler = handler;
        }

        @Override
        public void headHandler(Handler<HttpResponseHead> handler) {
            this.headHandler = handler;
        }

        @Override
        public void priorityHandler(Handler<StreamPriority> handler) {
        }

        @Override
        public void pushHandler(Handler<HttpClientPush> handler) {
        }

        @Override
        public void unknownFrameHandler(Handler<HttpFrame> handler) {
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public Object metric() {
            return super.metric();
        }

        @Override
        public HttpVersion version() {
            return this.conn.version;
        }

        @Override
        public HttpClientConnection connection() {
            return this.conn;
        }

        @Override
        public ContextInternal getContext() {
            return this.context;
        }

        @Override
        public void writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, StreamPriority priority, boolean connect, Handler<AsyncResult<Void>> handler) {
            this.writeHead(request, chunked, buf, end, connect, handler == null ? null : this.context.promise(handler));
        }

        private void writeHead(HttpRequestHead request, boolean chunked, ByteBuf buf, boolean end, boolean connect, Handler<AsyncResult<Void>> handler) {
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            if (eventLoop.inEventLoop()) {
                this.request = request;
                this.conn.beginRequest(this, request, chunked, buf, end, connect, handler);
            } else {
                eventLoop.execute(() -> this.writeHead(request, chunked, buf, end, connect, handler));
            }
        }

        @Override
        public void writeBuffer(ByteBuf buff, boolean end, Handler<AsyncResult<Void>> handler) {
            if (buff != null || end) {
                PromiseInternal<Void> listener = handler == null ? null : this.context.promise(handler);
                this.writeBuffer(buff, end, (FutureListener<Void>)listener);
            }
        }

        private void writeBuffer(ByteBuf buff, boolean end, FutureListener<Void> listener) {
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            if (eventLoop.inEventLoop()) {
                if (this.conn.isConnect) {
                    ByteBuf msg;
                    ByteBuf byteBuf = msg = buff != null ? buff : Unpooled.EMPTY_BUFFER;
                    if (end) {
                        this.conn.writeToChannel((Object)msg, this.conn.channelFuture().addListener(listener).addListener(v -> this.conn.close()));
                    } else {
                        this.conn.writeToChannel(msg);
                    }
                } else {
                    Object msg = end ? (buff != null && buff.isReadable() ? new DefaultLastHttpContent(buff, false) : LastHttpContent.EMPTY_LAST_CONTENT) : new DefaultHttpContent(buff);
                    this.conn.writeToChannel(msg, listener);
                    if (end) {
                        this.conn.endRequest(this);
                    }
                }
            } else {
                eventLoop.execute(() -> this.writeBuffer(buff, end, listener));
            }
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            throw new IllegalStateException("Cannot write an HTTP/2 frame over an HTTP/1.x connection");
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
            this.conn.doSetWriteQueueMaxSize(size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isNotWritable() {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                return !this.writable;
            }
        }

        @Override
        public void doPause() {
            this.queue.pause();
        }

        @Override
        public void doFetch(long amount) {
            this.queue.fetch(amount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset(Throwable cause) {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.reset) {
                    return;
                }
                this.reset = true;
            }
            this.handleException(cause);
            EventLoop eventLoop = this.conn.context.nettyEventLoop();
            if (eventLoop.inEventLoop()) {
                this.reset();
            } else {
                eventLoop.execute(this::reset);
            }
        }

        private void reset() {
            this.conn.resetRequest(this);
        }

        @Override
        public StreamPriority priority() {
            return null;
        }

        @Override
        public void updatePriority(StreamPriority streamPriority) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleWritabilityChanged(boolean writable) {
            Handler<Void> handler;
            boolean drain;
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                drain = !this.writable && writable;
                this.writable = writable;
                handler = this.drainHandler;
            }
            if (drain && handler != null) {
                handler.handle(null);
            }
        }

        @Override
        void handleContinue() {
            if (this.continueHandler != null) {
                this.continueHandler.handle(null);
            }
        }

        @Override
        void handleHead(HttpResponseHead response) {
            Handler<HttpResponseHead> handler = this.headHandler;
            if (handler != null) {
                this.context.emit(response, handler);
            }
        }

        @Override
        public void chunkHandler(Handler<Buffer> handler) {
            this.chunkHandler = handler;
        }

        @Override
        public void endHandler(Handler<MultiMap> handler) {
            this.endHandler = handler;
        }

        @Override
        void handleChunk(Buffer buff) {
            if (!this.queue.write(buff)) {
                this.conn.doPause();
            }
        }

        @Override
        void handleEnd(LastHttpContent trailer) {
            this.queue.write((Object)new HeadersAdaptor(trailer.trailingHeaders()));
        }

        @Override
        void handleException(Throwable cause) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(cause);
            }
        }

        @Override
        void handleClosed() {
            this.handleException(ConnectionBase.CLOSED_EXCEPTION);
        }
    }

    private static abstract class Stream {
        protected final Promise<HttpClientStream> promise;
        protected final ContextInternal context;
        protected final int id;
        private Object trace;
        private Object metric;
        private HttpResponseHead response;
        private boolean responseEnded;

        Stream(ContextInternal context, int id) {
            this.context = context;
            this.id = id;
            this.promise = context.promise();
        }

        Object metric() {
            return this.metric;
        }

        abstract void handleContinue();

        abstract void handleHead(HttpResponseHead var1);

        abstract void handleChunk(Buffer var1);

        abstract void handleEnd(LastHttpContent var1);

        abstract void handleWritabilityChanged(boolean var1);

        abstract void handleException(Throwable var1);

        abstract void handleClosed();
    }
}

