/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.cluster.impl.selector;

import io.vertx.core.Promise;
import io.vertx.core.eventbus.Message;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.RegistrationInfo;
import io.vertx.core.spi.cluster.impl.selector.NullRoundRobinSelector;
import io.vertx.core.spi.cluster.impl.selector.RoundRobinSelector;
import io.vertx.core.spi.cluster.impl.selector.SelectorEntry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class Selectors {
    private final ConcurrentMap<String, SelectorEntry> map = new ConcurrentHashMap<String, SelectorEntry>(0);
    private final ClusterManager clusterManager;

    public Selectors(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public <T> void withSelector(Message<?> message, Promise<T> promise, BiConsumer<Promise<T>, RoundRobinSelector> task) {
        String address = message.address();
        SelectorEntry entry = this.map.compute(address, (addr, curr) -> curr == null ? new SelectorEntry() : (curr.isNotReady() ? curr.increment() : curr));
        if (entry.isNotReady()) {
            if (entry.shouldInitialize()) {
                this.initialize(address);
            }
            entry.selectorPromise.future().onComplete(ar -> {
                if (ar.succeeded()) {
                    task.accept((Promise)promise, (RoundRobinSelector)ar.result());
                } else {
                    promise.fail(ar.cause());
                }
            });
        } else {
            task.accept(promise, entry.selector);
        }
    }

    private void initialize(String address) {
        Promise<List<RegistrationInfo>> getPromise = Promise.promise();
        this.clusterManager.getRegistrations(address, getPromise);
        getPromise.future().onComplete(ar -> {
            if (ar.succeeded()) {
                this.dataReceived(address, (List)ar.result());
            } else {
                SelectorEntry entry = (SelectorEntry)this.map.remove(address);
                if (entry != null && entry.isNotReady()) {
                    entry.selectorPromise.fail(ar.cause());
                }
            }
        });
    }

    public void dataReceived(String address, List<RegistrationInfo> registrations) {
        SelectorEntry previous;
        List<String> accessible = this.computeAccessible(registrations);
        while ((previous = (SelectorEntry)this.map.get(address)) != null) {
            SelectorEntry next = previous.data(accessible);
            if (next == null) {
                if (!this.map.remove(address, previous)) continue;
                if (!previous.isNotReady()) break;
                previous.selectorPromise.complete(NullRoundRobinSelector.INSTANCE);
                break;
            }
            if (!this.map.replace(address, previous, next)) continue;
            if (!previous.isNotReady()) break;
            previous.selectorPromise.complete(next.selector);
            break;
        }
    }

    private List<String> computeAccessible(List<RegistrationInfo> registrations) {
        if (registrations == null || registrations.isEmpty()) {
            return Collections.emptyList();
        }
        return registrations.stream().filter(this::isAccessible).map(RegistrationInfo::nodeId).collect(Collectors.toList());
    }

    private boolean isAccessible(RegistrationInfo registrationInfo) {
        return !registrationInfo.localOnly() || this.clusterManager.getNodeId().equals(registrationInfo.nodeId());
    }

    public void dataLost() {
        for (String address : this.map.keySet()) {
            SelectorEntry entry = (SelectorEntry)this.map.remove(address);
            if (!entry.isNotReady()) continue;
            entry.selectorPromise.complete(NullRoundRobinSelector.INSTANCE);
        }
    }
}

