/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.ComposeTransformation;
import io.vertx.core.impl.future.FutureInternal;
import io.vertx.core.impl.future.Listener;
import io.vertx.core.impl.future.MapTransformation;
import io.vertx.core.impl.future.MapValueTransformation;
import io.vertx.core.impl.future.OtherwiseTransformation;
import io.vertx.core.impl.future.OtherwiseValueTransformation;
import java.util.Objects;
import java.util.function.Function;

abstract class FutureBase<T>
implements FutureInternal<T> {
    protected final ContextInternal context;

    FutureBase() {
        this(null);
    }

    FutureBase(ContextInternal context) {
        this.context = context;
    }

    @Override
    public final ContextInternal context() {
        return this.context;
    }

    protected final void emitSuccess(T value, Listener<T> listener) {
        if (this.context != null && !this.context.isRunningOnContext()) {
            this.context.execute(() -> {
                ContextInternal prev = this.context.beginDispatch();
                try {
                    listener.onSuccess(value);
                }
                catch (Throwable t) {
                    this.context.reportException(t);
                }
                finally {
                    this.context.endDispatch(prev);
                }
            });
        } else {
            listener.onSuccess(value);
        }
    }

    protected final void emitFailure(Throwable cause, Listener<T> listener) {
        if (this.context != null && !this.context.isRunningOnContext()) {
            this.context.execute(() -> {
                ContextInternal prev = this.context.beginDispatch();
                try {
                    listener.onFailure(cause);
                }
                catch (Throwable t) {
                    this.context.reportException(t);
                }
                finally {
                    this.context.endDispatch(prev);
                }
            });
        } else {
            listener.onFailure(cause);
        }
    }

    protected final <U> void emit(U value, Handler<U> handler) {
        if (this.context != null && !this.context.isRunningOnContext()) {
            this.context.execute(() -> {
                ContextInternal prev = this.context.beginDispatch();
                try {
                    handler.handle(value);
                }
                catch (Throwable t) {
                    this.context.reportException(t);
                }
                finally {
                    this.context.endDispatch(prev);
                }
            });
        } else {
            handler.handle(value);
        }
    }

    @Override
    public <U> Future<U> compose(Function<T, Future<U>> successMapper, Function<Throwable, Future<U>> failureMapper) {
        Objects.requireNonNull(successMapper, "No null success mapper accepted");
        Objects.requireNonNull(failureMapper, "No null failure mapper accepted");
        ComposeTransformation<T, U> transformation = new ComposeTransformation<T, U>(this.context, successMapper, failureMapper);
        this.addListener(transformation);
        return transformation;
    }

    @Override
    public <U> Future<U> map(Function<T, U> mapper) {
        Objects.requireNonNull(mapper, "No null mapper accepted");
        MapTransformation<T, U> transformation = new MapTransformation<T, U>(this.context, mapper);
        this.addListener(transformation);
        return transformation;
    }

    @Override
    public <V> Future<V> map(V value) {
        MapValueTransformation transformation = new MapValueTransformation(this.context, value);
        this.addListener(transformation);
        return transformation;
    }

    @Override
    public Future<T> otherwise(Function<Throwable, T> mapper) {
        Objects.requireNonNull(mapper, "No null mapper accepted");
        OtherwiseTransformation<T> transformation = new OtherwiseTransformation<T>(this.context, mapper);
        this.addListener(transformation);
        return transformation;
    }

    @Override
    public Future<T> otherwise(T value) {
        OtherwiseValueTransformation<T> transformation = new OtherwiseValueTransformation<T>(this.context, value);
        this.addListener(transformation);
        return transformation;
    }
}

