/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.stomp;

import io.vertx.core.Handler;
import io.vertx.ext.stomp.Destination;
import io.vertx.ext.stomp.Frame;
import io.vertx.ext.stomp.Frames;
import io.vertx.ext.stomp.ServerFrame;
import io.vertx.ext.stomp.impl.Transaction;
import io.vertx.ext.stomp.impl.Transactions;
import io.vertx.ext.stomp.utils.Headers;

public class DefaultSendHandler
implements Handler<ServerFrame> {
    public void handle(ServerFrame sf) {
        String destination = sf.frame().getHeader("destination");
        if (destination == null) {
            sf.connection().write(Frames.createErrorFrame("Destination header missing", Headers.create(sf.frame().getHeaders()), "Invalid send frame - the 'destination' must be set"));
            sf.connection().close();
            return;
        }
        String txId = sf.frame().getHeader("transaction");
        if (txId != null) {
            Transaction transaction = Transactions.instance().getTransaction(sf.connection(), txId);
            if (transaction == null) {
                Frame errorFrame = Frames.createErrorFrame("No transaction", Headers.create("destination", destination, "transaction", txId), "Message delivery failed - unknown transaction id");
                sf.connection().write(errorFrame);
                sf.connection().close();
                return;
            }
            if (!transaction.addFrameToTransaction(sf.frame())) {
                Frame errorFrame = Frames.createErrorFrame("Frame not added to transaction", Headers.create("destination", destination, "transaction", txId), "Message delivery failed - the frame cannot be added to the transaction - the number of allowed thread may have been reached");
                Transactions.instance().unregisterTransactionsFromConnection(sf.connection());
                sf.connection().write(errorFrame);
                sf.connection().close();
                return;
            }
            Frames.handleReceipt(sf.frame(), sf.connection());
            return;
        }
        Destination dest = sf.connection().handler().getDestination(destination);
        if (dest == null && sf.connection().server().options().isSendErrorOnNoSubscriptions()) {
            Frame errorFrame = Frames.createErrorFrame("No subscriptions", Headers.create("destination", destination), "Message delivery failed - no subscriptions on this destination");
            sf.connection().write(errorFrame);
            sf.connection().close();
            return;
        }
        if (dest != null && dest.dispatch(sf.connection(), sf.frame()) == null) {
            return;
        }
        Frames.handleReceipt(sf.frame(), sf.connection());
    }
}

