/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

class HttpServerRequestWrapper
implements HttpServerRequest {
    private final HttpServerRequest delegate;
    private HttpMethod method;
    private String path;
    private String uri;
    private String absoluteURI;

    HttpServerRequestWrapper(HttpServerRequest request) {
        this.delegate = request;
        this.method = request.method();
        this.path = request.path();
        this.uri = request.uri();
        this.absoluteURI = null;
    }

    public Future<Buffer> body() {
        return this.delegate.body();
    }

    public long bytesRead() {
        return this.delegate.bytesRead();
    }

    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        return this.delegate.exceptionHandler(handler);
    }

    public HttpServerRequest handler(Handler<Buffer> handler) {
        return this.delegate.handler(handler);
    }

    public HttpServerRequest pause() {
        return this.delegate.pause();
    }

    public HttpServerRequest resume() {
        return this.delegate.resume();
    }

    public HttpServerRequest fetch(long amount) {
        return this.delegate.fetch(amount);
    }

    public HttpServerRequest endHandler(Handler<Void> handler) {
        return this.delegate.endHandler(handler);
    }

    public HttpVersion version() {
        return this.delegate.version();
    }

    HttpServerRequest setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpMethod method() {
        return this.method;
    }

    public String rawMethod() {
        return this.delegate.rawMethod();
    }

    public String uri() {
        return this.uri;
    }

    void setPath(String path) {
        this.path = path;
        this.uri = path;
        this.absoluteURI = null;
    }

    public String path() {
        return this.path;
    }

    public String query() {
        return this.delegate.query();
    }

    public HttpServerResponse response() {
        return this.delegate.response();
    }

    public MultiMap headers() {
        return this.delegate.headers();
    }

    public String getHeader(String s) {
        return this.delegate.getHeader(s);
    }

    public String getHeader(CharSequence charSequence) {
        return this.delegate.getHeader(charSequence);
    }

    public MultiMap params() {
        return this.delegate.params();
    }

    public String getParam(String s) {
        return this.delegate.getParam(s);
    }

    public SocketAddress remoteAddress() {
        return this.delegate.remoteAddress();
    }

    public SocketAddress localAddress() {
        return this.delegate.localAddress();
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        return this.delegate.peerCertificateChain();
    }

    public SSLSession sslSession() {
        return this.delegate.sslSession();
    }

    public String absoluteURI() {
        if (this.absoluteURI == null) {
            try {
                URL url = new URL(this.delegate.absoluteURI());
                URL newUrl = new URL(url.getProtocol(), url.getHost(), url.getPort(), this.uri);
                this.absoluteURI = newUrl.toExternalForm();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return this.absoluteURI;
    }

    public String scheme() {
        return this.delegate.scheme();
    }

    public String host() {
        return this.delegate.host();
    }

    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler(handler);
        return this;
    }

    public HttpConnection connection() {
        return this.delegate.connection();
    }

    public HttpServerRequest bodyHandler(Handler<Buffer> handler) {
        return this.delegate.bodyHandler(handler);
    }

    public NetSocket netSocket() {
        return this.delegate.netSocket();
    }

    public HttpServerRequest setExpectMultipart(boolean b) {
        return this.delegate.setExpectMultipart(b);
    }

    public boolean isExpectMultipart() {
        return this.delegate.isExpectMultipart();
    }

    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        return this.delegate.uploadHandler(handler);
    }

    public MultiMap formAttributes() {
        return this.delegate.formAttributes();
    }

    public String getFormAttribute(String s) {
        return this.delegate.getFormAttribute(s);
    }

    public ServerWebSocket upgrade() {
        return this.delegate.upgrade();
    }

    public boolean isEnded() {
        return this.delegate.isEnded();
    }

    public boolean isSSL() {
        return this.delegate.isSSL();
    }

    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    public StreamPriority streamPriority() {
        return this.delegate.streamPriority();
    }
}

