/*
 * Decompiled with CFR 0.152.
 */
package brave.test.propagation;

import brave.internal.Nullable;
import brave.internal.codec.HexCodec;
import brave.propagation.Propagation;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.test.util.ClassLoaders;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class PropagationTest {
    protected Map<String, String> map = new LinkedHashMap<String, String>();
    MapEntry mapEntry = new MapEntry();
    TraceContext rootSpan = TraceContext.newBuilder().traceId(1L).spanId(1L).sampled(true).build();
    TraceContext childSpan = this.rootSpan.toBuilder().parentId(this.rootSpan.spanId()).spanId(2L).build();
    protected final Propagation<String> propagation = ClassLoaders.newInstance(this.propagationSupplier(), this.getClass().getClassLoader()).get();

    protected abstract Class<? extends Supplier<Propagation<String>>> propagationSupplier();

    protected abstract void inject(Map<String, String> var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @Nullable Boolean var5, @Nullable Boolean var6);

    protected abstract void inject(Map<String, String> var1, SamplingFlags var2);

    protected PropagationTest() {
    }

    @Test
    public void verifyRoundTrip_rootSpan() throws Exception {
        this.inject(this.map, "0000000000000001", null, "0000000000000001", true, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((TraceContext)this.rootSpan));
    }

    @Test
    public void verifyRoundTrip_128BitTrace() throws Exception {
        String high64Bits = "463ac35c9f6413ad";
        String low64Bits = "48485a3953bb6124";
        this.inject(this.map, high64Bits + low64Bits, null, low64Bits, true, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((TraceContext)this.rootSpan.toBuilder().traceIdHigh(HexCodec.lowerHexToUnsignedLong((CharSequence)high64Bits)).traceId(HexCodec.lowerHexToUnsignedLong((CharSequence)low64Bits)).spanId(HexCodec.lowerHexToUnsignedLong((CharSequence)low64Bits)).build()));
    }

    @Test
    public void verifyRoundTrip_childSpan() throws Exception {
        this.inject(this.map, "0000000000000001", "0000000000000001", "0000000000000002", true, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((TraceContext)this.childSpan));
    }

    @Test
    public void verifyRoundTrip_notSampled() throws Exception {
        this.inject(this.map, "0000000000000001", "0000000000000001", "0000000000000002", false, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((TraceContext)this.childSpan.toBuilder().sampled(false).build()));
    }

    @Test
    public void verifyRoundTrip_notSampled_noIds() throws Exception {
        this.inject(this.map, null, null, null, false, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((SamplingFlags)SamplingFlags.NOT_SAMPLED));
    }

    @Test
    public void verifyRoundTrip_sampledTrueNoOtherTraceHeaders() {
        this.inject(this.map, null, null, null, true, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((SamplingFlags)SamplingFlags.SAMPLED));
    }

    @Test
    public void verifyRoundTrip_debug() {
        this.inject(this.map, null, null, null, null, true);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((SamplingFlags)SamplingFlags.DEBUG));
    }

    @Test
    public void verifyRoundTrip_empty() throws Exception {
        this.inject(this.map, null, null, null, null, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((SamplingFlags)SamplingFlags.EMPTY));
    }

    @Test
    public void verifyRoundTrip_externallyProvidedIds() {
        this.inject(this.map, "0000000000000001", null, "0000000000000001", null, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((TraceContext)this.rootSpan.toBuilder().sampled(null).build()));
    }

    void verifyRoundTrip(TraceContextOrSamplingFlags expected) {
        TraceContextOrSamplingFlags extracted = this.propagation.extractor((Propagation.Getter)this.mapEntry).extract(this.map);
        Assertions.assertThat((Object)extracted).isEqualTo((Object)expected);
        LinkedHashMap<String, String> injected = new LinkedHashMap<String, String>();
        if (expected.context() != null) {
            this.propagation.injector((Propagation.Setter)this.mapEntry).inject(expected.context(), injected);
        } else {
            this.inject(injected, expected.samplingFlags());
        }
        Assertions.assertThat(this.map).isEqualTo(injected);
    }

    @Test
    public void unloadable_unused() {
        ClassLoaders.assertRunIsUnloadableWithSupplier(Unused.class, this.propagationSupplier());
    }

    @Test
    public void unloadable_afterBasicUsage() {
        ClassLoaders.assertRunIsUnloadableWithSupplier(BasicUsage.class, this.propagationSupplier());
    }

    static class BasicUsage
    extends ClassLoaders.ConsumerRunnable<Propagation<?>> {
        BasicUsage() {
        }

        @Override
        public void accept(Propagation<?> propagation) {
            TraceContext.Injector injector = propagation.injector(Map::put);
            TraceContext.Extractor extractor = propagation.extractor(Map::get);
            TraceContext ctx = TraceContext.newBuilder().traceId(1L).spanId(2L).sampled(false).build();
            LinkedHashMap map = new LinkedHashMap();
            injector.inject(ctx, map);
            TraceContext extracted = extractor.extract(map).context();
            Assertions.assertThat((String)extracted.traceIdString()).isEqualTo(ctx.traceIdString());
            Assertions.assertThat((String)extracted.spanIdString()).isEqualTo(ctx.spanIdString());
        }
    }

    static class Unused
    extends ClassLoaders.ConsumerRunnable<Propagation<?>> {
        Unused() {
        }

        @Override
        public void accept(Propagation<?> propagation) {
        }
    }

    protected static class MapEntry
    implements Propagation.Getter<Map<String, String>, String>,
    Propagation.Setter<Map<String, String>, String> {
        public void put(Map<String, String> request, String key, String value) {
            request.put(key, value);
        }

        public String get(Map<String, String> request, String key) {
            return request.get(key);
        }
    }
}

