/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.otel.brave;

import brave.Tag;
import brave.Tags;
import brave.handler.MutableSpan;
import io.opentelemetry.proto.trace.v1.TracesData;
import java.util.Collections;
import java.util.Map;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.otel.brave.SpanTranslator;

public final class OtlpProtoV1Encoder
implements BytesEncoder<MutableSpan> {
    final SpanTranslator spanTranslator;

    public static OtlpProtoV1Encoder create() {
        return OtlpProtoV1Encoder.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private OtlpProtoV1Encoder(Builder builder) {
        this.spanTranslator = new SpanTranslator(builder.errorTag, builder.resourceAttributes);
    }

    public Encoding encoding() {
        return Encoding.PROTO3;
    }

    public int sizeInBytes(MutableSpan span) {
        TracesData convert = this.translate(span);
        return this.encoding().listSizeInBytes(convert.getSerializedSize());
    }

    public byte[] encode(MutableSpan span) {
        return this.translate(span).toByteArray();
    }

    TracesData translate(MutableSpan span) {
        return this.spanTranslator.translate(span);
    }

    public static final class Builder {
        Tag<Throwable> errorTag = Tags.ERROR;
        Map<String, String> resourceAttributes = Collections.emptyMap();

        public Builder errorTag(Tag<Throwable> errorTag) {
            if (errorTag == null) {
                throw new NullPointerException("errorTag == null");
            }
            this.errorTag = errorTag;
            return this;
        }

        public Builder resourceAttributes(Map<String, String> resourceAttributes) {
            if (resourceAttributes == null) {
                throw new NullPointerException("resourceAttributes == null");
            }
            this.resourceAttributes = resourceAttributes;
            return this;
        }

        public OtlpProtoV1Encoder build() {
            return new OtlpProtoV1Encoder(this);
        }

        Builder() {
        }
    }
}

