/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.okhttp3;

import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import zipkin2.codec.Encoding;

enum RequestBodyMessageEncoder {
    JSON{

        @Override
        public RequestBody encode(List<byte[]> encodedSpans) {
            return new JsonRequestBody(encodedSpans);
        }
    }
    ,
    THRIFT{

        @Override
        RequestBody encode(List<byte[]> encodedSpans) {
            return new ThriftRequestBody(encodedSpans);
        }
    }
    ,
    PROTO3{

        @Override
        RequestBody encode(List<byte[]> encodedSpans) {
            return new Protobuf3RequestBody(encodedSpans);
        }
    };


    abstract RequestBody encode(List<byte[]> var1);

    static final class Protobuf3RequestBody
    extends StreamingRequestBody {
        static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/x-protobuf");

        Protobuf3RequestBody(List<byte[]> values) {
            super(Encoding.PROTO3, CONTENT_TYPE, values);
        }

        public void writeTo(BufferedSink sink) throws IOException {
            int i = 0;
            int length = this.values.size();
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink.write(next);
            }
        }
    }

    static final class ThriftRequestBody
    extends StreamingRequestBody {
        static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/x-thrift");

        ThriftRequestBody(List<byte[]> values) {
            super(Encoding.THRIFT, CONTENT_TYPE, values);
        }

        public void writeTo(BufferedSink sink) throws IOException {
            int length = this.values.size();
            sink.writeByte(12);
            sink.writeByte(length >>> 24 & 0xFF);
            sink.writeByte(length >>> 16 & 0xFF);
            sink.writeByte(length >>> 8 & 0xFF);
            sink.writeByte(length & 0xFF);
            int i = 0;
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink.write(next);
            }
        }
    }

    static final class JsonRequestBody
    extends StreamingRequestBody {
        static final MediaType CONTENT_TYPE = MediaType.parse((String)"application/json");

        JsonRequestBody(List<byte[]> values) {
            super(Encoding.JSON, CONTENT_TYPE, values);
        }

        public void writeTo(BufferedSink sink) throws IOException {
            sink.writeByte(91);
            int i = 0;
            int length = this.values.size();
            while (i < length) {
                byte[] next = (byte[])this.values.get(i++);
                sink.write(next);
                if (i >= length) continue;
                sink.writeByte(44);
            }
            sink.writeByte(93);
        }
    }

    static abstract class StreamingRequestBody
    extends RequestBody {
        final MediaType contentType;
        final List<byte[]> values;
        final long contentLength;

        StreamingRequestBody(Encoding encoding, MediaType contentType, List<byte[]> values) {
            this.contentType = contentType;
            this.values = values;
            this.contentLength = encoding.listSizeInBytes(values);
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() {
            return this.contentLength;
        }
    }
}

