/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.inject.spi.builder;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.builder.AnnotatedConstructorConfigurator;
import javax.enterprise.inject.spi.builder.AnnotatedFieldConfigurator;
import javax.enterprise.inject.spi.builder.AnnotatedMethodConfigurator;

public interface AnnotatedTypeConfigurator<T> {
    public AnnotatedType<T> getAnnotated();

    public AnnotatedTypeConfigurator<T> add(Annotation var1);

    public AnnotatedTypeConfigurator<T> remove(Annotation var1);

    public AnnotatedTypeConfigurator<T> remove(Class<? extends Annotation> var1);

    public AnnotatedTypeConfigurator<T> removeAll();

    public Set<AnnotatedMethodConfigurator<? super T>> methods();

    default public Stream<AnnotatedMethodConfigurator<? super T>> filterMethods(Predicate<AnnotatedMethod<? super T>> predicate) {
        return this.methods().stream().filter(c -> predicate.test(c.getAnnotated()));
    }

    public Set<AnnotatedFieldConfigurator<? super T>> fields();

    default public Stream<AnnotatedFieldConfigurator<? super T>> filterFields(Predicate<AnnotatedField<? super T>> predicate) {
        return this.fields().stream().filter(f -> predicate.test(f.getAnnotated()));
    }

    public Set<AnnotatedConstructorConfigurator<T>> constructors();

    default public Stream<AnnotatedConstructorConfigurator<T>> filterConstructors(Predicate<AnnotatedConstructor<T>> predicate) {
        return this.constructors().stream().filter(c -> predicate.test(c.getAnnotated()));
    }
}

