/*
 * Decompiled with CFR 0.152.
 */
package javax.jms;

import javax.jms.JMSException;

public class JMSRuntimeException
extends RuntimeException {
    private String errorCode;
    private Exception linkedException;

    public JMSRuntimeException(String reason, String errorCode) {
        super(reason);
        this.errorCode = errorCode;
        this.linkedException = null;
    }

    public JMSRuntimeException(String reason) {
        super(reason);
        this.errorCode = null;
        this.linkedException = null;
    }

    public JMSRuntimeException(JMSException jmsException) {
        super(jmsException);
        this.setLinkedException(jmsException.getLinkedException());
        this.errorCode = jmsException.getErrorCode();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Exception getLinkedException() {
        return this.linkedException;
    }

    public void setLinkedException(Exception ex) {
        this.linkedException = ex;
    }
}

