/*
 * Decompiled with CFR 0.152.
 */
package javax.time;

import java.io.Serializable;
import javax.time.Duration;
import javax.time.InstantProvider;
import javax.time.MathUtils;
import javax.time.calendar.CalendarConversionException;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;

public final class Instant
implements InstantProvider,
Comparable<Instant>,
Serializable {
    public static final Instant EPOCH = new Instant(0L, 0);
    private static final int NANOS_PER_SECOND = 1000000000;
    private static final long serialVersionUID = -9114640809030911667L;
    private final long epochSeconds;
    private final int nanoOfSecond;

    static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    public static Instant instant(InstantProvider instantProvider) {
        Instant.checkNotNull(instantProvider, "InstantProvider must not be null");
        Instant instant = instantProvider.toInstant();
        Instant.checkNotNull(instant, "The implementation of InstantProvider must not return null");
        return instant;
    }

    public static Instant instant(long l) {
        if (l == 0L) {
            return EPOCH;
        }
        return new Instant(l, 0);
    }

    public static Instant instant(long l, int n) {
        if (n >= 1000000000) {
            throw new IllegalArgumentException("Nanosecond fraction must not be more than 999,999,999 but was " + n);
        }
        if (n < 0) {
            if ((n += 1000000000) <= 0) {
                throw new IllegalArgumentException("Nanosecond fraction must not be less than -999,999,999 but was " + n);
            }
            l = MathUtils.safeDecrement(l);
        }
        if (l == 0L && n == 0) {
            return EPOCH;
        }
        return new Instant(l, n);
    }

    public static Instant instant(long l, double d) {
        if (d <= -1.0 || d >= 1.0) {
            throw new IllegalArgumentException("Fraction of second must be between -1 and 1 exclusive but was " + d);
        }
        if (l == 0L && d == 0.0) {
            return EPOCH;
        }
        int n = (int)Math.round(d * 1.0E9);
        if (n < 0) {
            n += 1000000000;
            l = MathUtils.safeDecrement(l);
        }
        return new Instant(l, n);
    }

    public static Instant millisInstant(long l) {
        if (l < 0L) {
            long l2 = ++l / 1000L;
            int n = (int)(l % 1000L);
            n = 999 + n;
            return new Instant(l2 - 1L, n * 1000000);
        }
        if (l == 0L) {
            return EPOCH;
        }
        return new Instant(l / 1000L, (int)(l % 1000L) * 1000000);
    }

    public static Instant millisInstant(long l, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("NanoOfMillisecond must be positive but was " + n);
        }
        if (n > 999999) {
            throw new IllegalArgumentException("NanoOfMillisecond must not be more than 999,999 but was " + n);
        }
        if (l < 0L) {
            long l2 = ++l / 1000L;
            int n2 = (int)(l % 1000L);
            n2 = 999 + n2;
            return new Instant(l2 - 1L, n2 * 1000000 + n);
        }
        if (l == 0L && n == 0) {
            return EPOCH;
        }
        return new Instant(l / 1000L, (int)(l % 1000L) * 1000000 + n);
    }

    private Instant(long l, int n) {
        this.epochSeconds = l;
        this.nanoOfSecond = n;
    }

    public long getEpochSeconds() {
        return this.epochSeconds;
    }

    public int getNanoOfSecond() {
        return this.nanoOfSecond;
    }

    public Instant plus(Duration duration) {
        long l = duration.getSeconds();
        int n = duration.getNanosAdjustment();
        if (l == 0L && n == 0) {
            return this;
        }
        long l2 = MathUtils.safeAdd(this.epochSeconds, l);
        int n2 = this.nanoOfSecond + n;
        if (n2 >= 1000000000) {
            n2 -= 1000000000;
            l2 = MathUtils.safeIncrement(l2);
        }
        return new Instant(l2, n2);
    }

    public Instant plusSeconds(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = MathUtils.safeAdd(this.epochSeconds, l);
        return new Instant(l2, this.nanoOfSecond);
    }

    public Instant plusMillis(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = l / 1000L;
        int n = (int)(l % 1000L) * 1000000;
        if ((n += this.nanoOfSecond) < 0) {
            n += 1000000000;
            --l2;
        } else if (n >= 1000000000) {
            n -= 1000000000;
            ++l2;
        }
        return new Instant(MathUtils.safeAdd(this.epochSeconds, l2), n);
    }

    public Instant plusNanos(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = l / 1000000000L;
        int n = (int)(l % 1000000000L);
        if ((n += this.nanoOfSecond) < 0) {
            n += 1000000000;
            --l2;
        } else if (n >= 1000000000) {
            n -= 1000000000;
            ++l2;
        }
        return new Instant(MathUtils.safeAdd(this.epochSeconds, l2), n);
    }

    public Instant minus(Duration duration) {
        long l = duration.getSeconds();
        int n = duration.getNanosAdjustment();
        if (l == 0L && n == 0) {
            return this;
        }
        long l2 = MathUtils.safeSubtract(this.epochSeconds, l);
        int n2 = this.nanoOfSecond - n;
        if (n2 < 0) {
            n2 += 1000000000;
            l2 = MathUtils.safeDecrement(l2);
        }
        return new Instant(l2, n2);
    }

    public Instant minusSeconds(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = MathUtils.safeSubtract(this.epochSeconds, l);
        return new Instant(l2, this.nanoOfSecond);
    }

    public Instant minusMillis(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = l / 1000L;
        int n = (int)(l % 1000L) * 1000000;
        if ((n = this.nanoOfSecond - n) < 0) {
            n += 1000000000;
            ++l2;
        } else if (n >= 1000000000) {
            n -= 1000000000;
            --l2;
        }
        return new Instant(MathUtils.safeSubtract(this.epochSeconds, l2), n);
    }

    public Instant minusNanos(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = l / 1000000000L;
        int n = (int)(l % 1000000000L);
        if ((n = this.nanoOfSecond - n) < 0) {
            n += 1000000000;
            ++l2;
        } else if (n >= 1000000000) {
            n -= 1000000000;
            --l2;
        }
        return new Instant(MathUtils.safeSubtract(this.epochSeconds, l2), n);
    }

    public long toEpochMillis() {
        try {
            long l = MathUtils.safeMultiply(this.epochSeconds, 1000);
            return l + (long)(this.nanoOfSecond / 1000000);
        }
        catch (ArithmeticException arithmeticException) {
            throw new CalendarConversionException("The Instant cannot be represented as epoch milliseconds");
        }
    }

    @Override
    public Instant toInstant() {
        return this;
    }

    @Override
    public int compareTo(Instant instant) {
        int n = MathUtils.safeCompare(this.epochSeconds, instant.epochSeconds);
        if (n != 0) {
            return n;
        }
        return MathUtils.safeCompare(this.nanoOfSecond, instant.nanoOfSecond);
    }

    public boolean isAfter(Instant instant) {
        return this.compareTo(instant) > 0;
    }

    public boolean isBefore(Instant instant) {
        return this.compareTo(instant) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return this.epochSeconds == instant.epochSeconds && this.nanoOfSecond == instant.nanoOfSecond;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.epochSeconds ^ this.epochSeconds >>> 32) + 51 * this.nanoOfSecond;
    }

    public String toString() {
        return OffsetDateTime.fromInstant(this, ZoneOffset.UTC).toLocalDateTime().toString() + 'Z';
    }
}

