/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.calendar.DateResolver;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.Year;

public final class CalendricalContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean strict;
    private final DateResolver dateResolver;
    private final boolean checkUnusedFields;

    public CalendricalContext(boolean bl, boolean bl2) {
        this.strict = bl;
        this.dateResolver = null;
        this.checkUnusedFields = bl2;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isCheckUnusedFields() {
        return this.checkUnusedFields;
    }

    public DateResolver getDateResolver() {
        return this.dateResolver;
    }

    public LocalDate resolveDate(int n, int n2, int n3) {
        if (this.dateResolver != null) {
            return this.dateResolver.resolveDate(Year.isoYear(n), MonthOfYear.monthOfYear(n2), DayOfMonth.dayOfMonth(n3));
        }
        if (this.strict) {
            return LocalDate.date(n, n2, n3);
        }
        if (n2 >= 1 && n2 <= 12) {
            if (n3 >= 1 && n3 <= 28) {
                return LocalDate.date(n, n2, n3);
            }
            return LocalDate.date(n, n2, 1).plusDays((long)n3 - 1L);
        }
        return LocalDate.date(n, 1, 1).plusMonths(n2).plusMonths(-1).plusDays((long)n3 - 1L);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CalendricalContext) {
            CalendricalContext calendricalContext = (CalendricalContext)object;
            return this.strict == calendricalContext.strict && (this.dateResolver == calendricalContext.dateResolver || this.dateResolver != null && this.dateResolver.equals(calendricalContext.dateResolver)) && this.checkUnusedFields == calendricalContext.checkUnusedFields;
        }
        return false;
    }

    public int hashCode() {
        return (this.strict ? 1 : 0) + (this.dateResolver == null ? 0 : this.dateResolver.hashCode()) + (this.checkUnusedFields ? 1 : 0);
    }
}

