/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.MonthOfYear;

public final class DateAdjusters {
    private DateAdjusters() {
    }

    public static DateAdjuster lastDayOfMonth() {
        return Impl.LAST_DAY_OF_MONTH;
    }

    public static DateAdjuster lastDayOfYear() {
        return Impl.LAST_DAY_OF_YEAR;
    }

    public static DateAdjuster nextNonWeekendDay() {
        return Impl.NEXT_NON_WEEKEND;
    }

    public static DateAdjuster firstInMonth(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("DayOfWeek must not be null");
        }
        return new DayOfWeekInMonth(1, dayOfWeek);
    }

    public static DateAdjuster dayOfWeekInMonth(int n, DayOfWeek dayOfWeek) {
        if (n < 1 || n > 5) {
            throw new IllegalArgumentException("Illegal value for ordinal, value " + n + " is not in the range 1 to 5");
        }
        if (dayOfWeek == null) {
            throw new NullPointerException("DayOfWeek must not be null");
        }
        return new DayOfWeekInMonth(n, dayOfWeek);
    }

    public static DateAdjuster next(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("dow must not be null");
        }
        return new RelativeDayOfWeek(2, dayOfWeek);
    }

    public static DateAdjuster nextOrCurrent(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("dow must not be null");
        }
        return new RelativeDayOfWeek(0, dayOfWeek);
    }

    public static DateAdjuster previous(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("dow must not be null");
        }
        return new RelativeDayOfWeek(3, dayOfWeek);
    }

    public static DateAdjuster previousOrCurrent(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("dow must not be null");
        }
        return new RelativeDayOfWeek(1, dayOfWeek);
    }

    private static final class RelativeDayOfWeek
    implements DateAdjuster,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int relative;
        private final DayOfWeek dow;

        private RelativeDayOfWeek(int n, DayOfWeek dayOfWeek) {
            this.relative = n;
            this.dow = dayOfWeek;
        }

        @Override
        public LocalDate adjustDate(LocalDate localDate) {
            DayOfWeek dayOfWeek = localDate.getDayOfWeek();
            if (this.relative < 2 && dayOfWeek == this.dow) {
                return localDate;
            }
            if ((this.relative & 1) == 0) {
                int n = dayOfWeek.ordinal() - this.dow.ordinal();
                return localDate.plusDays(n >= 0 ? (long)(7 - n) : (long)(-n));
            }
            int n = this.dow.ordinal() - dayOfWeek.ordinal();
            return localDate.minusDays(n >= 0 ? (long)(7 - n) : (long)(-n));
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof RelativeDayOfWeek)) {
                return false;
            }
            RelativeDayOfWeek relativeDayOfWeek = (RelativeDayOfWeek)object;
            if (this.relative != relativeDayOfWeek.relative) {
                return false;
            }
            return this.dow == relativeDayOfWeek.dow;
        }

        public int hashCode() {
            int n = 13;
            n = 19 * n + this.relative;
            n = 19 * n + this.dow.hashCode();
            return n;
        }
    }

    private static final class DayOfWeekInMonth
    implements DateAdjuster,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int ordinal;
        private final DayOfWeek dayOfWeek;

        private DayOfWeekInMonth(int n, DayOfWeek dayOfWeek) {
            this.ordinal = n;
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public LocalDate adjustDate(LocalDate localDate) {
            LocalDate localDate2 = localDate.withDayOfMonth(1);
            int n = localDate2.getDayOfWeek().ordinal();
            int n2 = this.dayOfWeek.ordinal();
            int n3 = (n2 - n + 7) % 7;
            return localDate2.plusDays(n3 += (this.ordinal - 1) * 7);
        }

        public boolean equals(Object object) {
            if (object instanceof DayOfWeekInMonth) {
                DayOfWeekInMonth dayOfWeekInMonth = (DayOfWeekInMonth)object;
                return this.ordinal == dayOfWeekInMonth.ordinal && this.dayOfWeek == dayOfWeekInMonth.dayOfWeek;
            }
            return false;
        }

        public int hashCode() {
            return this.ordinal + 8 * this.dayOfWeek.ordinal();
        }
    }

    private static enum Impl implements DateAdjuster
    {
        LAST_DAY_OF_MONTH{

            @Override
            public LocalDate adjustDate(LocalDate localDate) {
                DayOfMonth dayOfMonth = localDate.getMonthOfYear().getLastDayOfMonth(localDate.toYear());
                return localDate.with(dayOfMonth);
            }
        }
        ,
        LAST_DAY_OF_YEAR{

            @Override
            public LocalDate adjustDate(LocalDate localDate) {
                return LocalDate.date(localDate.getYear(), MonthOfYear.DECEMBER, 31);
            }
        }
        ,
        NEXT_NON_WEEKEND{

            @Override
            public LocalDate adjustDate(LocalDate localDate) {
                DayOfWeek dayOfWeek = localDate.getDayOfWeek();
                switch (dayOfWeek) {
                    case SATURDAY: {
                        return localDate.plusDays(2L);
                    }
                    case FRIDAY: {
                        return localDate.plusDays(3L);
                    }
                }
                return localDate.plusDays(1L);
            }
        };

    }
}

