/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.calendar.DateResolver;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.Year;

public final class DateResolvers {
    private DateResolvers() {
    }

    public static DateResolver strict() {
        return Strict.INSTANCE;
    }

    public static DateResolver previousValid() {
        return PreviousValid.INSTANCE;
    }

    public static DateResolver nextValid() {
        return NextValid.INSTANCE;
    }

    public static DateResolver partLenient() {
        return PartLenient.INSTANCE;
    }

    private static class PartLenient
    implements DateResolver,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final DateResolver INSTANCE = new PartLenient();

        private PartLenient() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public LocalDate resolveDate(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth) {
            int n = monthOfYear.lengthInDays(year);
            if (dayOfMonth.getValue() > n) {
                return LocalDate.date(year, monthOfYear.next(), DayOfMonth.dayOfMonth(dayOfMonth.getValue() - n));
            }
            return LocalDate.date(year, monthOfYear, dayOfMonth);
        }
    }

    private static class NextValid
    implements DateResolver,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final DateResolver INSTANCE = new NextValid();

        private NextValid() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public LocalDate resolveDate(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth) {
            int n = monthOfYear.lengthInDays(year);
            if (dayOfMonth.getValue() > n) {
                return LocalDate.date(year, monthOfYear.next(), DayOfMonth.dayOfMonth(1));
            }
            return LocalDate.date(year, monthOfYear, dayOfMonth);
        }
    }

    private static class PreviousValid
    implements DateResolver,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final DateResolver INSTANCE = new PreviousValid();

        private PreviousValid() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public LocalDate resolveDate(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth) {
            int n = monthOfYear.lengthInDays(year);
            if (dayOfMonth.getValue() > n) {
                return LocalDate.date(year, monthOfYear, DayOfMonth.dayOfMonth(n));
            }
            return LocalDate.date(year, monthOfYear, dayOfMonth);
        }
    }

    private static class Strict
    implements DateResolver,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final DateResolver INSTANCE = new Strict();

        private Strict() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public LocalDate resolveDate(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth) {
            return LocalDate.date(year, monthOfYear, dayOfMonth);
        }
    }
}

