/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalTime;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.UnsupportedCalendarFieldException;

public final class DateTimeFields
implements CalendricalProvider,
DateMatcher,
TimeMatcher,
Iterable<DateTimeFieldRule>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFields EMPTY = new DateTimeFields(DateTimeFields.createMap());
    private final TreeMap<DateTimeFieldRule, Integer> fieldValueMap;

    public static DateTimeFields fields() {
        return EMPTY;
    }

    public static DateTimeFields fields(DateTimeFieldRule dateTimeFieldRule, int n) {
        ISOChronology.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        dateTimeFieldRule.checkValue(n);
        TreeMap<DateTimeFieldRule, Integer> treeMap = DateTimeFields.createMap();
        treeMap.put(dateTimeFieldRule, n);
        return new DateTimeFields(treeMap);
    }

    public static DateTimeFields fields(DateTimeFieldRule dateTimeFieldRule, int n, DateTimeFieldRule dateTimeFieldRule2, int n2) {
        ISOChronology.checkNotNull(dateTimeFieldRule, "First DateTimeFieldRule must not be null");
        ISOChronology.checkNotNull(dateTimeFieldRule2, "Second DateTimeFieldRule must not be null");
        dateTimeFieldRule.checkValue(n);
        dateTimeFieldRule2.checkValue(n2);
        TreeMap<DateTimeFieldRule, Integer> treeMap = DateTimeFields.createMap();
        treeMap.put(dateTimeFieldRule, n);
        treeMap.put(dateTimeFieldRule2, n2);
        return new DateTimeFields(treeMap);
    }

    public static DateTimeFields fields(Map<DateTimeFieldRule, Integer> map) {
        ISOChronology.checkNotNull(map, "Field-value map must not be null");
        if (map.isEmpty()) {
            return EMPTY;
        }
        TreeMap<DateTimeFieldRule, Integer> treeMap = DateTimeFields.createMap();
        for (Map.Entry<DateTimeFieldRule, Integer> entry : map.entrySet()) {
            DateTimeFieldRule dateTimeFieldRule = entry.getKey();
            Integer n = entry.getValue();
            ISOChronology.checkNotNull(dateTimeFieldRule, "Null keys are not permitted in field-value map");
            ISOChronology.checkNotNull(n, "Null values are not permitted in field-value map");
            dateTimeFieldRule.checkValue(n);
            treeMap.put(dateTimeFieldRule, n);
        }
        return new DateTimeFields(treeMap);
    }

    private static TreeMap<DateTimeFieldRule, Integer> createMap() {
        return new TreeMap<DateTimeFieldRule, Integer>(Collections.reverseOrder());
    }

    private DateTimeFields(TreeMap<DateTimeFieldRule, Integer> treeMap) {
        this.fieldValueMap = treeMap;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.fieldValueMap.isEmpty() ? EMPTY : this;
    }

    public int size() {
        return this.fieldValueMap.size();
    }

    @Override
    public Iterator<DateTimeFieldRule> iterator() {
        return this.fieldValueMap.keySet().iterator();
    }

    public boolean contains(DateTimeFieldRule dateTimeFieldRule) {
        return dateTimeFieldRule != null && this.fieldValueMap.containsKey(dateTimeFieldRule);
    }

    public int get(DateTimeFieldRule dateTimeFieldRule) {
        ISOChronology.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        Integer n = this.fieldValueMap.get(dateTimeFieldRule);
        if (n == null) {
            throw new UnsupportedCalendarFieldException(dateTimeFieldRule, "DateTimeFields");
        }
        return n;
    }

    public Integer getQuiet(DateTimeFieldRule dateTimeFieldRule) {
        return dateTimeFieldRule == null ? null : this.fieldValueMap.get(dateTimeFieldRule);
    }

    public DateTimeFields with(DateTimeFieldRule dateTimeFieldRule, int n) {
        ISOChronology.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        dateTimeFieldRule.checkValue(n);
        TreeMap<DateTimeFieldRule, Integer> treeMap = this.clonedMap();
        treeMap.put(dateTimeFieldRule, n);
        return new DateTimeFields(treeMap);
    }

    public DateTimeFields with(DateTimeFields dateTimeFields) {
        ISOChronology.checkNotNull(dateTimeFields, "DateTimeFields must not be null");
        if (dateTimeFields.size() == 0 || dateTimeFields == this) {
            return this;
        }
        TreeMap<DateTimeFieldRule, Integer> treeMap = this.clonedMap();
        treeMap.putAll(dateTimeFields.fieldValueMap);
        return new DateTimeFields(treeMap);
    }

    public DateTimeFields withFieldRemoved(DateTimeFieldRule dateTimeFieldRule) {
        ISOChronology.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        TreeMap<DateTimeFieldRule, Integer> treeMap = this.clonedMap();
        if (treeMap.remove(dateTimeFieldRule) == null) {
            return this;
        }
        return treeMap.isEmpty() ? EMPTY : new DateTimeFields(treeMap);
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        ISOChronology.checkNotNull(localDate, "LocalDate must not be null");
        for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
            Integer n = entry.getKey().getValueQuiet(localDate, null);
            if (n == null || n.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        ISOChronology.checkNotNull(localTime, "LocalTime must not be null");
        for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
            Integer n = entry.getKey().getValueQuiet(null, localTime);
            if (n == null || n.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public SortedMap<DateTimeFieldRule, Integer> toFieldValueMap() {
        return new TreeMap<DateTimeFieldRule, Integer>((SortedMap<DateTimeFieldRule, Integer>)this.fieldValueMap);
    }

    private TreeMap<DateTimeFieldRule, Integer> clonedMap() {
        TreeMap<DateTimeFieldRule, Integer> treeMap = DateTimeFields.createMap();
        treeMap.putAll(this.fieldValueMap);
        return treeMap;
    }

    void copyInto(Map<DateTimeFieldRule, Integer> map) {
        map.putAll(this.fieldValueMap);
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DateTimeFields) {
            DateTimeFields dateTimeFields = (DateTimeFields)object;
            return this.fieldValueMap.equals(dateTimeFields.fieldValueMap);
        }
        return false;
    }

    public int hashCode() {
        return this.fieldValueMap.hashCode();
    }

    public String toString() {
        return this.fieldValueMap.toString();
    }
}

