/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.util.HashMap;
import javax.time.CalendricalException;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateResolvers;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.DateTimeFields;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.MonthDay;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.TimeZone;
import javax.time.calendar.YearMonth;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZoneResolvers;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.DayOfYear;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.Year;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;

public final class LocalDate
implements CalendricalProvider,
DateProvider,
DateMatcher,
DateAdjuster,
Comparable<LocalDate>,
Serializable {
    private static final long serialVersionUID = 798274969L;
    private final int year;
    private final MonthOfYear month;
    private final int day;

    public static LocalDate date(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth) {
        ISOChronology.checkNotNull(year, "Year must not be null");
        ISOChronology.checkNotNull(monthOfYear, "MonthOfYear must not be null");
        ISOChronology.checkNotNull(dayOfMonth, "DayOfMonth must not be null");
        return LocalDate.create(year.getValue(), monthOfYear, dayOfMonth.getValue());
    }

    public static LocalDate date(int n, MonthOfYear monthOfYear, int n2) {
        ISOChronology.yearRule().checkValue(n);
        ISOChronology.checkNotNull(monthOfYear, "MonthOfYear must not be null");
        ISOChronology.dayOfMonthRule().checkValue(n2);
        return LocalDate.create(n, monthOfYear, n2);
    }

    public static LocalDate date(int n, int n2, int n3) {
        ISOChronology.yearRule().checkValue(n);
        ISOChronology.monthOfYearRule().checkValue(n2);
        ISOChronology.dayOfMonthRule().checkValue(n3);
        return LocalDate.create(n, MonthOfYear.monthOfYear(n2), n3);
    }

    public static LocalDate date(DateProvider dateProvider) {
        ISOChronology.checkNotNull(dateProvider, "DateProvider must not be null");
        LocalDate localDate = dateProvider.toLocalDate();
        ISOChronology.checkNotNull(localDate, "DateProvider implementation must not return null");
        return localDate;
    }

    public static LocalDate fromEpochDays(long l) {
        return LocalDate.fromYearZeroDays(l + 719528L);
    }

    public static LocalDate fromModifiedJulianDays(long l) {
        return LocalDate.fromYearZeroDays(l + 678941L);
    }

    static LocalDate fromYearZeroDays(long l) {
        long l2;
        long l3;
        long l4 = 0L;
        if ((l -= 60L) < 0L) {
            l3 = (l + 1L) / 146097L - 1L;
            l4 = l3 * 400L;
            l += -l3 * 146097L;
        }
        if ((l2 = l - (365L * (l3 = (400L * l + 591L) / 146097L) + l3 / 4L - l3 / 100L + l3 / 400L)) < 0L) {
            l2 = l - (365L * --l3 + l3 / 4L - l3 / 100L + l3 / 400L);
        }
        l3 += l4;
        int n = (int)l2;
        int n2 = (n * 5 + 2) / 153;
        int n3 = (n2 + 2) % 12 + 1;
        int n4 = n - (n2 * 306 + 5) / 10 + 1;
        int n5 = ISOChronology.yearRule().checkValue(l3 += (long)(n2 / 10));
        return new LocalDate(n5, MonthOfYear.monthOfYear(n3), n4);
    }

    public static LocalDate parse(String string) {
        ISOChronology.checkNotNull(string, "Text to parse must not be null");
        return DateTimeFormatters.isoLocalDate().parse(string).mergeStrict().toLocalDate();
    }

    private static LocalDate create(int n, MonthOfYear monthOfYear, int n2) {
        if (n2 > monthOfYear.lengthInDays(n)) {
            if (n2 == 29) {
                throw new InvalidCalendarFieldException("Illegal value for DayOfMonth field, value 29 is not valid as " + n + " is not a leap year", ISOChronology.dayOfMonthRule());
            }
            throw new InvalidCalendarFieldException("Illegal value for DayOfMonth field, value " + n2 + " is not valid for month " + monthOfYear.name(), ISOChronology.dayOfMonthRule());
        }
        return new LocalDate(n, monthOfYear, n2);
    }

    private LocalDate(int n, MonthOfYear monthOfYear, int n2) {
        this.year = n;
        this.month = monthOfYear;
        this.day = n2;
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    public boolean isSupported(DateTimeFieldRule dateTimeFieldRule) {
        return dateTimeFieldRule != null && dateTimeFieldRule.isSupported(this, null);
    }

    public int get(DateTimeFieldRule dateTimeFieldRule) {
        ISOChronology.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        return dateTimeFieldRule.getValue(this, null);
    }

    public YearMonth getYearMonth() {
        return YearMonth.yearMonth(this.year, this.month);
    }

    public MonthDay getMonthDay() {
        return MonthDay.monthDay(this.month, this.day);
    }

    public Year toYear() {
        return Year.isoYear(this.year);
    }

    public MonthOfYear toMonthOfYear() {
        return this.month;
    }

    public DayOfMonth toDayOfMonth() {
        return DayOfMonth.dayOfMonth(this.day);
    }

    public DayOfYear toDayOfYear() {
        return DayOfYear.dayOfYear(this);
    }

    public DayOfWeek toDayOfWeek() {
        return DayOfWeek.dayOfWeek(this);
    }

    public int getYear() {
        return this.year;
    }

    public MonthOfYear getMonthOfYear() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfYear() {
        return DayOfYear.dayOfYear(this).getValue();
    }

    public DayOfWeek getDayOfWeek() {
        return DayOfWeek.dayOfWeek(this);
    }

    private LocalDate resolveDate(DateResolver dateResolver, int n, MonthOfYear monthOfYear, int n2) {
        LocalDate localDate = dateResolver.resolveDate(Year.isoYear(n), monthOfYear, DayOfMonth.dayOfMonth(n2));
        ISOChronology.checkNotNull(localDate, "DateResolver implementation must not return null");
        return localDate;
    }

    public LocalDate with(DateAdjuster dateAdjuster) {
        ISOChronology.checkNotNull(dateAdjuster, "DateAdjuster must not be null");
        LocalDate localDate = dateAdjuster.adjustDate(this);
        ISOChronology.checkNotNull(localDate, "DateAdjuster implementation must not return null");
        return localDate;
    }

    public LocalDate withYear(int n) {
        return this.withYear(n, DateResolvers.previousValid());
    }

    public LocalDate withYear(int n, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (this.year == n) {
            return this;
        }
        return this.resolveDate(dateResolver, n, this.month, this.day);
    }

    public LocalDate withMonthOfYear(int n) {
        return this.withMonthOfYear(n, DateResolvers.previousValid());
    }

    public LocalDate withMonthOfYear(int n, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (this.month.getValue() == n) {
            return this;
        }
        return this.resolveDate(dateResolver, this.year, MonthOfYear.monthOfYear(n), this.day);
    }

    public LocalDate withDayOfMonth(int n) {
        if (this.day == n) {
            return this;
        }
        return LocalDate.date(this.year, this.month, n);
    }

    public LocalDate withDayOfMonth(int n, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (this.day == n) {
            return this;
        }
        return this.resolveDate(dateResolver, this.year, this.month, n);
    }

    public LocalDate plus(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        return this.plusYears(period.getYears()).plusMonths(period.getMonths()).plusDays(period.getDays());
    }

    public LocalDate plusYears(int n) {
        return this.plusYears(n, DateResolvers.previousValid());
    }

    public LocalDate plusYears(int n, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (n == 0) {
            return this;
        }
        int n2 = ISOChronology.addYears(this.year, n);
        return this.resolveDate(dateResolver, n2, this.month, this.day);
    }

    public LocalDate plusMonths(int n) {
        return this.plusMonths(n, DateResolvers.previousValid());
    }

    public LocalDate plusMonths(int n, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (n == 0) {
            return this;
        }
        long l = this.month.getValue() - 1;
        int n2 = (int)((l += (long)n) / 12L);
        if ((l %= 12L) < 0L) {
            l += 12L;
            --n2;
        }
        int n3 = ISOChronology.addYears(this.year, n2);
        MonthOfYear monthOfYear = MonthOfYear.monthOfYear((int)(++l));
        return this.resolveDate(dateResolver, n3, monthOfYear, this.day);
    }

    public LocalDate plusWeeks(int n) {
        return this.plusDays(7L * (long)n);
    }

    public LocalDate plusDays(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = this.toModifiedJulianDays();
        try {
            l2 = MathUtils.safeAdd(l2, l);
        }
        catch (ArithmeticException arithmeticException) {
            throw new CalendricalException(this + " + " + l + " days exceeds the current capacity");
        }
        return LocalDate.fromModifiedJulianDays(l2);
    }

    public LocalDate minus(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        return this.minusYears(period.getYears()).minusMonths(period.getMonths()).minusDays(period.getDays());
    }

    public LocalDate minusYears(int n) {
        return this.minusYears(n, DateResolvers.previousValid());
    }

    public LocalDate minusYears(int n, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (n == 0) {
            return this;
        }
        int n2 = ISOChronology.subtractYears(this.year, n);
        return this.resolveDate(dateResolver, n2, this.month, this.day);
    }

    public LocalDate minusMonths(int n) {
        return this.minusMonths(n, DateResolvers.previousValid());
    }

    public LocalDate minusMonths(int n, DateResolver dateResolver) {
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (n == 0) {
            return this;
        }
        long l = this.month.getValue() - 1;
        int n2 = (int)((l -= (long)n) / 12L);
        if ((l %= 12L) < 0L) {
            l += 12L;
            --n2;
        }
        int n3 = ISOChronology.subtractYears(this.year, -n2);
        MonthOfYear monthOfYear = MonthOfYear.monthOfYear((int)(++l));
        return this.resolveDate(dateResolver, n3, monthOfYear, this.day);
    }

    public LocalDate minusWeeks(int n) {
        return this.minusDays(7L * (long)n);
    }

    public LocalDate minusDays(long l) {
        if (l == 0L) {
            return this;
        }
        long l2 = this.toModifiedJulianDays();
        try {
            l2 = MathUtils.safeSubtract(l2, l);
        }
        catch (ArithmeticException arithmeticException) {
            throw new CalendricalException(this + " - " + l + " days exceeds the current capacity");
        }
        return LocalDate.fromModifiedJulianDays(l2);
    }

    public boolean matches(DateMatcher dateMatcher) {
        return dateMatcher.matchesDate(this);
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return this.year == localDate.year && this.month == localDate.month && this.day == localDate.day;
    }

    @Override
    public LocalDate adjustDate(LocalDate localDate) {
        return this.matchesDate(localDate) ? localDate : this;
    }

    public LocalDateTime atTime(LocalTime localTime) {
        return LocalDateTime.dateTime(this, localTime);
    }

    public LocalDateTime atMidnight() {
        return LocalDateTime.dateTime(this, LocalTime.MIDNIGHT);
    }

    public OffsetDate atOffset(ZoneOffset zoneOffset) {
        return OffsetDate.date(this, zoneOffset);
    }

    public ZonedDateTime atStartOfDayInZone(TimeZone timeZone) {
        return ZonedDateTime.dateTime(this, LocalTime.MIDNIGHT, timeZone, ZoneResolvers.postGapPreOverlap());
    }

    public DateTimeFields toDateTimeFields() {
        HashMap<DateTimeFieldRule, Integer> hashMap = new HashMap<DateTimeFieldRule, Integer>();
        hashMap.put(ISOChronology.yearRule(), this.year);
        hashMap.put(ISOChronology.monthOfYearRule(), this.month.getValue());
        hashMap.put(ISOChronology.dayOfMonthRule(), this.day);
        return DateTimeFields.fields(hashMap);
    }

    @Override
    public LocalDate toLocalDate() {
        return this;
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(this, null, null, null);
    }

    public long toEpochDays() {
        return this.toYearZeroDays() - 719528L;
    }

    public long toModifiedJulianDays() {
        return this.toYearZeroDays() - 678941L;
    }

    long toYearZeroDays() {
        long l = this.year;
        long l2 = this.month.getValue();
        long l3 = 0L;
        l3 += 365L * l;
        l3 = l >= 0L ? (l3 += (l + 3L) / 4L - (l + 99L) / 100L + (l + 399L) / 400L) : (l3 -= l / -4L - l / -100L + l / -400L);
        l3 += (367L * l2 - 362L) / 12L;
        l3 += (long)(this.day - 1);
        if (l2 > 2L) {
            --l3;
            if (!ISOChronology.isLeapYear(this.year)) {
                --l3;
            }
        }
        return l3;
    }

    @Override
    public int compareTo(LocalDate localDate) {
        int n = MathUtils.safeCompare(this.year, localDate.year);
        if (n == 0 && (n = this.month.compareTo(localDate.month)) == 0) {
            n = MathUtils.safeCompare(this.day, localDate.day);
        }
        return n;
    }

    public boolean isAfter(LocalDate localDate) {
        return this.compareTo(localDate) > 0;
    }

    public boolean isBefore(LocalDate localDate) {
        return this.compareTo(localDate) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return this.matchesDate(localDate);
        }
        return false;
    }

    public int hashCode() {
        int n = this.year;
        int n2 = this.month.getValue();
        int n3 = this.day;
        return n & 0xFFFFF800 ^ (n << 11) + (n2 << 6) + n3;
    }

    public String toString() {
        int n = this.year;
        int n2 = this.month.getValue();
        int n3 = this.day;
        int n4 = Math.abs(n);
        StringBuilder stringBuilder = new StringBuilder(10);
        if (n4 < 1000) {
            if (n < 0) {
                stringBuilder.append(n - 10000).deleteCharAt(1);
            } else {
                stringBuilder.append(n + 10000).deleteCharAt(0);
            }
        } else {
            if (n > 9999) {
                stringBuilder.append('+');
            }
            stringBuilder.append(n);
        }
        return stringBuilder.append(n2 < 10 ? "-0" : "-").append(n2).append(n3 < 10 ? "-0" : "-").append(n3).toString();
    }
}

