/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.util.HashMap;
import javax.time.CalendricalException;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.DateTimeFields;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.field.HourOfDay;
import javax.time.calendar.field.MinuteOfHour;
import javax.time.calendar.field.NanoOfSecond;
import javax.time.calendar.field.SecondOfMinute;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;

public final class LocalTime
implements TimeProvider,
CalendricalProvider,
Comparable<LocalTime>,
Serializable,
TimeMatcher,
TimeAdjuster {
    public static final LocalTime[] HOURS = new LocalTime[24];
    public static final LocalTime MIDNIGHT;
    public static final LocalTime MIDDAY;
    private static final long serialVersionUID = 798759096L;
    private static final int HOURS_PER_DAY = 24;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int MINUTES_PER_DAY = 1440;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long NANOS_PER_MINUTE = 60000000000L;
    private static final long NANOS_PER_HOUR = 3600000000000L;
    private static final long NANOS_PER_DAY = 86400000000000L;
    private final byte hour;
    private final byte minute;
    private final byte second;
    private final int nano;

    public static LocalTime time(HourOfDay hourOfDay, MinuteOfHour minuteOfHour) {
        return LocalTime.time(hourOfDay, minuteOfHour, SecondOfMinute.secondOfMinute(0), NanoOfSecond.ZERO);
    }

    public static LocalTime time(HourOfDay hourOfDay, MinuteOfHour minuteOfHour, SecondOfMinute secondOfMinute) {
        return LocalTime.time(hourOfDay, minuteOfHour, secondOfMinute, NanoOfSecond.ZERO);
    }

    public static LocalTime time(HourOfDay hourOfDay, MinuteOfHour minuteOfHour, SecondOfMinute secondOfMinute, NanoOfSecond nanoOfSecond) {
        if (hourOfDay == null) {
            throw new NullPointerException("HourOfDay must not be null");
        }
        if (minuteOfHour == null) {
            throw new NullPointerException("MinuteOfHour must not be null");
        }
        if (secondOfMinute == null) {
            throw new NullPointerException("SecondOfMinute must not be null");
        }
        if (nanoOfSecond == null) {
            throw new NullPointerException("NanoOfSecond must not be null");
        }
        return LocalTime.time(hourOfDay.getValue(), minuteOfHour.getValue(), secondOfMinute.getValue(), nanoOfSecond.getValue());
    }

    public static LocalTime time(int n, int n2) {
        ISOChronology.hourOfDayRule().checkValue(n);
        if (n2 == 0) {
            return HOURS[n];
        }
        ISOChronology.minuteOfHourRule().checkValue(n2);
        return new LocalTime(n, n2, 0, 0);
    }

    public static LocalTime time(int n, int n2, int n3) {
        ISOChronology.hourOfDayRule().checkValue(n);
        if ((n2 | n3) == 0) {
            return HOURS[n];
        }
        ISOChronology.minuteOfHourRule().checkValue(n2);
        ISOChronology.secondOfMinuteRule().checkValue(n3);
        return new LocalTime(n, n2, n3, 0);
    }

    public static LocalTime time(int n, int n2, int n3, int n4) {
        ISOChronology.hourOfDayRule().checkValue(n);
        ISOChronology.minuteOfHourRule().checkValue(n2);
        ISOChronology.secondOfMinuteRule().checkValue(n3);
        ISOChronology.nanoOfSecondRule().checkValue(n4);
        return LocalTime.create(n, n2, n3, n4);
    }

    public static LocalTime time(TimeProvider timeProvider) {
        ISOChronology.checkNotNull(timeProvider, "TimeProvider must not be null");
        LocalTime localTime = timeProvider.toLocalTime();
        ISOChronology.checkNotNull(localTime, "TimeProvider implementation must not return null");
        return localTime;
    }

    public static LocalTime fromSecondOfDay(long l) {
        ISOChronology.secondOfDayRule().checkValue(l);
        int n = (int)(l / 3600L);
        int n2 = (int)((l -= (long)(n * 3600)) / 60L);
        return LocalTime.create(n, n2, (int)(l -= (long)(n2 * 60)), 0);
    }

    public static LocalTime fromSecondOfDay(long l, int n) {
        ISOChronology.secondOfDayRule().checkValue(l);
        ISOChronology.nanoOfSecondRule().checkValue(n);
        int n2 = (int)(l / 3600L);
        int n3 = (int)((l -= (long)(n2 * 3600)) / 60L);
        return LocalTime.create(n2, n3, (int)(l -= (long)(n3 * 60)), n);
    }

    public static LocalTime fromNanoOfDay(long l) {
        if (l < 0L) {
            throw new CalendricalException("Cannot create LocalTime from nanos of day as value " + l + " must not be negative");
        }
        if (l >= 86400000000000L) {
            throw new CalendricalException("Cannot create LocalTime from nanos of day as value " + l + " must be less than " + 86400000000000L);
        }
        int n = (int)(l / 3600000000000L);
        int n2 = (int)((l -= (long)n * 3600000000000L) / 60000000000L);
        int n3 = (int)((l -= (long)n2 * 60000000000L) / 1000000000L);
        return LocalTime.create(n, n2, n3, (int)(l -= (long)n3 * 1000000000L));
    }

    public static LocalTime parse(String string) {
        ISOChronology.checkNotNull(string, "Text to parse must not be null");
        return DateTimeFormatters.isoLocalTime().parse(string).mergeStrict().toLocalTime();
    }

    private static LocalTime create(int n, int n2, int n3, int n4) {
        if ((n2 | n3 | n4) == 0) {
            return HOURS[n];
        }
        return new LocalTime(n, n2, n3, n4);
    }

    private LocalTime(int n, int n2, int n3, int n4) {
        this.hour = (byte)n;
        this.minute = (byte)n2;
        this.second = (byte)n3;
        this.nano = n4;
    }

    private Object readResolve() {
        return LocalTime.create(this.hour, this.minute, this.second, this.nano);
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    public boolean isSupported(DateTimeFieldRule dateTimeFieldRule) {
        return dateTimeFieldRule != null && dateTimeFieldRule.isSupported(null, this);
    }

    public int get(DateTimeFieldRule dateTimeFieldRule) {
        ISOChronology.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        return dateTimeFieldRule.getValue(null, this);
    }

    public HourOfDay toHourOfDay() {
        return HourOfDay.hourOfDay(this.hour);
    }

    public MinuteOfHour toMinuteOfHour() {
        return MinuteOfHour.minuteOfHour(this.minute);
    }

    public SecondOfMinute toSecondOfMinute() {
        return SecondOfMinute.secondOfMinute(this.second);
    }

    public NanoOfSecond toNanoOfSecond() {
        return NanoOfSecond.nanoOfSecond(this.nano);
    }

    public int getHourOfDay() {
        return this.hour;
    }

    public int getMinuteOfHour() {
        return this.minute;
    }

    public int getSecondOfMinute() {
        return this.second;
    }

    public int getNanoOfSecond() {
        return this.nano;
    }

    public LocalTime with(TimeAdjuster timeAdjuster) {
        LocalTime localTime = timeAdjuster.adjustTime(this);
        if (localTime == null) {
            throw new NullPointerException("The implementation of TimeAdjuster must not return null");
        }
        return localTime;
    }

    public LocalTime withHourOfDay(int n) {
        if (n == this.hour) {
            return this;
        }
        return LocalTime.time(n, this.minute, this.second, this.nano);
    }

    public LocalTime withMinuteOfHour(int n) {
        if (n == this.minute) {
            return this;
        }
        return LocalTime.time(this.hour, n, this.second, this.nano);
    }

    public LocalTime withSecondOfMinute(int n) {
        if (n == this.second) {
            return this;
        }
        return LocalTime.time(this.hour, this.minute, n, this.nano);
    }

    public LocalTime withNanoOfSecond(int n) {
        if (n == this.nano) {
            return this;
        }
        return LocalTime.time(this.hour, this.minute, this.second, n);
    }

    public LocalTime plus(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        long l = (long)period.getHours() * 3600000000000L + (long)period.getMinutes() * 60000000000L + (long)period.getSeconds() * 1000000000L;
        return this.plusNanos(l).plusNanos(period.getNanos());
    }

    public LocalTime plusHours(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = (n % 24 + this.hour + 24) % 24;
        return this.withHourOfDay(n2);
    }

    public LocalTime plusMinutes(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = this.hour * 60 + this.minute;
        int n3 = (n % 1440 + n2 + 1440) % 1440;
        if (n2 == n3) {
            return this;
        }
        int n4 = n3 / 60;
        int n5 = n3 % 60;
        return LocalTime.time(n4, n5, this.second, this.nano);
    }

    public LocalTime plusSeconds(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = this.hour * 3600 + this.minute * 60 + this.second;
        int n3 = (n % 86400 + n2 + 86400) % 86400;
        if (n2 == n3) {
            return this;
        }
        int n4 = n3 / 3600;
        int n5 = n3 / 60 % 60;
        int n6 = n3 % 60;
        return LocalTime.time(n4, n5, n6, this.nano);
    }

    public LocalTime plusNanos(long l) {
        long l2;
        if (l == 0L) {
            return this;
        }
        long l3 = this.toNanoOfDay();
        if (l3 == (l2 = (l % 86400000000000L + l3 + 86400000000000L) % 86400000000000L)) {
            return this;
        }
        int n = (int)(l2 / 3600000000000L);
        int n2 = (int)(l2 / 60000000000L % 60L);
        int n3 = (int)(l2 / 1000000000L % 60L);
        int n4 = (int)(l2 % 1000000000L);
        return LocalTime.time(n, n2, n3, n4);
    }

    public LocalTime minus(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        long l = (long)period.getHours() * 3600000000000L + (long)period.getMinutes() * 60000000000L + (long)period.getSeconds() * 1000000000L;
        return this.minusNanos(l).minusNanos(period.getNanos());
    }

    public LocalTime minusHours(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = (-(n % 24) + this.hour + 24) % 24;
        return this.withHourOfDay(n2);
    }

    public LocalTime minusMinutes(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = this.hour * 60 + this.minute;
        int n3 = (-(n % 1440) + n2 + 1440) % 1440;
        if (n2 == n3) {
            return this;
        }
        int n4 = n3 / 60;
        int n5 = n3 % 60;
        return LocalTime.time(n4, n5, this.second, this.nano);
    }

    public LocalTime minusSeconds(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = this.hour * 3600 + this.minute * 60 + this.second;
        int n3 = (-(n % 86400) + n2 + 86400) % 86400;
        if (n2 == n3) {
            return this;
        }
        int n4 = n3 / 3600;
        int n5 = n3 / 60 % 60;
        int n6 = n3 % 60;
        return LocalTime.time(n4, n5, n6, this.nano);
    }

    public LocalTime minusNanos(long l) {
        long l2;
        if (l == 0L) {
            return this;
        }
        long l3 = this.toNanoOfDay();
        if (l3 == (l2 = (-(l % 86400000000000L) + l3 + 86400000000000L) % 86400000000000L)) {
            return this;
        }
        int n = (int)(l2 / 3600000000000L);
        int n2 = (int)(l2 / 60000000000L % 60L);
        int n3 = (int)(l2 / 1000000000L % 60L);
        int n4 = (int)(l2 % 1000000000L);
        return LocalTime.time(n, n2, n3, n4);
    }

    public boolean matches(TimeMatcher timeMatcher) {
        return timeMatcher.matchesTime(this);
    }

    @Override
    public LocalTime adjustTime(LocalTime localTime) {
        return this.matchesTime(localTime) ? localTime : this;
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        return this.hour == localTime.hour && this.minute == localTime.minute && this.second == localTime.second && this.nano == localTime.nano;
    }

    public OffsetTime atOffset(ZoneOffset zoneOffset) {
        return OffsetTime.time(this, zoneOffset);
    }

    public DateTimeFields toDateTimeFields() {
        HashMap<DateTimeFieldRule, Integer> hashMap = new HashMap<DateTimeFieldRule, Integer>();
        hashMap.put(ISOChronology.hourOfDayRule(), Integer.valueOf(this.hour));
        hashMap.put(ISOChronology.minuteOfHourRule(), Integer.valueOf(this.minute));
        hashMap.put(ISOChronology.secondOfMinuteRule(), Integer.valueOf(this.second));
        hashMap.put(ISOChronology.nanoOfSecondRule(), this.nano);
        return DateTimeFields.fields(hashMap);
    }

    @Override
    public LocalTime toLocalTime() {
        return this;
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(null, this, null, null);
    }

    public int toSecondOfDay() {
        int n = this.hour * 3600;
        n += this.minute * 60;
        return n += this.second;
    }

    public long toNanoOfDay() {
        long l = (long)this.hour * 3600000000000L;
        l += (long)this.minute * 60000000000L;
        l += (long)this.second * 1000000000L;
        return l += (long)this.nano;
    }

    @Override
    public int compareTo(LocalTime localTime) {
        int n = MathUtils.safeCompare(this.hour, localTime.hour);
        if (n == 0 && (n = MathUtils.safeCompare(this.minute, localTime.minute)) == 0 && (n = MathUtils.safeCompare(this.second, localTime.second)) == 0) {
            n = MathUtils.safeCompare(this.nano, localTime.nano);
        }
        return n;
    }

    public boolean isAfter(LocalTime localTime) {
        return this.compareTo(localTime) > 0;
    }

    public boolean isBefore(LocalTime localTime) {
        return this.compareTo(localTime) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            return this.matchesTime(localTime);
        }
        return false;
    }

    public int hashCode() {
        long l = this.toNanoOfDay();
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(18);
        byte by = this.hour;
        byte by2 = this.minute;
        byte by3 = this.second;
        int n = this.nano;
        stringBuilder.append(by < 10 ? "0" : "").append(by).append(by2 < 10 ? ":0" : ":").append(by2);
        if (by3 > 0 || n > 0) {
            stringBuilder.append(by3 < 10 ? ":0" : ":").append(by3);
            if (n > 0) {
                stringBuilder.append('.');
                if (n % 1000000 == 0) {
                    stringBuilder.append(Integer.toString(n / 1000000 + 1000).substring(1));
                } else if (n % 1000 == 0) {
                    stringBuilder.append(Integer.toString(n / 1000 + 1000000).substring(1));
                } else {
                    stringBuilder.append(Integer.toString(n + 1000000000).substring(1));
                }
            }
        }
        return stringBuilder.toString();
    }

    Overflow plusWithOverflow(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        long l = (long)period.getHours() * 3600000000000L + (long)period.getMinutes() * 60000000000L + (long)period.getSeconds() * 1000000000L;
        Overflow overflow = this.plusNanosWithOverflow(l);
        if (period.getNanos() == 0L) {
            return overflow;
        }
        Overflow overflow2 = overflow.getResultTime().plusNanosWithOverflow(period.getNanos());
        return new Overflow(overflow2.getResultTime(), overflow.getOverflowDays() + overflow2.getOverflowDays());
    }

    public Overflow plusWithOverflow(int n, int n2, int n3, int n4) {
        long l = (long)n * 3600000000000L + (long)n2 * 60000000000L + (long)n3 * 1000000000L + (long)n4;
        return this.plusNanosWithOverflow(l);
    }

    public Overflow plusNanosWithOverflow(long l) {
        if (l == 0L) {
            return new Overflow(this, 0);
        }
        long l2 = this.toNanoOfDay();
        long l3 = MathUtils.safeAdd(l2, l);
        int n = (int)(l3 / 86400000000000L);
        long l4 = l3 % 86400000000000L;
        if (l4 < 0L) {
            --n;
            l4 += 86400000000000L;
        }
        LocalTime localTime = l4 == l2 ? this : LocalTime.fromNanoOfDay(l4);
        return new Overflow(localTime, n);
    }

    Overflow minusWithOverflow(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        long l = (long)period.getHours() * 3600000000000L + (long)period.getMinutes() * 60000000000L + (long)period.getSeconds() * 1000000000L;
        Overflow overflow = this.minusNanosWithOverflow(l);
        if (period.getNanos() == 0L) {
            return overflow;
        }
        Overflow overflow2 = overflow.getResultTime().minusNanosWithOverflow(period.getNanos());
        return new Overflow(overflow2.getResultTime(), overflow.getOverflowDays() + overflow2.getOverflowDays());
    }

    public Overflow minusWithOverflow(int n, int n2, int n3, int n4) {
        long l = (long)n * 3600000000000L + (long)n2 * 60000000000L + (long)n3 * 1000000000L + (long)n4;
        return this.minusNanosWithOverflow(l);
    }

    public Overflow minusNanosWithOverflow(long l) {
        if (l == 0L) {
            return new Overflow(this, 0);
        }
        long l2 = this.toNanoOfDay();
        long l3 = MathUtils.safeSubtract(l2, l);
        int n = (int)(l3 / 86400000000000L);
        long l4 = l3 % 86400000000000L;
        if (l4 < 0L) {
            --n;
            l4 += 86400000000000L;
        }
        LocalTime localTime = l4 == l2 ? this : LocalTime.fromNanoOfDay(l4);
        return new Overflow(localTime, n);
    }

    public Overflow toOverflow(int n) {
        return new Overflow(this, n);
    }

    static {
        for (int i = 0; i < HOURS.length; ++i) {
            LocalTime.HOURS[i] = new LocalTime(i, 0, 0, 0);
        }
        MIDNIGHT = HOURS[0];
        MIDDAY = HOURS[12];
    }

    public static final class Overflow {
        private final LocalTime time;
        private final int days;

        private Overflow(LocalTime localTime, int n) {
            this.time = localTime;
            this.days = n;
        }

        public LocalTime getResultTime() {
            return this.time;
        }

        public int getOverflowDays() {
            return this.days;
        }

        public LocalDateTime toLocalDateTime(LocalDate localDate) {
            return LocalDateTime.dateTime(localDate.plusDays(this.getOverflowDays()), this.time);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Overflow) {
                Overflow overflow = (Overflow)object;
                return this.time.equals(overflow.time) && this.days == overflow.days;
            }
            return false;
        }

        public int hashCode() {
            return this.time.hashCode() + this.days;
        }

        public String toString() {
            return this.getResultTime().toString() + " + P" + this.days + "D";
        }
    }
}

