/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.TimeZone;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZoneResolvers;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.DayOfYear;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.Year;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.PeriodProvider;

public final class OffsetDate
implements CalendricalProvider,
DateProvider,
DateMatcher,
DateAdjuster,
Comparable<OffsetDate>,
Serializable {
    private static final long serialVersionUID = -3618963189L;
    private final LocalDate date;
    private final ZoneOffset offset;

    public static OffsetDate date(Year year, MonthOfYear monthOfYear, DayOfMonth dayOfMonth, ZoneOffset zoneOffset) {
        LocalDate localDate = LocalDate.date(year, monthOfYear, dayOfMonth);
        return new OffsetDate(localDate, zoneOffset);
    }

    public static OffsetDate date(int n, MonthOfYear monthOfYear, int n2, ZoneOffset zoneOffset) {
        LocalDate localDate = LocalDate.date(n, monthOfYear, n2);
        return new OffsetDate(localDate, zoneOffset);
    }

    public static OffsetDate date(int n, int n2, int n3, ZoneOffset zoneOffset) {
        LocalDate localDate = LocalDate.date(n, n2, n3);
        return new OffsetDate(localDate, zoneOffset);
    }

    public static OffsetDate date(DateProvider dateProvider, ZoneOffset zoneOffset) {
        LocalDate localDate = LocalDate.date(dateProvider);
        return new OffsetDate(localDate, zoneOffset);
    }

    public static OffsetDate fromInstant(InstantProvider instantProvider, ZoneOffset zoneOffset) {
        Instant instant = Instant.instant(instantProvider);
        ISOChronology.checkNotNull(zoneOffset, "ZoneOffset must not be null");
        long l = instant.getEpochSeconds() + (long)zoneOffset.getAmountSeconds();
        long l2 = l / 86400L + 719528L;
        long l3 = l % 86400L;
        if (l3 < 0L) {
            --l2;
        }
        LocalDate localDate = LocalDate.fromYearZeroDays(l2);
        return new OffsetDate(localDate, zoneOffset);
    }

    public static OffsetDate parse(String string) {
        ISOChronology.checkNotNull(string, "Text to parse must not be null");
        return DateTimeFormatters.isoOffsetDate().parse(string).mergeStrict().toOffsetDate();
    }

    private OffsetDate(LocalDate localDate, ZoneOffset zoneOffset) {
        if (localDate == null) {
            throw new NullPointerException("The date must not be null");
        }
        if (zoneOffset == null) {
            throw new NullPointerException("The zone offset must not be null");
        }
        this.date = localDate;
        this.offset = zoneOffset;
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    public boolean isSupported(DateTimeFieldRule dateTimeFieldRule) {
        return this.date.isSupported(dateTimeFieldRule);
    }

    public int get(DateTimeFieldRule dateTimeFieldRule) {
        return this.date.get(dateTimeFieldRule);
    }

    public LocalDate getDate() {
        return this.date;
    }

    public OffsetDate withDate(DateProvider dateProvider) {
        LocalDate localDate = LocalDate.date(dateProvider);
        return localDate.equals(this.date) ? this : new OffsetDate(localDate, this.offset);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetDate withOffset(ZoneOffset zoneOffset) {
        return zoneOffset != null && zoneOffset.equals(this.offset) ? this : new OffsetDate(this.date, zoneOffset);
    }

    public Year toYear() {
        return this.date.toYear();
    }

    public MonthOfYear toMonthOfYear() {
        return this.date.toMonthOfYear();
    }

    public DayOfMonth toDayOfMonth() {
        return this.date.toDayOfMonth();
    }

    public DayOfYear toDayOfYear() {
        return this.date.toDayOfYear();
    }

    public DayOfWeek toDayOfWeek() {
        return this.date.toDayOfWeek();
    }

    public int getYear() {
        return this.date.getYear();
    }

    public MonthOfYear getMonthOfYear() {
        return this.date.getMonthOfYear();
    }

    public int getDayOfMonth() {
        return this.date.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.date.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.date.getDayOfWeek();
    }

    public OffsetDate with(DateAdjuster dateAdjuster) {
        LocalDate localDate = this.date.with(dateAdjuster);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate withYear(int n) {
        LocalDate localDate = this.date.withYear(n);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate withYear(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.withYear(n, dateResolver);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate withMonthOfYear(int n) {
        LocalDate localDate = this.date.withMonthOfYear(n);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate withMonthOfYear(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.withMonthOfYear(n, dateResolver);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate withDayOfMonth(int n) {
        LocalDate localDate = this.date.withDayOfMonth(n);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate plus(PeriodProvider periodProvider) {
        LocalDate localDate = this.date.plus(periodProvider);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate plusYears(int n) {
        LocalDate localDate = this.date.plusYears(n);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate plusYears(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.plusYears(n, dateResolver);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate plusMonths(int n) {
        LocalDate localDate = this.date.plusMonths(n);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate plusMonths(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.plusMonths(n, dateResolver);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate plusWeeks(int n) {
        LocalDate localDate = this.date.plusWeeks(n);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate plusDays(long l) {
        LocalDate localDate = this.date.plusDays(l);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate minus(PeriodProvider periodProvider) {
        LocalDate localDate = this.date.minus(periodProvider);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate minusYears(int n) {
        LocalDate localDate = this.date.minusYears(n);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate minusYears(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.minusYears(n, dateResolver);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate minusMonths(int n) {
        LocalDate localDate = this.date.minusMonths(n);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate minusMonths(int n, DateResolver dateResolver) {
        LocalDate localDate = this.date.minusMonths(n, dateResolver);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate minusWeeks(int n) {
        LocalDate localDate = this.date.minusWeeks(n);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public OffsetDate minusDays(long l) {
        LocalDate localDate = this.date.minusDays(l);
        return localDate == this.date ? this : new OffsetDate(localDate, this.offset);
    }

    public boolean matches(DateMatcher dateMatcher) {
        return this.date.matches(dateMatcher);
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return this.date.matchesDate(localDate);
    }

    @Override
    public LocalDate adjustDate(LocalDate localDate) {
        return this.matchesDate(localDate) ? localDate : this.date;
    }

    public OffsetDateTime atTime(LocalTime localTime) {
        return OffsetDateTime.dateTime(this, localTime, this.getOffset());
    }

    public OffsetDateTime atMidnight() {
        return OffsetDateTime.dateTime(this, LocalTime.MIDNIGHT, this.getOffset());
    }

    public ZonedDateTime atStartOfDayInZone(TimeZone timeZone) {
        return ZonedDateTime.dateTime(this, LocalTime.MIDNIGHT, timeZone, ZoneResolvers.postGapPreOverlap());
    }

    @Override
    public LocalDate toLocalDate() {
        return this.date;
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(this.date, null, this.offset, null);
    }

    @Override
    public int compareTo(OffsetDate offsetDate) {
        LocalDateTime localDateTime;
        if (this.offset.equals(offsetDate.offset)) {
            return this.date.compareTo(offsetDate.date);
        }
        LocalDateTime localDateTime2 = LocalDateTime.dateMidnight(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth());
        LocalDateTime localDateTime3 = LocalDateTime.dateMidnight(offsetDate.getYear(), offsetDate.getMonthOfYear(), offsetDate.getDayOfMonth());
        LocalDateTime localDateTime4 = localDateTime2.plusSeconds(-this.offset.getAmountSeconds());
        int n = localDateTime4.compareTo(localDateTime = localDateTime3.plusSeconds(-offsetDate.offset.getAmountSeconds()));
        if (n == 0) {
            n = this.date.compareTo(offsetDate.date);
        }
        return n;
    }

    public boolean isAfter(OffsetDate offsetDate) {
        return this.compareTo(offsetDate) > 0;
    }

    public boolean isBefore(OffsetDate offsetDate) {
        return this.compareTo(offsetDate) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OffsetDate) {
            OffsetDate offsetDate = (OffsetDate)object;
            return this.date.equals(offsetDate.date) && this.offset.equals(offsetDate.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.date.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.date.toString() + this.offset.toString();
    }
}

