/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateResolvers;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.Year;
import javax.time.calendar.format.DateTimeFormatter;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;

public final class YearMonth
implements CalendricalProvider,
Comparable<YearMonth>,
Serializable,
DateAdjuster,
DateMatcher {
    private static final long serialVersionUID = 1507289123L;
    private static final DateTimeFormatter PARSER = new DateTimeFormatterBuilder().appendValue(ISOChronology.yearRule(), 4, 10, DateTimeFormatterBuilder.SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ISOChronology.monthOfYearRule(), 2).toFormatter();
    private final int year;
    private final MonthOfYear month;

    public static YearMonth yearMonth(Year year, MonthOfYear monthOfYear) {
        ISOChronology.checkNotNull(year, "Year must not be null");
        ISOChronology.checkNotNull(monthOfYear, "MonthOfYear must not be null");
        return YearMonth.yearMonth(year.getValue(), monthOfYear);
    }

    public static YearMonth yearMonth(int n, MonthOfYear monthOfYear) {
        ISOChronology.yearRule().checkValue(n);
        ISOChronology.checkNotNull(monthOfYear, "MonthOfYear must not be null");
        return new YearMonth(n, monthOfYear);
    }

    public static YearMonth yearMonth(int n, int n2) {
        return YearMonth.yearMonth(n, MonthOfYear.monthOfYear(n2));
    }

    public static YearMonth yearMonth(DateProvider dateProvider) {
        LocalDate localDate = LocalDate.date(dateProvider);
        return new YearMonth(localDate.getYear(), localDate.getMonthOfYear());
    }

    public static YearMonth yearMonth(CalendricalProvider calendricalProvider) {
        Calendrical calendrical = calendricalProvider.toCalendrical();
        int n = calendrical.deriveValue(ISOChronology.yearRule());
        int n2 = calendrical.deriveValue(ISOChronology.monthOfYearRule());
        return YearMonth.yearMonth(n, n2);
    }

    public static YearMonth parse(String string) {
        ISOChronology.checkNotNull(string, "Text to parse must not be null");
        return YearMonth.yearMonth(PARSER.parse(string));
    }

    private YearMonth(int n, MonthOfYear monthOfYear) {
        this.year = n;
        this.month = monthOfYear;
    }

    private YearMonth withYearMonth(int n, MonthOfYear monthOfYear) {
        if (this.year == n && this.month == monthOfYear) {
            return this;
        }
        return new YearMonth(n, monthOfYear);
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    public Year toYear() {
        return Year.isoYear(this.year);
    }

    public MonthOfYear toMonthOfYear() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public MonthOfYear getMonthOfYear() {
        return this.month;
    }

    public YearMonth with(Year year) {
        ISOChronology.checkNotNull(year, "Year must not be null");
        return this.withYear(year.getValue());
    }

    public YearMonth with(MonthOfYear monthOfYear) {
        ISOChronology.checkNotNull(monthOfYear, "MonthOfYear must not be null");
        return this.withYearMonth(this.year, monthOfYear);
    }

    public YearMonth withYear(int n) {
        ISOChronology.yearRule().checkValue(n);
        return this.withYearMonth(n, this.month);
    }

    public YearMonth withMonthOfYear(int n) {
        return this.with(MonthOfYear.monthOfYear(n));
    }

    public YearMonth plus(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        return this.plusYears(period.getYears()).plusMonths(period.getMonths());
    }

    public YearMonth plusYears(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = ISOChronology.addYears(this.year, n);
        return this.withYearMonth(n2, this.month);
    }

    public YearMonth plusMonths(int n) {
        if (n == 0) {
            return this;
        }
        long l = this.month.getValue() - 1;
        int n2 = (int)((l += (long)n) / 12L);
        if ((l %= 12L) < 0L) {
            l += 12L;
            --n2;
        }
        int n3 = ISOChronology.addYears(this.year, n2);
        MonthOfYear monthOfYear = MonthOfYear.monthOfYear((int)(++l));
        return this.withYearMonth(n3, monthOfYear);
    }

    public YearMonth minus(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        return this.minusYears(period.getYears()).minusMonths(period.getMonths());
    }

    public YearMonth minusYears(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = ISOChronology.subtractYears(this.year, n);
        return this.withYearMonth(n2, this.month);
    }

    public YearMonth minusMonths(int n) {
        if (n == 0) {
            return this;
        }
        long l = this.month.getValue() - 1;
        int n2 = (int)((l -= (long)n) / 12L);
        if ((l %= 12L) < 0L) {
            l += 12L;
            --n2;
        }
        int n3 = ISOChronology.subtractYears(this.year, -n2);
        MonthOfYear monthOfYear = MonthOfYear.monthOfYear((int)(++l));
        return this.withYearMonth(n3, monthOfYear);
    }

    public YearMonth rollMonthOfYear(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = n % 12 + (this.month.getValue() - 1);
        n2 = (n2 + 12) % 12;
        return this.withMonthOfYear(++n2);
    }

    @Override
    public LocalDate adjustDate(LocalDate localDate) {
        return this.adjustDate(localDate, DateResolvers.previousValid());
    }

    public LocalDate adjustDate(LocalDate localDate, DateResolver dateResolver) {
        ISOChronology.checkNotNull(localDate, "LocalDate must not be null");
        ISOChronology.checkNotNull(dateResolver, "DateResolver must not be null");
        if (this.year == localDate.getYear() && this.month == localDate.getMonthOfYear()) {
            return localDate;
        }
        LocalDate localDate2 = dateResolver.resolveDate(this.toYear(), this.month, localDate.toDayOfMonth());
        ISOChronology.checkNotNull(localDate2, "The implementation of DateResolver must not return null");
        return localDate2;
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return this.year == localDate.getYear() && this.month == localDate.getMonthOfYear();
    }

    public LocalDate atDay(DayOfMonth dayOfMonth) {
        return this.atDay(dayOfMonth.getValue());
    }

    public LocalDate atDay(int n) {
        return LocalDate.date(this.year, this.month, n);
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(ISOChronology.yearRule(), this.year, ISOChronology.monthOfYearRule(), this.month.getValue());
    }

    @Override
    public int compareTo(YearMonth yearMonth) {
        int n = MathUtils.safeCompare(this.year, yearMonth.year);
        if (n == 0) {
            n = this.month.compareTo(yearMonth.month);
        }
        return n;
    }

    public boolean isAfter(YearMonth yearMonth) {
        return this.compareTo(yearMonth) > 0;
    }

    public boolean isBefore(YearMonth yearMonth) {
        return this.compareTo(yearMonth) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)object;
            return this.year == yearMonth.year && this.month == yearMonth.month;
        }
        return false;
    }

    public int hashCode() {
        return this.year ^ this.month.getValue() << 27;
    }

    public String toString() {
        int n = this.year;
        int n2 = this.month.getValue();
        int n3 = Math.abs(n);
        StringBuilder stringBuilder = new StringBuilder(9);
        if (n3 < 1000) {
            if (n < 0) {
                stringBuilder.append(n - 10000).deleteCharAt(1);
            } else {
                stringBuilder.append(n + 10000).deleteCharAt(0);
            }
        } else {
            stringBuilder.append(n);
        }
        return stringBuilder.append(n2 < 10 ? "-0" : "-").append(n2).toString();
    }
}

