/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.time.calendar.TimeZone;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;

public final class ZoneOffset
implements Comparable<ZoneOffset>,
Serializable {
    private static final ReadWriteLock CACHE_LOCK = new ReentrantReadWriteLock();
    private static final Map<Integer, ZoneOffset> SECONDS_CACHE = new HashMap<Integer, ZoneOffset>();
    private static final Map<String, ZoneOffset> ID_CACHE = new HashMap<String, ZoneOffset>();
    public static final ZoneOffset UTC = ZoneOffset.zoneOffset(0, 0, 0);
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final long serialVersionUID = 3552876348982168937L;
    private final String id;
    private final transient int amountSeconds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZoneOffset zoneOffset(String string) {
        int n;
        int n2;
        int n3;
        if (string == null) {
            throw new NullPointerException("The offset ID must not be null");
        }
        CACHE_LOCK.readLock().lock();
        try {
            ZoneOffset zoneOffset = ID_CACHE.get(string);
            if (zoneOffset != null) {
                ZoneOffset zoneOffset2 = zoneOffset;
                return zoneOffset2;
            }
        }
        finally {
            CACHE_LOCK.readLock().unlock();
        }
        int n4 = string.length();
        switch (n4) {
            case 3: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = 0;
                n = 0;
                break;
            }
            case 5: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 3, false);
                n = 0;
                break;
            }
            case 6: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 4, true);
                n = 0;
                break;
            }
            case 7: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 3, false);
                n = ZoneOffset.parseNumber(string, 5, false);
                break;
            }
            case 9: {
                n3 = ZoneOffset.parseNumber(string, 1, false);
                n2 = ZoneOffset.parseNumber(string, 4, true);
                n = ZoneOffset.parseNumber(string, 7, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Zone offset id '" + string + "' is invalid");
            }
        }
        char c = string.charAt(0);
        if (c != '+' && c != '-') {
            throw new IllegalArgumentException("Zone offset id '" + string + "' is invalid: Plus/minus not found when expected");
        }
        if (c == '-') {
            return ZoneOffset.zoneOffset(-n3, -n2, -n);
        }
        return ZoneOffset.zoneOffset(n3, n2, n);
    }

    private static int parseNumber(String string, int n, boolean bl) {
        if (bl && string.charAt(n - 1) != ':') {
            throw new IllegalArgumentException("Zone offset id '" + string + "' is invalid: Colon not found when expected");
        }
        char c = string.charAt(n);
        char c2 = string.charAt(n + 1);
        if (c < '0' || c > '9' || c2 < '0' || c2 > '9') {
            throw new IllegalArgumentException("Zone offset id '" + string + "' is invalid: Non numeric characters found");
        }
        return (c - 48) * 10 + (c2 - 48);
    }

    public static ZoneOffset zoneOffset(int n) {
        return ZoneOffset.zoneOffset(n, 0, 0);
    }

    public static ZoneOffset zoneOffset(int n, int n2) {
        return ZoneOffset.zoneOffset(n, n2, 0);
    }

    public static ZoneOffset zoneOffset(int n, int n2, int n3) {
        ZoneOffset.validate(n, n2, n3);
        int n4 = ZoneOffset.totalSeconds(n, n2, n3);
        return ZoneOffset.forTotalSeconds(n4);
    }

    private static void validate(int n, int n2, int n3) {
        if (n < -18 || n > 18) {
            throw new IllegalArgumentException("Zone offset hours not in valid range: value " + n + " is not in the range -18 to 18");
        }
        if (n > 0) {
            if (n2 < 0 || n3 < 0) {
                throw new IllegalArgumentException("Zone offset minutes and seconds must be positive because hours is positive");
            }
        } else if (n < 0) {
            if (n2 > 0 || n3 > 0) {
                throw new IllegalArgumentException("Zone offset minutes and seconds must be negative because hours is negative");
            }
        } else if (n2 > 0 && n3 < 0 || n2 < 0 && n3 > 0) {
            throw new IllegalArgumentException("Zone offset minutes and seconds must have the same sign");
        }
        if (Math.abs(n2) > 59) {
            throw new IllegalArgumentException("Zone offset minutes not in valid range: value " + Math.abs(n2) + " is not in the range 0 to 59");
        }
        if (Math.abs(n3) > 59) {
            throw new IllegalArgumentException("Zone offset seconds not in valid range: value " + Math.abs(n3) + " is not in the range 0 to 59");
        }
        if (Math.abs(n) == 18 && (Math.abs(n2) > 0 || Math.abs(n3) > 0)) {
            throw new IllegalArgumentException("Zone offset not in valid range: -18:00 to +18:00");
        }
    }

    private static int totalSeconds(int n, int n2, int n3) {
        return n * 3600 + n2 * 60 + n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZoneOffset forTotalSeconds(int n) {
        if (Math.abs(n) > 64800) {
            throw new IllegalArgumentException("Zone offset not in valid range: -18:00 to +18:00");
        }
        if (n % 900 == 0) {
            ZoneOffset zoneOffset;
            Integer n2 = n;
            CACHE_LOCK.readLock().lock();
            try {
                zoneOffset = SECONDS_CACHE.get(n2);
                if (zoneOffset != null) {
                    ZoneOffset zoneOffset2 = zoneOffset;
                    return zoneOffset2;
                }
            }
            finally {
                CACHE_LOCK.readLock().unlock();
            }
            CACHE_LOCK.writeLock().lock();
            try {
                zoneOffset = SECONDS_CACHE.get(n2);
                if (zoneOffset == null) {
                    zoneOffset = new ZoneOffset(n);
                    SECONDS_CACHE.put(n2, zoneOffset);
                    ID_CACHE.put(zoneOffset.getID(), zoneOffset);
                }
                ZoneOffset zoneOffset3 = zoneOffset;
                return zoneOffset3;
            }
            finally {
                CACHE_LOCK.writeLock().unlock();
            }
        }
        return new ZoneOffset(n);
    }

    private ZoneOffset(int n) {
        this.amountSeconds = n;
        if (this.amountSeconds == 0) {
            this.id = "Z";
        } else {
            int n2 = Math.abs(this.amountSeconds);
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = n2 / 3600;
            int n4 = n2 / 60 % 60;
            stringBuilder.append(this.amountSeconds < 0 ? "-" : "+").append(n3 < 10 ? "0" : "").append(n3).append(n4 < 10 ? ":0" : ":").append(n4);
            int n5 = n2 % 60;
            if (n5 != 0) {
                stringBuilder.append(n5 < 10 ? ":0" : ":").append(n5);
            }
            this.id = stringBuilder.toString();
        }
    }

    private Object readResolve() {
        return ZoneOffset.zoneOffset(this.id);
    }

    public int getAmountSeconds() {
        return this.amountSeconds;
    }

    public String getID() {
        return this.id;
    }

    public int getHoursField() {
        return this.amountSeconds / 3600;
    }

    public int getMinutesField() {
        return this.amountSeconds / 60 % 60;
    }

    public int getSecondsField() {
        return this.amountSeconds % 60;
    }

    public ZoneOffset plus(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        period = Period.hoursMinutesSeconds(period.getHours(), period.getMinutes(), period.getSeconds());
        Period period2 = this.toPeriod();
        Period period3 = period2.plus(period).normalized();
        return ZoneOffset.zoneOffset(period3.getHours(), period3.getMinutes(), period3.getSeconds());
    }

    public Period toPeriod() {
        return Period.hoursMinutesSeconds(this.getHoursField(), this.getMinutesField(), this.getSecondsField());
    }

    public TimeZone toTimeZone() {
        return TimeZone.timeZone(this);
    }

    @Override
    public int compareTo(ZoneOffset zoneOffset) {
        return zoneOffset.amountSeconds - this.amountSeconds;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZoneOffset) {
            return this.amountSeconds == ((ZoneOffset)object).amountSeconds;
        }
        return false;
    }

    public int hashCode() {
        return this.amountSeconds;
    }

    public String toString() {
        return this.id;
    }
}

