/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import javax.time.CalendricalException;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.TimeZone;
import javax.time.calendar.ZonedDateTime;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneRules;

public abstract class ZoneResolver {
    protected ZoneResolver() {
    }

    public final OffsetDateTime resolve(TimeZone timeZone, LocalDateTime localDateTime, ZonedDateTime zonedDateTime) {
        OffsetDateTime offsetDateTime;
        ZoneRules zoneRules = zonedDateTime != null ? zonedDateTime.getApplicableRules() : timeZone.getRules();
        ZoneRules.OffsetInfo offsetInfo = zoneRules.getOffsetInfo(localDateTime);
        if (!offsetInfo.isDiscontinuity()) {
            return OffsetDateTime.dateTime(localDateTime, offsetInfo.getOffset());
        }
        ZoneOffsetTransition zoneOffsetTransition = offsetInfo.getDiscontinuity();
        OffsetDateTime offsetDateTime2 = zoneOffsetTransition.isGap() ? this.handleGap(timeZone, zoneRules, zoneOffsetTransition, localDateTime, zonedDateTime != null ? zonedDateTime.toOffsetDateTime() : null) : (offsetDateTime = this.handleOverlap(timeZone, zoneRules, zoneOffsetTransition, localDateTime, zonedDateTime != null ? zonedDateTime.toOffsetDateTime() : null));
        if (offsetDateTime == null) {
            throw new CalendricalException("ZoneResolver implementation must not return null: " + this.getClass().getName());
        }
        if (!timeZone.isValidFor(offsetDateTime)) {
            throw new CalendricalException("ZoneResolver implementation must return a valid date-time and offset for the zone: " + this.getClass().getName());
        }
        return offsetDateTime;
    }

    protected abstract OffsetDateTime handleGap(TimeZone var1, ZoneRules var2, ZoneOffsetTransition var3, LocalDateTime var4, OffsetDateTime var5);

    protected abstract OffsetDateTime handleOverlap(TimeZone var1, ZoneRules var2, ZoneOffsetTransition var3, LocalDateTime var4, OffsetDateTime var5);
}

