/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.util.Locale;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeFormatterBuilder;

public enum AmPmOfDay implements CalendricalProvider,
TimeAdjuster,
TimeMatcher
{
    AM(0),
    PM(1);

    private final int amPmOfDay;

    public static DateTimeFieldRule rule() {
        return ISOChronology.amPmOfDayRule();
    }

    public static AmPmOfDay amPmOfDay(int n) {
        switch (n) {
            case 0: {
                return AM;
            }
            case 1: {
                return PM;
            }
        }
        throw new IllegalCalendarFieldValueException(AmPmOfDay.rule(), n, 0, 1);
    }

    public static AmPmOfDay amPmOfDay(TimeProvider timeProvider) {
        return LocalTime.time(timeProvider).toHourOfDay().getAmPm();
    }

    private AmPmOfDay(int n2) {
        this.amPmOfDay = n2;
    }

    public int getValue() {
        return this.amPmOfDay;
    }

    public String getShortText(Locale locale) {
        DateTimeFormatSymbols dateTimeFormatSymbols = DateTimeFormatSymbols.getInstance(locale);
        String string = dateTimeFormatSymbols.getFieldValueText(AmPmOfDay.rule(), DateTimeFormatterBuilder.TextStyle.SHORT, this.amPmOfDay);
        return string == null ? Integer.toString(this.amPmOfDay) : string;
    }

    public String getText(Locale locale) {
        DateTimeFormatSymbols dateTimeFormatSymbols = DateTimeFormatSymbols.getInstance(locale);
        String string = dateTimeFormatSymbols.getFieldValueText(AmPmOfDay.rule(), DateTimeFormatterBuilder.TextStyle.FULL, this.amPmOfDay);
        return string == null ? Integer.toString(this.amPmOfDay) : string;
    }

    public boolean isAm() {
        return this == AM;
    }

    public boolean isPm() {
        return this == PM;
    }

    @Override
    public LocalTime adjustTime(LocalTime localTime) {
        int n = this.getValue() * 12 + localTime.toHourOfDay().getHourOfAmPm();
        return localTime.withHourOfDay(n);
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        return this == localTime.toHourOfDay().getAmPm();
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(AmPmOfDay.rule(), this.getValue());
    }

    public String toString() {
        return "AmPmOfDay=" + this.name();
    }
}

