/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateResolvers;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.Year;

public final class DayOfMonth
implements CalendricalProvider,
Comparable<DayOfMonth>,
DateAdjuster,
DateMatcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceArray<DayOfMonth> CACHE = new AtomicReferenceArray(31);
    private final int dayOfMonth;

    public static DateTimeFieldRule rule() {
        return ISOChronology.dayOfMonthRule();
    }

    public static DayOfMonth dayOfMonth(int n) {
        try {
            DayOfMonth dayOfMonth = CACHE.get(--n);
            if (dayOfMonth == null) {
                DayOfMonth dayOfMonth2 = new DayOfMonth(n + 1);
                CACHE.compareAndSet(n, null, dayOfMonth2);
                dayOfMonth = CACHE.get(n);
            }
            return dayOfMonth;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalCalendarFieldValueException(DayOfMonth.rule(), ++n, 1, 31);
        }
    }

    public static DayOfMonth dayOfMonth(DateProvider dateProvider) {
        return LocalDate.date(dateProvider).toDayOfMonth();
    }

    private DayOfMonth(int n) {
        this.dayOfMonth = n;
    }

    private Object readResolve() {
        return DayOfMonth.dayOfMonth(this.dayOfMonth);
    }

    public int getValue() {
        return this.dayOfMonth;
    }

    @Override
    public LocalDate adjustDate(LocalDate localDate) {
        return this.adjustDate(localDate, DateResolvers.strict());
    }

    public LocalDate adjustDate(LocalDate localDate, DateResolver dateResolver) {
        return localDate.withDayOfMonth(this.dayOfMonth, dateResolver);
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return localDate.getDayOfMonth() == this.dayOfMonth;
    }

    public boolean isValid(Year year, MonthOfYear monthOfYear) {
        if (year == null) {
            throw new NullPointerException("Year must not be null");
        }
        if (monthOfYear == null) {
            throw new NullPointerException("MonthOfYear must not be null");
        }
        return this.dayOfMonth <= 28 || this.dayOfMonth <= monthOfYear.lengthInDays(year);
    }

    public boolean isValid(int n, MonthOfYear monthOfYear) {
        ISOChronology.yearRule().checkValue(n);
        if (monthOfYear == null) {
            throw new NullPointerException("MonthOfYear must not be null");
        }
        return this.dayOfMonth <= 28 || this.dayOfMonth <= monthOfYear.lengthInDays(n);
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(DayOfMonth.rule(), this.getValue());
    }

    @Override
    public int compareTo(DayOfMonth dayOfMonth) {
        return MathUtils.safeCompare(this.dayOfMonth, dayOfMonth.dayOfMonth);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.dayOfMonth;
    }

    public String toString() {
        return "DayOfMonth=" + this.getValue();
    }
}

