/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.TimeProvider;

public final class NanoOfSecond
implements CalendricalProvider,
Comparable<NanoOfSecond>,
Serializable,
TimeAdjuster,
TimeMatcher {
    public static final NanoOfSecond ZERO = new NanoOfSecond(0);
    private static final long serialVersionUID = 1L;
    private final int nanoOfSecond;

    public static DateTimeFieldRule rule() {
        return ISOChronology.nanoOfSecondRule();
    }

    public static NanoOfSecond nanoOfSecond(int n) {
        NanoOfSecond.rule().checkValue(n);
        if (n == 0) {
            return ZERO;
        }
        return new NanoOfSecond(n);
    }

    public static NanoOfSecond nanoOfSecond(TimeProvider timeProvider) {
        return LocalTime.time(timeProvider).toNanoOfSecond();
    }

    private NanoOfSecond(int n) {
        this.nanoOfSecond = n;
    }

    public int getValue() {
        return this.nanoOfSecond;
    }

    public BigDecimal getFractionalValue() {
        return NanoOfSecond.rule().convertValueToFraction(this.nanoOfSecond);
    }

    @Override
    public LocalTime adjustTime(LocalTime localTime) {
        return localTime.withNanoOfSecond(this.nanoOfSecond);
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        return this.nanoOfSecond == localTime.getNanoOfSecond();
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(NanoOfSecond.rule(), this.getValue());
    }

    @Override
    public int compareTo(NanoOfSecond nanoOfSecond) {
        int n = this.nanoOfSecond;
        int n2 = nanoOfSecond.nanoOfSecond;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NanoOfSecond) {
            return this.nanoOfSecond == ((NanoOfSecond)object).nanoOfSecond;
        }
        return false;
    }

    public int hashCode() {
        return this.nanoOfSecond;
    }

    public String toString() {
        return "NanoOfSecond=" + this.getValue();
    }
}

