/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.util.ArrayList;
import java.util.Locale;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.TimeZone;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.FormatUtil;

public final class DateTimeParseContext
implements CalendricalProvider {
    private final DateTimeFormatSymbols symbols;
    private final ArrayList<Calendrical> calendricals = new ArrayList();

    public DateTimeParseContext(DateTimeFormatSymbols dateTimeFormatSymbols) {
        FormatUtil.checkNotNull(dateTimeFormatSymbols, "symbols");
        this.symbols = dateTimeFormatSymbols;
        this.calendricals.add(new Calendrical());
    }

    public Locale getLocale() {
        return this.symbols.getLocale();
    }

    public DateTimeFormatSymbols getSymbols() {
        return this.symbols;
    }

    private Calendrical currentCalendrical() {
        return this.calendricals.get(this.calendricals.size() - 1);
    }

    public int deriveFieldValue(DateTimeFieldRule dateTimeFieldRule) {
        return this.currentCalendrical().deriveValue(dateTimeFieldRule);
    }

    public int getFieldValue(DateTimeFieldRule dateTimeFieldRule) {
        return this.currentCalendrical().getFieldMap().get(dateTimeFieldRule);
    }

    public void setFieldValue(DateTimeFieldRule dateTimeFieldRule, int n) {
        this.currentCalendrical().getFieldMap().put(dateTimeFieldRule, n);
    }

    public ZoneOffset getOffset() {
        return this.currentCalendrical().getOffset();
    }

    public void setOffset(ZoneOffset zoneOffset) {
        this.currentCalendrical().setOffset(zoneOffset);
    }

    public TimeZone getZone() {
        return this.currentCalendrical().getZone();
    }

    public void setZone(TimeZone timeZone) {
        this.currentCalendrical().setZone(timeZone);
    }

    public void startOptional() {
        this.calendricals.add(this.currentCalendrical().clone());
    }

    public void endOptional(boolean bl) {
        if (bl) {
            this.calendricals.remove(this.calendricals.size() - 2);
        } else {
            this.calendricals.remove(this.calendricals.size() - 1);
        }
    }

    Calendrical asCalendrical() {
        return this.currentCalendrical();
    }

    @Override
    public Calendrical toCalendrical() {
        return this.currentCalendrical().clone();
    }

    public String toString() {
        return this.currentCalendrical().toString();
    }
}

