/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;
import javax.time.calendar.format.FormatUtil;

class FractionPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final DateTimeFieldRule fieldRule;
    private final int minWidth;
    private final int maxWidth;

    FractionPrinterParser(DateTimeFieldRule dateTimeFieldRule, int n, int n2) {
        this.fieldRule = dateTimeFieldRule;
        this.minWidth = n;
        this.maxWidth = n2;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols dateTimeFormatSymbols) throws IOException {
        int n = calendrical.deriveValue(this.fieldRule);
        BigDecimal bigDecimal = this.fieldRule.convertValueToFraction(n);
        if (bigDecimal.scale() == 0) {
            if (this.minWidth > 0) {
                appendable.append(dateTimeFormatSymbols.getDecimalPointChar());
                for (int i = 0; i < this.minWidth; ++i) {
                    appendable.append(dateTimeFormatSymbols.getZeroChar());
                }
            }
        } else {
            int n2 = Math.min(Math.max(bigDecimal.scale(), this.minWidth), this.maxWidth);
            bigDecimal = bigDecimal.setScale(n2, RoundingMode.FLOOR);
            String string = bigDecimal.toPlainString().substring(2);
            string = FormatUtil.convertToI18N(string, dateTimeFormatSymbols);
            appendable.append(dateTimeFormatSymbols.getDecimalPointChar());
            appendable.append(string);
        }
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return calendrical.isDerivable(this.fieldRule);
    }

    @Override
    public int parse(DateTimeParseContext dateTimeParseContext, String string, int n) {
        int n2;
        int n3;
        int n4 = string.length();
        if (n == n4) {
            if (this.minWidth > 0) {
                return ~n;
            }
            return n;
        }
        char c = string.charAt(n);
        if (c != dateTimeParseContext.getSymbols().getDecimalPointChar()) {
            if (this.minWidth > 0) {
                return ~n;
            }
            return n;
        }
        if ((n3 = ++n + this.minWidth) > n4) {
            return ~n;
        }
        int n5 = Math.min(n + this.maxWidth, n4);
        int n6 = 0;
        int n7 = n;
        while (n7 < n5) {
            char c2 = string.charAt(n7++);
            n2 = dateTimeParseContext.getSymbols().convertToDigit(c2);
            if (n2 < 0) {
                if (n7 < n3) {
                    return ~n;
                }
                --n7;
                break;
            }
            n6 = n6 * 10 + n2;
        }
        BigDecimal bigDecimal = new BigDecimal(n6).movePointLeft(n7 - n);
        n2 = this.fieldRule.convertFractionToValue(bigDecimal);
        dateTimeParseContext.setFieldValue(this.fieldRule, n2);
        return n7;
    }

    public String toString() {
        return "Fraction(" + this.fieldRule.getID() + "," + this.minWidth + "," + this.maxWidth + ")";
    }
}

