/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;
import javax.time.calendar.format.FormatUtil;
import javax.time.calendar.format.NumberPrinterParser;

class TextPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final DateTimeFieldRule fieldRule;
    private final DateTimeFormatterBuilder.TextStyle textStyle;

    TextPrinterParser(DateTimeFieldRule dateTimeFieldRule, DateTimeFormatterBuilder.TextStyle textStyle) {
        this.fieldRule = dateTimeFieldRule;
        this.textStyle = textStyle;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols dateTimeFormatSymbols) throws IOException {
        int n = calendrical.deriveValue(this.fieldRule);
        String string = dateTimeFormatSymbols.getFieldValueText(this.fieldRule, this.textStyle, n);
        if (string == null) {
            string = FormatUtil.convertToI18N(Integer.toString(n), dateTimeFormatSymbols);
        }
        appendable.append(string);
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return calendrical.isDerivable(this.fieldRule);
    }

    @Override
    public int parse(DateTimeParseContext dateTimeParseContext, String string, int n) {
        int n2 = string.length();
        if (n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int[] nArray = dateTimeParseContext.getSymbols().matchFieldText(this.fieldRule, this.textStyle, false, string.substring(n));
        if (nArray == null) {
            return new NumberPrinterParser(this.fieldRule, 1, 10, DateTimeFormatterBuilder.SignStyle.NORMAL).parse(dateTimeParseContext, string, n);
        }
        if (nArray[0] == 0) {
            return ~n;
        }
        dateTimeParseContext.setFieldValue(this.fieldRule, nArray[1]);
        return n += nArray[0];
    }

    public String toString() {
        if (this.textStyle == DateTimeFormatterBuilder.TextStyle.FULL) {
            return "Text(" + this.fieldRule.getID() + ")";
        }
        return "Text(" + this.fieldRule.getID() + "," + (Object)((Object)this.textStyle) + ")";
    }
}

