/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.time.calendar.zone.ZoneRules;
import javax.time.calendar.zone.ZoneRulesDataProvider;
import javax.time.calendar.zone.ZoneRulesGroup;

class JarZoneRulesDataProvider
implements ZoneRulesDataProvider {
    private final String groupID;
    private final String versionID;
    private final Map<String, ZoneRules> zones;

    static void load() {
        List<ZoneRulesDataProvider> list;
        try {
            list = JarZoneRulesDataProvider.loadJars();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to load time zone rule data", exception);
        }
        for (ZoneRulesDataProvider zoneRulesDataProvider : list) {
            ZoneRulesGroup.registerProvider(zoneRulesDataProvider);
        }
    }

    private static List<ZoneRulesDataProvider> loadJars() throws Exception {
        ArrayList<ZoneRulesDataProvider> arrayList = new ArrayList<ZoneRulesDataProvider>();
        Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources("javax/time/calendar/zone/ZoneRuleInfo.dat");
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            boolean bl = false;
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                int n = objectInputStream.readInt();
                for (int i = 0; i < n; ++i) {
                    String string = objectInputStream.readUTF();
                    String string2 = objectInputStream.readUTF();
                    Map map = (Map)objectInputStream.readObject();
                    arrayList.add(new JarZoneRulesDataProvider(string, string2, map));
                }
            }
            catch (IOException iOException) {
                bl = true;
                throw iOException;
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    if (bl) continue;
                    throw iOException;
                }
            }
        }
        return arrayList;
    }

    public JarZoneRulesDataProvider(String string, String string2, Map<String, ZoneRules> map) {
        this.groupID = string;
        this.versionID = string2;
        this.zones = map;
    }

    @Override
    public String getGroupID() {
        return this.groupID;
    }

    @Override
    public Set<String> getIDs() {
        HashSet<String> hashSet = new HashSet<String>(this.zones.size());
        for (String string : this.zones.keySet()) {
            hashSet.add(string + '#' + this.versionID);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public ZoneRules getZoneRules(String string, String string2) {
        if (string == null || string2 == null || !string2.equals(this.versionID)) {
            return null;
        }
        return this.zones.get(string);
    }
}

