/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.zone.ZoneRules;
import javax.time.period.Period;

public final class ZoneOffsetTransition
implements Comparable<ZoneOffsetTransition>,
Serializable {
    private static final long serialVersionUID = 3582762487L;
    private final OffsetDateTime transition;
    private final OffsetDateTime transitionAfter;

    ZoneOffsetTransition(OffsetDateTime offsetDateTime, ZoneOffset zoneOffset) {
        ZoneRules.checkNotNull(offsetDateTime, "OffsetDateTime must not be null");
        ZoneRules.checkNotNull(offsetDateTime, "ZoneOffset must not be null");
        this.transition = offsetDateTime;
        this.transitionAfter = offsetDateTime.withOffsetSameInstant(zoneOffset);
    }

    public Instant getInstant() {
        return this.transition.toInstant();
    }

    public LocalDateTime getLocal() {
        return this.transition.toLocalDateTime();
    }

    public OffsetDateTime getDateTime() {
        return this.transition;
    }

    public OffsetDateTime getDateTimeAfter() {
        return this.transitionAfter;
    }

    public ZoneOffset getOffsetBefore() {
        return this.transition.getOffset();
    }

    public ZoneOffset getOffsetAfter() {
        return this.transitionAfter.getOffset();
    }

    public Period getTransitionSize() {
        int n = this.getOffsetAfter().getAmountSeconds() - this.getOffsetBefore().getAmountSeconds();
        return Period.seconds(n).normalized();
    }

    public boolean isGap() {
        return this.getOffsetAfter().getAmountSeconds() > this.getOffsetBefore().getAmountSeconds();
    }

    public boolean isOverlap() {
        return this.getOffsetAfter().getAmountSeconds() < this.getOffsetBefore().getAmountSeconds();
    }

    public boolean isValidOffset(ZoneOffset zoneOffset) {
        return this.isGap() ? false : this.getOffsetBefore().equals(zoneOffset) || this.getOffsetAfter().equals(zoneOffset);
    }

    @Override
    public int compareTo(ZoneOffsetTransition zoneOffsetTransition) {
        return this.getInstant().compareTo(zoneOffsetTransition.getInstant());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ZoneOffsetTransition) {
            ZoneOffsetTransition zoneOffsetTransition = (ZoneOffsetTransition)object;
            return this.transition.equals(zoneOffsetTransition.transition) && this.transitionAfter.getOffset().equals(zoneOffsetTransition.transitionAfter.getOffset());
        }
        return false;
    }

    public int hashCode() {
        return this.transition.hashCode() ^ this.transitionAfter.getOffset().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Transition[").append(this.isGap() ? "Gap" : "Overlap").append(" at ").append(this.transition).append(" to ").append(this.transitionAfter.getOffset()).append(']');
        return stringBuilder.toString();
    }
}

