/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjusters;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.Year;
import javax.time.calendar.zone.StandardZoneRules;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneOffsetTransitionRule;
import javax.time.calendar.zone.ZoneRules;
import javax.time.period.Period;

public class ZoneRulesBuilder {
    private static final long serialVersionUID = 9375261659767L;
    private static final LocalDateTime MAX_DATE_TIME = LocalDateTime.dateTime(Integer.MAX_VALUE, 12, 31, 23, 59, 59, 999999999);
    private List<TZWindow> windowList = new ArrayList<TZWindow>();
    private Map<Object, Object> deduplicateMap;

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException(string);
        }
    }

    public ZoneRulesBuilder addWindow(ZoneOffset zoneOffset, LocalDateTime localDateTime, TimeDefinition timeDefinition) {
        ZoneRulesBuilder.checkNotNull(zoneOffset, "Standard offset must not be null");
        ZoneRulesBuilder.checkNotNull(localDateTime, "Until date-time must not be null");
        ZoneRulesBuilder.checkNotNull((Object)timeDefinition, "Time definition must not be null");
        TZWindow tZWindow = new TZWindow(zoneOffset, localDateTime, timeDefinition);
        if (this.windowList.size() > 0) {
            TZWindow tZWindow2 = this.windowList.get(this.windowList.size() - 1);
            tZWindow.validateWindowOrder(tZWindow2);
        }
        this.windowList.add(tZWindow);
        return this;
    }

    public ZoneRulesBuilder addWindowForever(ZoneOffset zoneOffset) {
        return this.addWindow(zoneOffset, MAX_DATE_TIME, TimeDefinition.WALL);
    }

    public ZoneRulesBuilder setFixedSavingsToWindow(Period period) {
        ZoneRulesBuilder.checkNotNull(period, "Fixed savings amount must not be null");
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("Must add a window before setting the fixed savings");
        }
        TZWindow tZWindow = this.windowList.get(this.windowList.size() - 1);
        tZWindow.setFixedSavings(period);
        return this;
    }

    public ZoneRulesBuilder addRuleToWindow(LocalDateTime localDateTime, TimeDefinition timeDefinition, Period period) {
        ZoneRulesBuilder.checkNotNull(localDateTime, "Rule end date-time must not be null");
        return this.addRuleToWindow(localDateTime.getYear(), localDateTime.getYear(), localDateTime.getMonthOfYear(), localDateTime.getDayOfMonth(), null, localDateTime.toLocalTime(), timeDefinition, period);
    }

    public ZoneRulesBuilder addRuleToWindow(int n, MonthOfYear monthOfYear, int n2, LocalTime localTime, TimeDefinition timeDefinition, Period period) {
        return this.addRuleToWindow(n, n, monthOfYear, n2, null, localTime, timeDefinition, period);
    }

    public ZoneRulesBuilder addRuleToWindow(int n, int n2, MonthOfYear monthOfYear, int n3, DayOfWeek dayOfWeek, LocalTime localTime, TimeDefinition timeDefinition, Period period) {
        ZoneRulesBuilder.checkNotNull(monthOfYear, "Rule end month must not be null");
        ZoneRulesBuilder.checkNotNull(localTime, "Rule end time must not be null");
        ZoneRulesBuilder.checkNotNull((Object)timeDefinition, "Time definition must not be null");
        ZoneRulesBuilder.checkNotNull(period, "Savings amount must not be null");
        ISOChronology.yearRule().checkValue(n);
        ISOChronology.yearRule().checkValue(n2);
        if (n3 != -1) {
            ISOChronology.dayOfMonthRule().checkValue(n3);
        }
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("Must add a window before adding a rule");
        }
        TZWindow tZWindow = this.windowList.get(this.windowList.size() - 1);
        tZWindow.addRule(n, n2, monthOfYear, n3, dayOfWeek, localTime, timeDefinition, period);
        return this;
    }

    public ZoneRules toRules(String string) {
        return this.toRules(string, new HashMap<Object, Object>());
    }

    ZoneRules toRules(String string, Map<Object, Object> map) {
        ZoneRulesBuilder.checkNotNull(string, "Time zone id must not be null");
        if (this.windowList.isEmpty()) {
            throw new IllegalStateException("No windows have been added to the builder");
        }
        this.deduplicateMap = map;
        ArrayList<OffsetDateTime> arrayList = new ArrayList<OffsetDateTime>(4);
        ArrayList<ZoneOffsetTransition> arrayList2 = new ArrayList<ZoneOffsetTransition>(256);
        ArrayList<ZoneOffsetTransitionRule> arrayList3 = new ArrayList<ZoneOffsetTransitionRule>(2);
        TZWindow tZWindow = this.windowList.get(0);
        ZoneOffset zoneOffset = tZWindow.standardOffset;
        Period period = Period.ZERO;
        if (tZWindow.fixedSavingAmount != null) {
            period = tZWindow.fixedSavingAmount;
        }
        ZoneOffset zoneOffset2 = this.deduplicate(zoneOffset.plus(period));
        OffsetDateTime offsetDateTime = this.deduplicate(OffsetDateTime.dateTime(-2147483646, 1, 1, 0, 0, zoneOffset2));
        for (TZWindow tZWindow2 : this.windowList) {
            Serializable serializable;
            Iterator iterator;
            Comparable<ZoneOffsetTransition> comparable2;
            Object object;
            tZWindow2.tidy(offsetDateTime.getYear());
            Period period2 = tZWindow2.fixedSavingAmount;
            if (period2 == null) {
                period2 = Period.ZERO;
                object = tZWindow2.ruleList.iterator();
                while (object.hasNext() && !((ZoneOffsetTransition)(comparable2 = ((TZRule)((Object)(iterator = (TZRule)object.next()))).toTransition(zoneOffset, period))).getDateTime().isAfter(offsetDateTime)) {
                    period2 = ((TZRule)((Object)iterator)).savingAmount;
                }
            }
            if (!zoneOffset.equals(tZWindow2.standardOffset)) {
                zoneOffset = this.deduplicate(tZWindow2.standardOffset);
                arrayList.add(this.deduplicate(offsetDateTime.withOffsetSameInstant(zoneOffset)));
            }
            object = this.deduplicate(zoneOffset.plus(period2));
            if (!offsetDateTime.getOffset().equals(object)) {
                iterator = new ZoneOffsetTransition(offsetDateTime, (ZoneOffset)object);
                arrayList2.add((ZoneOffsetTransition)((Object)iterator));
            }
            period = period2;
            for (Comparable<ZoneOffsetTransition> comparable2 : tZWindow2.ruleList) {
                serializable = ((TZRule)comparable2).toTransition(zoneOffset, period);
                if (((ZoneOffsetTransition)serializable).getDateTime().isBefore(offsetDateTime) || !((ZoneOffsetTransition)serializable).getDateTime().isBefore(tZWindow2.createDateTime(period)) || ((ZoneOffsetTransition)serializable).getOffsetBefore().equals(((ZoneOffsetTransition)serializable).getOffsetAfter())) continue;
                arrayList2.add((ZoneOffsetTransition)serializable);
                period = ((TZRule)comparable2).savingAmount;
            }
            iterator = tZWindow2.lastRuleList.iterator();
            while (iterator.hasNext()) {
                comparable2 = (TZRule)iterator.next();
                serializable = ((TZRule)comparable2).toTransitionRule(zoneOffset, period);
                arrayList3.add((ZoneOffsetTransitionRule)serializable);
                period = ((TZRule)comparable2).savingAmount;
            }
            offsetDateTime = this.deduplicate(tZWindow2.createDateTime(period));
        }
        return new StandardZoneRules(tZWindow.standardOffset, zoneOffset2, arrayList, arrayList2, arrayList3);
    }

    <T> T deduplicate(T t) {
        if (!this.deduplicateMap.containsKey(t)) {
            this.deduplicateMap.put(t, t);
        }
        return (T)this.deduplicateMap.get(t);
    }

    class TZRule
    implements Comparable<TZRule> {
        private int year;
        private final MonthOfYear month;
        private final int dayOfMonth;
        private final DayOfWeek dayOfWeek;
        private final LocalTime time;
        private final TimeDefinition timeDefinition;
        private final Period savingAmount;

        TZRule(int n, MonthOfYear monthOfYear, int n2, DayOfWeek dayOfWeek, LocalTime localTime, TimeDefinition timeDefinition, Period period) {
            this.year = n;
            this.month = monthOfYear;
            this.dayOfMonth = n2;
            this.dayOfWeek = dayOfWeek;
            this.time = localTime;
            this.timeDefinition = timeDefinition;
            this.savingAmount = period;
        }

        ZoneOffsetTransition toTransition(ZoneOffset zoneOffset, Period period) {
            LocalDate localDate;
            CalendricalProvider calendricalProvider;
            ZoneOffset zoneOffset2 = zoneOffset.plus(this.savingAmount);
            if (this.dayOfMonth == -1) {
                calendricalProvider = Year.isoYear(this.year);
                localDate = LocalDate.date(calendricalProvider, this.month, this.month.getLastDayOfMonth((Year)calendricalProvider));
                if (this.dayOfWeek != null) {
                    localDate = localDate.with(DateAdjusters.previousOrCurrent(this.dayOfWeek));
                }
            } else {
                localDate = LocalDate.date(this.year, this.month, this.dayOfMonth);
                if (this.dayOfWeek != null) {
                    localDate = localDate.with(DateAdjusters.nextOrCurrent(this.dayOfWeek));
                }
            }
            localDate = ZoneRulesBuilder.this.deduplicate(localDate);
            calendricalProvider = ZoneRulesBuilder.this.deduplicate(LocalDateTime.dateTime(localDate, this.time));
            ZoneOffset zoneOffset3 = ZoneRulesBuilder.this.deduplicate(zoneOffset.plus(period));
            OffsetDateTime offsetDateTime = ZoneRulesBuilder.this.deduplicate(this.timeDefinition.createDateTime((LocalDateTime)calendricalProvider, zoneOffset, zoneOffset3));
            return new ZoneOffsetTransition(offsetDateTime, zoneOffset2);
        }

        ZoneOffsetTransitionRule toTransitionRule(ZoneOffset zoneOffset, Period period) {
            int n = this.dayOfMonth == -1 ? (this.month == MonthOfYear.FEBRUARY ? -1 : this.month.maxLengthInDays() - 6) : this.dayOfMonth;
            ZoneOffsetTransition zoneOffsetTransition = this.toTransition(zoneOffset, period);
            return new ZoneOffsetTransitionRule(this.month, n, this.dayOfWeek, this.time, this.timeDefinition, zoneOffset, zoneOffsetTransition.getOffsetBefore(), zoneOffsetTransition.getOffsetAfter());
        }

        @Override
        public int compareTo(TZRule tZRule) {
            int n = this.year - tZRule.year;
            n = n == 0 ? this.month.compareTo(tZRule.month) : n;
            n = n == 0 ? this.dayOfMonth - tZRule.dayOfMonth : n;
            n = n == 0 ? this.time.compareTo(tZRule.time) : n;
            return n;
        }
    }

    class TZWindow {
        private final ZoneOffset standardOffset;
        private final LocalDateTime windowEnd;
        private final TimeDefinition timeDefinition;
        private Period fixedSavingAmount;
        private List<TZRule> ruleList = new ArrayList<TZRule>();
        private int maxLastRuleStartYear = -2147483646;
        private List<TZRule> lastRuleList = new ArrayList<TZRule>();

        TZWindow(ZoneOffset zoneOffset, LocalDateTime localDateTime, TimeDefinition timeDefinition) {
            this.windowEnd = localDateTime;
            this.timeDefinition = timeDefinition;
            this.standardOffset = zoneOffset;
        }

        void setFixedSavings(Period period) {
            if (this.ruleList.size() > 0 || this.lastRuleList.size() > 0) {
                throw new IllegalStateException("Window has DST rules, so cannot have fixed savings");
            }
            this.fixedSavingAmount = period;
        }

        void addRule(int n, int n2, MonthOfYear monthOfYear, int n3, DayOfWeek dayOfWeek, LocalTime localTime, TimeDefinition timeDefinition, Period period) {
            if (this.fixedSavingAmount != null) {
                throw new IllegalStateException("Window has a fixed DST saving, so cannot have DST rules");
            }
            if (this.ruleList.size() >= 2000) {
                throw new IllegalStateException("Window has reached the maximum number of allowed rules");
            }
            boolean bl = false;
            if (n2 == Integer.MAX_VALUE) {
                bl = true;
                n2 = n;
            }
            for (int i = n; i <= n2; ++i) {
                TZRule tZRule = new TZRule(i, monthOfYear, n3, dayOfWeek, localTime, timeDefinition, period);
                if (bl) {
                    this.lastRuleList.add(tZRule);
                    this.maxLastRuleStartYear = Math.max(n, this.maxLastRuleStartYear);
                    continue;
                }
                this.ruleList.add(tZRule);
            }
        }

        void validateWindowOrder(TZWindow tZWindow) {
            if (this.windowEnd.isBefore(tZWindow.windowEnd)) {
                throw new IllegalStateException("Windows must be added in date-time order: " + this.windowEnd + " < " + tZWindow.windowEnd);
            }
        }

        void tidy(int n) {
            if (this.lastRuleList.size() == 1) {
                throw new IllegalStateException("Cannot have only one rule defined as being forever");
            }
            if (this.windowEnd.equals(MAX_DATE_TIME)) {
                this.maxLastRuleStartYear = Math.max(this.maxLastRuleStartYear, n) + 1;
                for (TZRule tZRule : this.lastRuleList) {
                    this.addRule(tZRule.year, this.maxLastRuleStartYear, tZRule.month, tZRule.dayOfMonth, tZRule.dayOfWeek, tZRule.time, tZRule.timeDefinition, tZRule.savingAmount);
                    tZRule.year = this.maxLastRuleStartYear + 1;
                }
                if (this.maxLastRuleStartYear == Integer.MAX_VALUE) {
                    this.lastRuleList.clear();
                } else {
                    ++this.maxLastRuleStartYear;
                }
            } else {
                int n2 = this.windowEnd.getYear();
                for (TZRule tZRule : this.lastRuleList) {
                    this.addRule(tZRule.year, n2 + 1, tZRule.month, tZRule.dayOfMonth, tZRule.dayOfWeek, tZRule.time, tZRule.timeDefinition, tZRule.savingAmount);
                }
                this.lastRuleList.clear();
                this.maxLastRuleStartYear = Integer.MAX_VALUE;
            }
            Collections.sort(this.ruleList);
            Collections.sort(this.lastRuleList);
            if (this.ruleList.size() == 0 && this.fixedSavingAmount == null) {
                this.fixedSavingAmount = Period.ZERO;
            }
        }

        OffsetDateTime createDateTime(Period period) {
            ZoneOffset zoneOffset = this.standardOffset.plus(period);
            return this.timeDefinition.createDateTime(this.windowEnd, this.standardOffset, zoneOffset);
        }
    }

    public static enum TimeDefinition {
        UTC,
        WALL,
        STANDARD;


        public OffsetDateTime createDateTime(LocalDateTime localDateTime, ZoneOffset zoneOffset, ZoneOffset zoneOffset2) {
            switch (this) {
                case UTC: {
                    return OffsetDateTime.dateTime(localDateTime, ZoneOffset.UTC).withOffsetSameInstant(zoneOffset2);
                }
                case STANDARD: {
                    return OffsetDateTime.dateTime(localDateTime, zoneOffset).withOffsetSameInstant(zoneOffset2);
                }
            }
            return OffsetDateTime.dateTime(localDateTime, zoneOffset2);
        }
    }
}

