/*
 * Decompiled with CFR 0.152.
 */
package javax.time.i18n;

import java.io.Serializable;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDate;
import javax.time.i18n.CopticChronology;

public final class CopticDate
implements DateProvider,
CalendricalProvider,
Comparable<CopticDate>,
Serializable {
    public static final int MIN_YEAR = 1;
    public static final int MAX_YEAR = 9999;
    private static final long serialVersionUID = 27545623L;
    private static final int MJD_TO_COPTIC = 574971;
    private static final int MIN_EPOCH_DAY = 0;
    private static final int MAX_EPOCH_DAY = 3652134;
    private final int epochDays;
    private final transient int year;
    private final transient int month;
    private final transient int day;

    public static CopticDate copticDate(int n, int n2, int n3) {
        CopticChronology.INSTANCE.year().checkValue(n);
        CopticChronology.INSTANCE.monthOfYear().checkValue(n2);
        CopticChronology.INSTANCE.dayOfMonth().checkValue(n3);
        if (!(n2 != 13 || n3 <= 5 || n3 <= 6 && CopticChronology.isLeapYear(n))) {
            throw new InvalidCalendarFieldException("Invalid Coptic date", CopticChronology.INSTANCE.dayOfMonth());
        }
        int n4 = (n - 1) * 365 + n / 4 + 30 * (n2 - 1) + n3 - 1;
        return new CopticDate(n4, n, n2, n3);
    }

    private static CopticDate copticDatePreviousValid(int n, int n2, int n3) {
        CopticChronology.INSTANCE.year().checkValue(n);
        CopticChronology.INSTANCE.monthOfYear().checkValue(n2);
        CopticChronology.INSTANCE.dayOfMonth().checkValue(n3);
        if (n2 == 13 && n3 > 5) {
            n3 = CopticChronology.isLeapYear(n) ? 6 : 5;
        }
        int n4 = (n - 1) * 365 + n / 4 + 30 * (n2 - 1) + n3 - 1;
        return new CopticDate(n4, n, n2, n3);
    }

    public static CopticDate copticDate(DateProvider dateProvider) {
        LocalDate localDate = LocalDate.date(dateProvider);
        long l = localDate.toModifiedJulianDays() + 574971L;
        return CopticDate.copticDateFromEopchDays((int)l);
    }

    private static CopticDate copticDateFromEopchDays(int n) {
        if (n < 0 || n > 3652134) {
            throw new IllegalCalendarFieldValueException("Date exceeds supported range for CopticDate", CopticChronology.INSTANCE.year());
        }
        int n2 = (n * 4 + 1463) / 1461;
        int n3 = (n2 - 1) * 365 + n2 / 4;
        int n4 = n - n3;
        int n5 = n4 / 30 + 1;
        int n6 = n4 % 30 + 1;
        return new CopticDate(n, n2, n5, n6);
    }

    private CopticDate(int n, int n2, int n3, int n4) {
        this.epochDays = n;
        this.year = n2;
        this.month = n3;
        this.day = n4;
    }

    private Object readResolve() {
        return CopticDate.copticDateFromEopchDays(this.epochDays);
    }

    public CopticChronology getChronology() {
        return CopticChronology.INSTANCE;
    }

    public boolean isSupported(DateTimeFieldRule dateTimeFieldRule) {
        return dateTimeFieldRule != null && dateTimeFieldRule.getValueQuiet(this.toLocalDate(), null) != null;
    }

    public int get(DateTimeFieldRule dateTimeFieldRule) {
        return dateTimeFieldRule.getValue(this.toLocalDate(), null);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonthOfYear() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getDayOfYear() {
        int n = (this.year - 1) * 365 + this.year / 4;
        return this.epochDays - n + 1;
    }

    public int getDayOfWeek() {
        return (this.epochDays + 4) % 7 + 1;
    }

    public boolean isLeapYear() {
        return CopticChronology.isLeapYear(this.getYear());
    }

    public boolean isLeapDay() {
        return this.getMonthOfYear() == 13 && this.getDayOfMonth() == 6;
    }

    public CopticDate withYear(int n) {
        return CopticDate.copticDatePreviousValid(n, this.getMonthOfYear(), this.getDayOfMonth());
    }

    public CopticDate withMonthOfYear(int n) {
        return CopticDate.copticDatePreviousValid(this.getYear(), n, this.getDayOfMonth());
    }

    public CopticDate withDayOfMonth(int n) {
        return CopticDate.copticDate(this.getYear(), this.getMonthOfYear(), n);
    }

    public CopticDate withDayOfYear(int n) {
        return CopticDate.copticDate(this.getYear(), --n / 30 + 1, n % 30 + 1);
    }

    public CopticDate plusYears(int n) {
        int n2 = this.getYear() + n;
        return CopticDate.copticDatePreviousValid(n2, this.getMonthOfYear(), this.getDayOfMonth());
    }

    public CopticDate plusMonths(int n) {
        int n2 = this.getMonthOfYear() + n - 1;
        int n3 = n2 / 13;
        if ((n2 %= 13) < 0) {
            n2 += 13;
            --n3;
        }
        int n4 = this.getYear() + n3;
        int n5 = this.getDayOfMonth();
        return CopticDate.copticDatePreviousValid(n4, n2 + 1, n5);
    }

    public CopticDate plusDays(int n) {
        int n2 = this.epochDays + n;
        return CopticDate.copticDateFromEopchDays(n2);
    }

    @Override
    public LocalDate toLocalDate() {
        return LocalDate.fromModifiedJulianDays(this.epochDays - 574971);
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(this.toLocalDate(), null, null, null);
    }

    @Override
    public int compareTo(CopticDate copticDate) {
        return MathUtils.safeCompare(this.epochDays, copticDate.epochDays);
    }

    public boolean isAfter(CopticDate copticDate) {
        return this.epochDays > copticDate.epochDays;
    }

    public boolean isBefore(CopticDate copticDate) {
        return this.epochDays < copticDate.epochDays;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CopticDate) {
            CopticDate copticDate = (CopticDate)object;
            return this.epochDays == copticDate.epochDays;
        }
        return false;
    }

    public int hashCode() {
        return this.epochDays;
    }

    public String toString() {
        int n = this.getYear();
        int n2 = this.getMonthOfYear();
        int n3 = this.getDayOfMonth();
        int n4 = Math.abs(n);
        StringBuilder stringBuilder = new StringBuilder(12);
        if (n4 < 1000) {
            stringBuilder.append(n + 10000).deleteCharAt(0);
        } else {
            stringBuilder.append(n);
        }
        return stringBuilder.append(n2 < 10 ? "-0" : "-").append(n2).append(n3 < 10 ? "-0" : "-").append(n3).append(" (Coptic)").toString();
    }
}

