/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period.field;

import java.io.Serializable;
import javax.time.period.PeriodUnit;
import javax.time.period.PeriodUnits;
import javax.time.period.field.PeriodField;

public final class Hours
extends PeriodField
implements Comparable<Hours>,
Serializable {
    public static final Hours ZERO = new Hours(0);
    private static final long serialVersionUID = 1L;
    private final int hours;

    public static Hours hours(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Hours(n);
    }

    private Hours(int n) {
        this.hours = n;
    }

    private Object readResolve() {
        return Hours.hours(this.hours);
    }

    @Override
    public int getAmount() {
        return this.hours;
    }

    @Override
    public Hours withAmount(int n) {
        return Hours.hours(n);
    }

    @Override
    public PeriodUnit getUnit() {
        return PeriodUnits.HOURS;
    }

    @Override
    public Hours plus(int n) {
        return (Hours)super.plus(n);
    }

    public Hours plus(Hours hours) {
        return this.plus(hours.getAmount());
    }

    @Override
    public Hours minus(int n) {
        return (Hours)super.minus(n);
    }

    public Hours minus(Hours hours) {
        return this.minus(hours.getAmount());
    }

    @Override
    public Hours multipliedBy(int n) {
        return (Hours)super.multipliedBy(n);
    }

    @Override
    public Hours dividedBy(int n) {
        return (Hours)super.dividedBy(n);
    }

    @Override
    public Hours negated() {
        return (Hours)super.negated();
    }

    @Override
    public int compareTo(Hours hours) {
        int n = this.hours;
        int n2 = hours.hours;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean isGreaterThan(Hours hours) {
        return this.compareTo(hours) > 0;
    }

    public boolean isLessThan(Hours hours) {
        return this.compareTo(hours) < 0;
    }

    @Override
    public String toString() {
        return "PT" + this.hours + "H";
    }
}

