/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period.field;

import javax.time.MathUtils;
import javax.time.period.PeriodFields;
import javax.time.period.PeriodUnit;

public abstract class PeriodField {
    protected PeriodField() {
    }

    public abstract int getAmount();

    public abstract PeriodField withAmount(int var1);

    public abstract PeriodUnit getUnit();

    public PeriodField plus(int n) {
        if (n == 0) {
            return this;
        }
        return this.withAmount(MathUtils.safeAdd(this.getAmount(), n));
    }

    public PeriodField minus(int n) {
        return this.withAmount(MathUtils.safeSubtract(this.getAmount(), n));
    }

    public PeriodField multipliedBy(int n) {
        return this.withAmount(MathUtils.safeMultiply(this.getAmount(), n));
    }

    public PeriodField dividedBy(int n) {
        if (n == 1) {
            return this;
        }
        return this.withAmount(this.getAmount() / n);
    }

    public PeriodField negated() {
        return this.withAmount(MathUtils.safeNegate(this.getAmount()));
    }

    public PeriodFields toPeriodFields() {
        return PeriodFields.periodFields(this.getAmount(), this.getUnit());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PeriodField && this.getClass() == object.getClass()) {
            PeriodField periodField = (PeriodField)object;
            return this.getAmount() == periodField.getAmount();
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getAmount();
    }

    public abstract String toString();
}

