/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period.field;

import java.io.Serializable;
import javax.time.period.PeriodUnit;
import javax.time.period.PeriodUnits;
import javax.time.period.field.PeriodField;

public final class Seconds
extends PeriodField
implements Comparable<Seconds>,
Serializable {
    public static final Seconds ZERO = new Seconds(0);
    private static final long serialVersionUID = 1L;
    private final int seconds;

    public static Seconds seconds(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Seconds(n);
    }

    private Seconds(int n) {
        this.seconds = n;
    }

    private Object readResolve() {
        return Seconds.seconds(this.seconds);
    }

    @Override
    public int getAmount() {
        return this.seconds;
    }

    @Override
    public Seconds withAmount(int n) {
        return Seconds.seconds(n);
    }

    @Override
    public PeriodUnit getUnit() {
        return PeriodUnits.SECONDS;
    }

    @Override
    public Seconds plus(int n) {
        return (Seconds)super.plus(n);
    }

    public Seconds plus(Seconds seconds) {
        return this.plus(seconds.getAmount());
    }

    @Override
    public Seconds minus(int n) {
        return (Seconds)super.minus(n);
    }

    public Seconds minus(Seconds seconds) {
        return this.minus(seconds.getAmount());
    }

    @Override
    public Seconds multipliedBy(int n) {
        return (Seconds)super.multipliedBy(n);
    }

    @Override
    public Seconds dividedBy(int n) {
        return (Seconds)super.dividedBy(n);
    }

    @Override
    public Seconds negated() {
        return (Seconds)super.negated();
    }

    @Override
    public int compareTo(Seconds seconds) {
        int n = this.seconds;
        int n2 = seconds.seconds;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean isGreaterThan(Seconds seconds) {
        return this.compareTo(seconds) > 0;
    }

    public boolean isLessThan(Seconds seconds) {
        return this.compareTo(seconds) < 0;
    }

    @Override
    public String toString() {
        return "PT" + this.seconds + "S";
    }
}

