/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2003-2015 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package javax.xml.bind;

/**
 * As of JAXB 2.0, this class is deprecated and optional.
 * <p>
 * The {@code Validator} class is responsible for controlling the validation
 * of content trees during runtime.
 *
 * <p>
 * <a name="validationtypes"></a>
 * <b>Three Forms of Validation</b><br>
 * <blockquote>
 *    <dl>
 *        <dt><b>Unmarshal-Time Validation</b></dt>
 *        <dd>This form of validation enables a client application to receive 
 *            information about validation errors and warnings detected while
 *            unmarshalling XML data into a Java content tree and is completely 
 *            orthogonal to the other types of validation.  To enable or disable 
 *            it, see the javadoc for 
 *            {@link Unmarshaller#setValidating(boolean) Unmarshaller.setValidating}.
 *            All JAXB 1.0 Providers are required to support this operation.
 *        </dd>
 *
 *        <dt><b>On-Demand Validation</b></dt>
 *        <dd> This form of validation enables a client application to receive 
 *             information about validation errors and warnings detected in the 
 *             Java content tree.  At any point, client applications can call
 *             the {@link Validator#validate(Object) Validator.validate} method
 *             on the Java content tree (or any sub-tree of it).  All JAXB 1.0
 *             Providers are required to support this operation.
 *        </dd>
 *
 *        <dt><b>Fail-Fast Validation</b></dt>
 *        <dd> This form of validation enables a client application to receive 
 *             immediate feedback about modifications to the Java content tree 
 *             that violate type constraints on Java Properties as defined in 
 *             the specification.  JAXB Providers are not required support
 *             this type of validation.  Of the JAXB Providers that do support
 *             this type of validation, some may require you to decide at schema
 *             compile time whether or not a client application will be allowed
 *             to request fail-fast validation at runtime.
 *        </dd>
 *    </dl>
 * </blockquote>
 *
 * <p>
 * The {@code Validator} class is responsible for managing On-Demand Validation.
 * The {@code Unmarshaller} class is responsible for managing Unmarshal-Time
 * Validation during the unmarshal operations.  Although there is no formal
 * method of enabling validation during the marshal operations, the 
 * {@code Marshaller} may detect errors, which will be reported to the
 * {@code ValidationEventHandler} registered on it.
 *
 * <p>
 * <a name="defaulthandler"></a>
 * <b>Using the Default EventHandler</b><br>
 * <blockquote>
 *   If the client application does not set an event handler on their
 *   {@code Validator}, {@code Unmarshaller}, or {@code Marshaller} prior to
 *   calling the validate, unmarshal, or marshal methods, then a default event 
 *   handler will receive notification of any errors or warnings encountered.  
 *   The default event handler will cause the current operation to halt after 
 *   encountering the first error or fatal error (but will attempt to continue 
 *   after receiving warnings).
 * </blockquote>
 *
 * <p>
 * <a name="handlingevents"></a>
 * <b>Handling Validation Events</b><br>
 * <blockquote>
 *   There are three ways to handle events encountered during the unmarshal,
 *   validate, and marshal operations:
 *    <dl>
 *        <dt>Use the default event handler</dt>
 *        <dd>The default event handler will be used if you do not specify one
 *            via the {@code setEventHandler} API's on {@code Validator},
 *            {@code Unmarshaller}, or {@code Marshaller}.
 *        </dd>
 * 
 *        <dt>Implement and register a custom event handler</dt>
 *        <dd>Client applications that require sophisticated event processing
 *            can implement the {@code ValidationEventHandler} interface and
 *            register it with the {@code Unmarshaller} and/or
 *            {@code Validator}.
 *        </dd>
 *
 *        <dt>Use the {@link javax.xml.bind.util.ValidationEventCollector ValidationEventCollector} 
 *            utility</dt>
 *        <dd>For convenience, a specialized event handler is provided that
 *            simply collects any {@code ValidationEvent} objects created
 *            during the unmarshal, validate, and marshal operations and 
 *            returns them to the client application as a 
 *            {@code java.util.Collection}.
 *        </dd>
 *    </dl>
 * </blockquote>
 *
 * <p>
 * <b>Validation and Well-Formedness</b><br>
 * <blockquote>
 * <p>
 * Validation events are handled differently depending on how the client 
 * application is configured to process them as described in the previous
 * section.  However, there are certain cases where a JAXB Provider indicates
 * that it is no longer able to reliably detect and report errors.  In these
 * cases, the JAXB Provider will set the severity of the ValidationEvent to
 * FATAL_ERROR to indicate that the unmarshal, validate, or marshal operations 
 * should be terminated.  The default event handler and 
 * {@code ValidationEventCollector} utility class must terminate processing
 * after being notified of a fatal error.  Client applications that supply their 
 * own {@code ValidationEventHandler} should also terminate processing after
 * being notified of a fatal error.  If not, unexpected behaviour may occur.
 * </blockquote>
 *
 * <p>
 * <a name="supportedProps"></a>
 * <b>Supported Properties</b><br>
 * <blockquote>
 * <p>
 * There currently are not any properties required to be supported by all 
 * JAXB Providers on Validator.  However, some providers may support 
 * their own set of provider specific properties.
 * </blockquote>
 * 
 * 
 * @author <ul><li>Ryan Shoemaker, Sun Microsystems, Inc.</li><li>Kohsuke Kawaguchi, Sun Microsystems, Inc.</li><li>Joe Fialli, Sun Microsystems, Inc.</li></ul> 
 * @see JAXBContext
 * @see Unmarshaller
 * @see ValidationEventHandler
 * @see ValidationEvent
 * @see javax.xml.bind.util.ValidationEventCollector
 * @since 1.6, JAXB 1.0
 * @deprecated since JAXB 2.0
 */
public interface Validator {

    /**
     * Allow an application to register a validation event handler.
     * <p>
     * The validation event handler will be called by the JAXB Provider if any
     * validation errors are encountered during calls to 
     * {@link #validate(Object) validate}.  If the client application does not 
     * register a validation event handler before invoking the validate method, 
     * then validation events will be handled by the default event handler which
     * will terminate the validate operation after the first error or fatal error
     * is encountered.
     * <p>
     * Calling this method with a null parameter will cause the Validator
     * to revert back to the default default event handler.
     *
     * @param handler the validation event handler
     * @throws JAXBException if an error was encountered while setting the
     *         event handler
     * @deprecated since JAXB2.0
     */
    public void setEventHandler( ValidationEventHandler handler )
        throws JAXBException;

    /**
     * Return the current event handler or the default event handler if one
     * hasn't been set.
     *
     * @return the current ValidationEventHandler or the default event handler
     *         if it hasn't been set
     * @throws JAXBException if an error was encountered while getting the 
     *         current event handler
     * @deprecated since JAXB2.0
     */
    public ValidationEventHandler getEventHandler()
        throws JAXBException;
        
    /**
     * Validate the Java content tree starting at {@code subrootObj}.
     * <p>
     * Client applications can use this method to validate Java content trees
     * on-demand at runtime.  This method can be used to validate any arbitrary
     * subtree of the Java content tree.  Global constraint checking <b>will not
     * </b> be performed as part of this operation (i.e. ID/IDREF constraints).
     *
     * @param subrootObj the obj to begin validation at
     * @throws JAXBException if any unexpected problem occurs during validation
     * @throws ValidationException 
     *     If the {@link ValidationEventHandler ValidationEventHandler}
     *     returns false from its {@code handleEvent} method or the
     *     {@code Validator} is unable to validate the content tree rooted
     *     at {@code subrootObj}
     * @throws IllegalArgumentException
     *      If the subrootObj parameter is null
     * @return true if the subtree rooted at {@code subrootObj} is valid, false
     *         otherwise
     * @deprecated since JAXB2.0
     */
    public boolean validate( Object subrootObj ) throws JAXBException;
    
    /**
     * Validate the Java content tree rooted at {@code rootObj}.
     * <p>
     * Client applications can use this method to validate Java content trees
     * on-demand at runtime.  This method is used to validate an entire Java
     * content tree.  Global constraint checking <b>will</b> be performed as 
     * part of this operation (i.e. ID/IDREF constraints).
     *
     * @param rootObj the root obj to begin validation at
     * @throws JAXBException if any unexpected problem occurs during validation
     * @throws ValidationException 
     *     If the {@link ValidationEventHandler ValidationEventHandler}
     *     returns false from its {@code handleEvent} method or the
     *     {@code Validator} is unable to validate the content tree rooted
     *     at {@code rootObj}
     * @throws IllegalArgumentException
     *      If the rootObj parameter is null
     * @return true if the tree rooted at {@code rootObj} is valid, false
     *         otherwise
     * @deprecated since JAXB2.0
     */
    public boolean validateRoot( Object rootObj ) throws JAXBException;

    /**
     * Set the particular property in the underlying implementation of 
     * {@code Validator}.  This method can only be used to set one of
     * the standard JAXB defined properties above or a provider specific
     * property.  Attempting to set an undefined property will result in
     * a PropertyException being thrown.  See <a href="#supportedProps">
     * Supported Properties</a>.
     *
     * @param name the name of the property to be set. This value can either
     *              be specified using one of the constant fields or a user 
     *              supplied string.
     * @param value the value of the property to be set
     *
     * @throws PropertyException when there is an error processing the given
     *                            property or value
     * @throws IllegalArgumentException
     *      If the name parameter is null
     * @deprecated since JAXB2.0
     */
    public void setProperty( String name, Object value ) 
        throws PropertyException;
    
    /**
     * Get the particular property in the underlying implementation of 
     * {@code Validator}.  This method can only be used to get one of
     * the standard JAXB defined properties above or a provider specific
     * property.  Attempting to get an undefined property will result in
     * a PropertyException being thrown.  See <a href="#supportedProps">
     * Supported Properties</a>.
     *
     * @param name the name of the property to retrieve
     * @return the value of the requested property
     *
     * @throws PropertyException
     *      when there is an error retrieving the given property or value
     *      property name
     * @throws IllegalArgumentException
     *      If the name parameter is null
     * @deprecated since JAXB2.0
     */
    public Object getProperty( String name ) throws PropertyException;
    
}
