/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.util.HashMap;
import java.util.WeakHashMap;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Domain;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.proxy.container.AOPProxyFactoryMixin;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerProxyCacheKey;
import org.jboss.aop.proxy.container.InstanceProxyContainer;
import org.jboss.aop.proxy.container.ProxyAdvisorDomain;
import org.jboss.metadata.spi.MetaData;

public class ContainerCache {
    private static volatile int counter;
    public static final Object mapLock;
    private static WeakHashMap<Class, HashMap<String, ClassProxyContainer>> containerCache;
    private AspectManager manager;
    private ContainerProxyCacheKey key;
    private Advisor classAdvisor;
    private InstanceProxyContainer instanceContainer;
    boolean isClassProxyContainer;
    Class[] interfaces;
    AOPProxyFactoryMixin[] mixins;
    MetaData metaData;
    boolean metaDataHasInstanceLevelData;
    SimpleMetaData simpleMetaData;

    private ContainerCache(AspectManager manager, Class proxiedClass, Class[] interfaces, AOPProxyFactoryMixin[] mixins, MetaData metaData, boolean metaDataHasInstanceLevelData, SimpleMetaData simpleMetaData) {
        this.manager = manager;
        this.interfaces = interfaces;
        this.mixins = mixins;
        this.metaData = metaData;
        this.simpleMetaData = simpleMetaData;
        this.metaDataHasInstanceLevelData = metaDataHasInstanceLevelData;
        this.key = new ContainerProxyCacheKey(manager.getManagerFQN(), proxiedClass, interfaces, mixins, metaData);
    }

    public static ContainerCache initialise(AspectManager manager, Class proxiedClass, MetaData metaData, boolean metaDataHasInstanceLevelData) {
        return ContainerCache.initialise(manager, proxiedClass, null, null, metaData, metaDataHasInstanceLevelData, null);
    }

    public static ContainerCache initialise(AspectManager manager, AOPProxyFactoryParameters params) {
        return ContainerCache.initialise(manager, params.getProxiedClass(), params.getInterfaces(), params.getMixins(), params.getMetaData(), params.getMetaDataHasInstanceLevelData(), params.getSimpleMetaData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContainerCache initialise(AspectManager manager, Class proxiedClass, Class[] interfaces, AOPProxyFactoryMixin[] mixins, MetaData metaData, boolean metaDataHasInstanceLevelData, SimpleMetaData simpleMetaData) {
        ContainerCache factory = new ContainerCache(manager, proxiedClass, interfaces, mixins, metaData, metaDataHasInstanceLevelData, simpleMetaData);
        Object object = mapLock;
        synchronized (object) {
            factory.initClassContainer();
            factory.initInstanceContainer();
        }
        return factory;
    }

    public ContainerProxyCacheKey getKey() {
        return this.key;
    }

    public Advisor getAdvisor() {
        return this.instanceContainer != null ? this.instanceContainer : this.classAdvisor;
    }

    public Advisor getClassAdvisor() {
        return this.classAdvisor;
    }

    public InstanceProxyContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public boolean hasAspects() {
        if (this.instanceContainer != null) {
            return this.instanceContainer.hasAspects();
        }
        return this.classAdvisor.hasAspects();
    }

    public boolean requiresInstanceAdvisor() {
        return this.hasInterfaceIntroductions() || this.hasMixins() || this.metaData != null && this.metaDataHasInstanceLevelData || this.simpleMetaData != null;
    }

    public boolean isAdvised() {
        return Advised.class.isAssignableFrom(this.key.getClazz());
    }

    private boolean hasInterfaceIntroductions() {
        return this.interfaces != null && this.interfaces.length > 0;
    }

    private boolean hasMixins() {
        return this.mixins != null && this.mixins.length > 0;
    }

    private void initClassContainer() {
        if (Advised.class.isAssignableFrom(this.key.getClazz())) {
            this.classAdvisor = AspectManager.instance().getAdvisor(this.key.getClazz());
        } else {
            this.classAdvisor = this.getCachedContainer(this.manager);
            if (this.classAdvisor == null) {
                this.classAdvisor = this.createAndCacheContainer();
            }
        }
    }

    public static ClassProxyContainer getCachedContainer(ContainerProxyCacheKey key) {
        HashMap<String, ClassProxyContainer> managerContainers = containerCache.get(key.getClazz());
        if (managerContainers != null) {
            return managerContainers.get(key.getManagerFQN());
        }
        return null;
    }

    private ClassProxyContainer getCachedContainer(AspectManager manager) {
        HashMap<String, ClassProxyContainer> managerContainers = containerCache.get(this.key.getClazz());
        if (managerContainers != null) {
            return managerContainers.get(manager.getManagerFQN());
        }
        return null;
    }

    private ClassProxyContainer createAndCacheContainer() {
        ClassProxyContainer container = this.createContainer();
        this.cacheContainer(this.key, container);
        return container;
    }

    private ClassProxyContainer createContainer() {
        String name = Domain.getDomainName(this.key.getClazz(), false);
        ProxyAdvisorDomain domain = new ProxyAdvisorDomain(this.manager, name, this.key.getClazz(), false);
        String classname = this.key.getClazz() != null ? this.key.getClazz().getName() : "AOP$Hollow";
        ClassProxyContainer container = new ClassProxyContainer(classname, (AspectManager)((Object)domain));
        domain.setAdvisor((Advisor)((Object)container));
        container.initialise(this.key.getClazz());
        return container;
    }

    private void cacheContainer(ContainerProxyCacheKey key, ClassProxyContainer container) {
        HashMap<String, ClassProxyContainer> managerContainers = containerCache.get(key.getClazz());
        if (managerContainers == null) {
            managerContainers = new HashMap();
            containerCache.put(key.getClazz(), managerContainers);
        }
        managerContainers.put(key.getManagerFQN(), container);
    }

    private InterfaceIntroduction getInterfaceIntroduction() {
        int mixinLength;
        int introductionLength = this.hasInterfaceIntroductions() ? this.interfaces.length : 0;
        int n = mixinLength = this.hasMixins() ? this.mixins.length : 0;
        if (introductionLength == 0 && mixinLength == 0) {
            return null;
        }
        Class<Object> proxiedClass = this.classAdvisor.getClazz();
        if (proxiedClass == null) {
            proxiedClass = Object.class;
        }
        String[] introducedNames = this.getClassNames(this.interfaces);
        InterfaceIntroduction intro = new InterfaceIntroduction("Introduction" + counter++, proxiedClass.getName(), introducedNames);
        if (mixinLength > 0) {
            this.addMixins(intro);
        }
        return intro;
    }

    private void addMixins(InterfaceIntroduction intro) {
        for (int i = 0; i < this.mixins.length && this.mixins != null; ++i) {
            Class[] mixinInterfaces = this.mixins[i].getInterfaces();
            Class mixinClass = this.mixins[i].getMixin();
            if (mixinInterfaces == null) {
                throw new RuntimeException("When defining a mixin, interfaces must be defined");
            }
            if (mixinClass == null) {
                throw new RuntimeException("When defining a mixin, the mixin must be defined");
            }
            String[] mixinInterfaceNames = this.getClassNames(mixinInterfaces);
            InterfaceIntroduction.Mixin mixin = new InterfaceIntroduction.Mixin(mixinClass.getName(), mixinInterfaceNames, this.mixins[i].getConstruction(), false);
            intro.addMixin(mixin);
        }
    }

    private String[] getClassNames(Class[] classes) {
        if (classes == null) {
            return null;
        }
        String[] names = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            names[i] = classes[i].getName();
        }
        return names;
    }

    private void initInstanceContainer() {
        if (this.requiresInstanceAdvisor()) {
            InterfaceIntroduction introduction = null;
            if (this.hasInterfaceIntroductions() || this.hasMixins()) {
                introduction = this.getInterfaceIntroduction();
            }
            this.instanceContainer = InstanceProxyContainer.createInstanceProxyContainer(this.classAdvisor, introduction, this.metaData);
        }
    }

    static {
        mapLock = new Object();
        containerCache = new WeakHashMap();
    }
}

