/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.aop.advice.AbstractAdvice;
import org.jboss.aop.joinpoint.Invocation;

class MarshalledAdvice
extends AbstractAdvice
implements Serializable {
    private Object aspect;
    private String name;
    private volatile boolean initialised = false;

    public MarshalledAdvice(Object aspect, String name, String adviceName) {
        this.aspect = aspect;
        this.name = name;
        this.adviceName = adviceName;
        this.aspectClass = aspect.getClass();
    }

    public Object getAspectInstance() {
        return this.aspect;
    }

    public String getName() {
        return this.name;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (!this.initialised) {
            super.init(this.adviceName, this.aspect.getClass());
            this.initialised = true;
        }
        Method advice = this.resolveAdvice(invocation);
        Object[] args = new Object[]{invocation};
        try {
            return advice.invoke(this.aspect, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.adviceName);
        out.writeObject(this.aspect);
        out.writeObject(this.aspectClass);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.adviceName = in.readUTF();
        this.aspect = in.readObject();
        this.aspectClass = (Class)in.readObject();
    }
}

