package org.jboss.cache.tests;

import org.jboss.cache.CacheException;
import org.jboss.cache.TreeCacheMBean;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.util.Properties;

/**
 * Simple client which looks up a TreeCache via JNDI and invokes a bunch of methods on it
 * @author Bela Ban
 * @version $Id: Client.java,v 1.1 2005/01/27 15:39:30 belaban Exp $
 */
public class Client {
   public static void main(String[] args) {
      try {
         new Client().start(args);
      }
      catch(NamingException e) {
         e.printStackTrace();
      }
      catch(CacheException e) {
         e.printStackTrace();
      }
   }

   private void start(String[] args) throws NamingException, CacheException {
      TreeCacheMBean cache;
      String jndi_name=args.length > 0? args[0] : "MyCache";
      Properties props=new Properties();
      props.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
      props.setProperty("java.naming.provider.url", "jnp://localhost:1099");
      props.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming");
      InitialContext ctx=new InitialContext(props);
      cache=(TreeCacheMBean)ctx.lookup(jndi_name);
      cache.put("a/b/c", null);
      System.out.println("Cache: " + cache.printDetails());
      System.out.println("cache mode: " + cache.getCacheMode());
      int numLocks, numNodes, numAttrs;

      numLocks=cache.getNumberOfLocksHeld();
      numNodes=cache.getNumberOfNodes();
      numAttrs=cache.getNumberOfAttributes();
      System.out.println("Nodes: " + numNodes + ", locks: " + numLocks + ", attributes: " + numAttrs);
   }
}
