/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.common;

import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.utils.Utility;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.UnknownHostException;

public class Uid
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7808395904206530189L;
    private int hostAddr;
    private int process;
    private int sec;
    private int other;
    private int _hashValue;
    private boolean _valid;
    private static int uidsCreated;
    private static int initTime;
    private static char breakChar;
    private static char fileBreakChar;
    private static Uid NIL_UID;
    private static Uid LAST_RESOURCE_UID;
    private static Uid MAX_UID;
    private static Uid MIN_UID;

    public Uid() {
        this.hostAddr = -1;
        this.process = 0;
        this.sec = 0;
        this.other = 0;
        this._hashValue = -1;
        this._valid = true;
        try {
            this.hostAddr = Utility.hostInetAddr();
            this.process = Utility.getpid();
            if (initTime == 0) {
                initTime = (int)(System.currentTimeMillis() / 1000L);
            }
            this.sec = initTime;
            this.other = Uid.getValue();
        }
        catch (UnknownHostException e) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Uid_1");
            }
            this._valid = false;
        }
    }

    public Uid(Uid copyFrom) {
        this.copy(copyFrom);
    }

    public Uid(String uidString) {
        this(uidString, true);
    }

    public Uid(String uidString, boolean errsOk) {
        char theBreakChar = Uid.getBreakChar(uidString);
        this.hostAddr = -1;
        this.process = 0;
        this.sec = 0;
        this.other = 0;
        this._hashValue = -1;
        this._valid = false;
        if (uidString.length() > 0) {
            int startIndex = 0;
            int endIndex = 0;
            String s = null;
            try {
                while (uidString.charAt(endIndex) != theBreakChar) {
                    ++endIndex;
                }
                s = uidString.substring(startIndex, endIndex);
                this.hostAddr = (int)Utility.hexStringToLong(s);
                startIndex = endIndex + 1;
                ++endIndex;
                while (uidString.charAt(endIndex) != theBreakChar) {
                    ++endIndex;
                }
                s = uidString.substring(startIndex, endIndex);
                this.process = (int)Utility.hexStringToLong(s);
                startIndex = endIndex + 1;
                ++endIndex;
                while (uidString.charAt(endIndex) != theBreakChar) {
                    ++endIndex;
                }
                s = uidString.substring(startIndex, endIndex);
                this.sec = (int)Utility.hexStringToLong(s);
                s = uidString.substring(endIndex + 1, uidString.length());
                this.other = (int)Utility.hexStringToLong(s);
                this._valid = true;
            }
            catch (NumberFormatException e) {
                if (!errsOk && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Uid_3", new Object[]{uidString});
                }
                this._valid = false;
            }
            catch (StringIndexOutOfBoundsException e) {
                this._valid = false;
            }
        } else {
            this.copy(Uid.nullUid());
        }
        if (!this._valid) {
            if (errsOk) {
                try {
                    this.copy(Uid.nullUid());
                }
                catch (Exception e) {
                    if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                        tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.arjuna.common.Uid_4", new Object[]{uidString});
                    }
                    throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.common.Uid_2"), e);
                }
            } else {
                if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                    tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.arjuna.common.Uid_5", new Object[]{uidString});
                }
                throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.common.Uid_3") + uidString);
            }
        }
    }

    public int hashCode() {
        if (this._hashValue == -1) {
            this.generateHash();
        }
        return this._hashValue;
    }

    public synchronized void pack(OutputBuffer packInto) throws IOException {
        if (!this._valid) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.common.Uid_9"));
        }
        packInto.packInt(this.hostAddr);
        packInto.packInt(this.process);
        packInto.packInt(this.sec);
        packInto.packInt(this.other);
    }

    public synchronized void unpack(InputBuffer unpackFrom) throws IOException {
        if (this == Uid.nullUid()) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.common.Uid_10"));
        }
        this._valid = true;
        try {
            this.hostAddr = unpackFrom.unpackInt();
            this.process = unpackFrom.unpackInt();
            this.sec = unpackFrom.unpackInt();
            this.other = unpackFrom.unpackInt();
            this._hashValue = -1;
        }
        catch (IOException e) {
            this._valid = false;
            throw e;
        }
    }

    public void print(PrintStream strm) {
        strm.print("<Uid:" + this.toString() + ">");
    }

    public String stringForm() {
        return Utility.intToHexString(this.hostAddr) + breakChar + Utility.intToHexString(this.process) + breakChar + Utility.intToHexString(this.sec) + breakChar + Utility.intToHexString(this.other);
    }

    public String fileStringForm() {
        return Utility.intToHexString(this.hostAddr) + fileBreakChar + Utility.intToHexString(this.process) + fileBreakChar + Utility.intToHexString(this.sec) + fileBreakChar + Utility.intToHexString(this.other);
    }

    public String toString() {
        return this.stringForm();
    }

    public Object clone() throws CloneNotSupportedException {
        return new Uid(this);
    }

    public synchronized void copy(Uid toCopy) {
        if (toCopy == this) {
            return;
        }
        this.hostAddr = toCopy.hostAddr;
        this.process = toCopy.process;
        this.sec = toCopy.sec;
        this.other = toCopy.other;
        this._hashValue = toCopy._hashValue;
        this._valid = toCopy._valid;
    }

    public boolean equals(Object o) {
        if (o instanceof Uid) {
            return this.equals((Uid)o);
        }
        return false;
    }

    public boolean equals(Uid u) {
        if (u == null) {
            return false;
        }
        if (u == this) {
            return true;
        }
        return this.other == u.other && this.sec == u.sec && this.process == u.process && this.hostAddr == u.hostAddr;
    }

    public boolean notEquals(Uid u) {
        if (u == null) {
            return true;
        }
        if (u == this) {
            return false;
        }
        return this.other != u.other || this.sec != u.sec || this.process != u.process || this.hostAddr != u.hostAddr;
    }

    public boolean lessThan(Uid u) {
        if (u == null) {
            return false;
        }
        if (u == this) {
            return false;
        }
        if (this.equals(u)) {
            return false;
        }
        if (LAST_RESOURCE_UID.equals(this)) {
            return false;
        }
        if (LAST_RESOURCE_UID.equals(u)) {
            return true;
        }
        if (this.hostAddr < u.hostAddr) {
            return true;
        }
        if (this.hostAddr == u.hostAddr) {
            if (this.process < u.process) {
                return true;
            }
            if (this.process == u.process) {
                if (this.sec < u.sec) {
                    return true;
                }
                if (this.sec == u.sec && this.other < u.other) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean greaterThan(Uid u) {
        if (u == null) {
            return false;
        }
        if (u == this) {
            return false;
        }
        if (this.equals(u)) {
            return false;
        }
        if (LAST_RESOURCE_UID.equals(this)) {
            return true;
        }
        if (LAST_RESOURCE_UID.equals(u)) {
            return false;
        }
        if (this.hostAddr > u.hostAddr) {
            return true;
        }
        if (this.hostAddr == u.hostAddr) {
            if (this.process > u.process) {
                return true;
            }
            if (this.process == u.process) {
                if (this.sec > u.sec) {
                    return true;
                }
                if (this.sec == u.sec && this.other > u.other) {
                    return true;
                }
            }
        }
        return false;
    }

    public final synchronized boolean valid() {
        return this._valid;
    }

    public static final Uid nullUid() {
        return NIL_UID;
    }

    public static final Uid lastResourceUid() {
        return LAST_RESOURCE_UID;
    }

    public static final Uid maxUid() {
        return MAX_UID;
    }

    public static final Uid minUid() {
        return MIN_UID;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (!this._valid) {
            throw new IOException("Invalid Uid object.");
        }
        out.writeInt(this.hostAddr);
        out.writeInt(this.process);
        out.writeInt(this.sec);
        out.writeInt(this.other);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._valid = true;
        try {
            this.hostAddr = in.readInt();
            this.process = in.readInt();
            this.sec = in.readInt();
            this.other = in.readInt();
            this._hashValue = -1;
        }
        catch (IOException e) {
            this._valid = false;
            throw e;
        }
    }

    private static final synchronized int getValue() {
        if ((uidsCreated & 0xF0000000) > 0) {
            uidsCreated = 0;
            initTime = (int)(System.currentTimeMillis() / 1000L);
        }
        return uidsCreated++;
    }

    private final synchronized void generateHash() {
        if (this._valid) {
            this._hashValue = this.hostAddr ^ this.process ^ this.sec ^ this.other;
            if (this._hashValue < 0) {
                this._hashValue = -this._hashValue;
            }
        } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Uid_6");
        }
    }

    private static final char getBreakChar(String uidString) {
        if (uidString == null) {
            return breakChar;
        }
        if (uidString.indexOf(fileBreakChar) != -1) {
            return fileBreakChar;
        }
        return breakChar;
    }

    static {
        breakChar = (char)58;
        fileBreakChar = (char)95;
        NIL_UID = new Uid("0:0:0:0");
        LAST_RESOURCE_UID = new Uid("0:0:0:1");
        MAX_UID = new Uid("7fffffff:7fffffff:7fffffff:7fffffff");
        MIN_UID = new Uid("-80000000:-80000000:-80000000:-80000000");
    }
}

