/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.gandiva.nameservice;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.gandiva.nameservice.NameServiceImple;
import java.io.IOException;
import java.util.Enumeration;

public class JNS
extends NameServiceImple {
    private static final char SIGNED_NUMBER = '#';
    private static final char UNSIGNED_NUMBER = '~';
    private static final char STRING = '^';
    private static final char OBJECTNAME = '%';
    private static final char CLASSNAME = '-';
    private static final char UID = '+';
    private static final String jnsName = "JNS:";

    @Override
    public int attributeType(String objName, String attrName) throws IOException {
        String attr = arjPropertyManager.getPropertyManager().getProperty(objName + "." + attrName, null);
        if (attr == null) {
            throw new IOException("No such attribute.");
        }
        if (attr.charAt(0) == '#') {
            return 0;
        }
        if (attr.charAt(0) == '~') {
            return 1;
        }
        if (attr.charAt(0) == '^') {
            return 2;
        }
        if (attr.charAt(0) == '%') {
            return 3;
        }
        if (attr.charAt(0) == '-') {
            return 4;
        }
        if (attr.charAt(0) == '+') {
            return 5;
        }
        throw new IOException("Unknown attribute type.");
    }

    @Override
    public String firstAttributeName(String objName) throws IOException {
        Enumeration e = arjPropertyManager.getPropertyManager().propertyNames();
        if (e.hasMoreElements()) {
            return (String)e.nextElement();
        }
        throw new IOException("No attributes.");
    }

    @Override
    public String nextAttributeName(String objName, String attrName) throws IOException {
        Enumeration e = arjPropertyManager.getPropertyManager().propertyNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (!s.equals(objName + "." + attrName) || !e.hasMoreElements()) continue;
            return (String)e.nextElement();
        }
        throw new IOException("No more attributes.");
    }

    @Override
    public long getLongAttribute(String objName, String attrName) throws IOException {
        String attr = arjPropertyManager.getPropertyManager().getProperty(objName + "." + attrName, null);
        if (attr != null) {
            if (attr.charAt(0) == '#') {
                try {
                    return Long.parseLong(new String(attr.substring(1)));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Not a number.");
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IOException("Not a number.");
                }
            }
            throw new IOException("Not a signed number.");
        }
        throw new IOException("No such attribute.");
    }

    @Override
    public String getStringAttribute(String objName, String attrName) throws IOException {
        String attr = arjPropertyManager.getPropertyManager().getProperty(objName + "." + attrName, null);
        if (attr != null) {
            if (attr.charAt(0) == '^') {
                try {
                    return new String(attr.substring(1));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IOException("No string.");
                }
            }
            throw new IOException("Not a string.");
        }
        throw new IOException("No such attribute.");
    }

    @Override
    public ObjectName getObjectNameAttribute(String objName, String attrName) throws IOException {
        String attr = arjPropertyManager.getPropertyManager().getProperty(objName + "." + attrName, null);
        if (attr != null) {
            if (attr.charAt(0) == '%') {
                try {
                    return new ObjectName(new String(attr.substring(1)));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IOException("No ObjectName.");
                }
            }
            throw new IOException("Not an ObjectName.");
        }
        throw new IOException("No such attribute.");
    }

    @Override
    public ClassName getClassNameAttribute(String objName, String attrName) throws IOException {
        String attr = arjPropertyManager.getPropertyManager().getProperty(objName + "." + attrName, null);
        if (attr != null) {
            if (attr.charAt(0) == '-') {
                try {
                    return new ClassName(new String(attr.substring(1)));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IOException("No ClassName.");
                }
            }
            throw new IOException("Not a ClassName.");
        }
        throw new IOException("No such attribute.");
    }

    @Override
    public Uid getUidAttribute(String objName, String attrName) throws IOException {
        String attr = arjPropertyManager.getPropertyManager().getProperty(objName + "." + attrName, null);
        if (attr != null) {
            if (attr.charAt(0) == '+') {
                try {
                    return new Uid(new String(attr.substring(1)));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IOException("No Uid.");
                }
            }
            throw new IOException("Not a Uid.");
        }
        throw new IOException("No such attribute.");
    }

    @Override
    public String setLongAttribute(String objName, String attrName, long value) throws IOException {
        arjPropertyManager.getPropertyManager().setProperty(objName + "." + attrName, new String("#" + value));
        return null;
    }

    @Override
    public String setStringAttribute(String objName, String attrName, String value) throws IOException {
        arjPropertyManager.getPropertyManager().setProperty(objName + "." + attrName, new String("^" + value));
        return null;
    }

    @Override
    public String setObjectNameAttribute(String objName, String attrName, ObjectName value) throws IOException {
        arjPropertyManager.getPropertyManager().setProperty(objName + "." + attrName, new String("%" + value.stringForm()));
        return null;
    }

    @Override
    public String setClassNameAttribute(String objName, String attrName, ClassName value) throws IOException {
        arjPropertyManager.getPropertyManager().setProperty(objName + "." + attrName, new String("-" + value.stringForm()));
        return null;
    }

    @Override
    public String setUidAttribute(String objName, String attrName, Uid value) throws IOException {
        arjPropertyManager.getPropertyManager().setProperty(objName + "." + attrName, new String("-" + value.stringForm()));
        return null;
    }

    @Override
    public String removeAttribute(String objName, String attrName) throws IOException {
        return arjPropertyManager.getPropertyManager().removeProperty(objName + "." + attrName);
    }

    @Override
    public String uniqueAttributeName(String objName) throws IOException {
        Uid u = new Uid();
        return u.stringForm();
    }

    @Override
    public ObjectName uniqueObjectName() throws IOException {
        Uid uid = new Uid();
        ObjectName uniqueName = new ObjectName(jnsName + uid.stringForm());
        return uniqueName;
    }

    @Override
    public Object clone() {
        return new JNS();
    }

    @Override
    public ClassName className() {
        return ArjunaNames.Implementation_NameService_JNS();
    }

    public static ClassName name() {
        return ArjunaNames.Implementation_NameService_JNS();
    }
}

